/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.config.storage;

import com.kneaf.core.config.core.ConfigurationProvider;
import com.kneaf.core.config.core.ConfigurationUtils;

public class SwapConfiguration
implements ConfigurationProvider {
    private final boolean enabled;
    private final long memoryCheckIntervalMs;
    private final int maxConcurrentSwaps;
    private final int swapBatchSize;
    private final long swapTimeoutMs;
    private final boolean enableAutomaticSwapping;
    private final double criticalMemoryThreshold;
    private final double highMemoryThreshold;
    private final double elevatedMemoryThreshold;
    private final int minSwapChunkAgeMs;
    private final boolean enableSwapStatistics;
    private final boolean enablePerformanceMonitoring;

    private SwapConfiguration(Builder builder) {
        this.enabled = builder.enabled;
        this.memoryCheckIntervalMs = builder.memoryCheckIntervalMs;
        this.maxConcurrentSwaps = builder.maxConcurrentSwaps;
        this.swapBatchSize = builder.swapBatchSize;
        this.swapTimeoutMs = builder.swapTimeoutMs;
        this.enableAutomaticSwapping = builder.enableAutomaticSwapping;
        this.criticalMemoryThreshold = builder.criticalMemoryThreshold;
        this.highMemoryThreshold = builder.highMemoryThreshold;
        this.elevatedMemoryThreshold = builder.elevatedMemoryThreshold;
        this.minSwapChunkAgeMs = builder.minSwapChunkAgeMs;
        this.enableSwapStatistics = builder.enableSwapStatistics;
        this.enablePerformanceMonitoring = builder.enablePerformanceMonitoring;
        this.validate();
    }

    @Override
    public void validate() {
        ConfigurationUtils.validatePositive(this.memoryCheckIntervalMs, "Memory check interval");
        ConfigurationUtils.validatePositive(this.maxConcurrentSwaps, "Max concurrent swaps");
        ConfigurationUtils.validatePositive(this.swapBatchSize, "Swap batch size");
        ConfigurationUtils.validatePositive(this.swapTimeoutMs, "Swap timeout");
        ConfigurationUtils.validateRange(this.criticalMemoryThreshold, 0.0, 1.0, "Critical memory threshold");
        ConfigurationUtils.validateRange(this.highMemoryThreshold, 0.0, 1.0, "High memory threshold");
        ConfigurationUtils.validateRange(this.elevatedMemoryThreshold, 0.0, 1.0, "Elevated memory threshold");
        ConfigurationUtils.validatePositive(this.minSwapChunkAgeMs, "Min swap chunk age");
        ConfigurationUtils.validateMinMax(this.elevatedMemoryThreshold, this.highMemoryThreshold, "elevatedMemoryThreshold", "highMemoryThreshold");
        ConfigurationUtils.validateMinMax(this.highMemoryThreshold, this.criticalMemoryThreshold, "highMemoryThreshold", "criticalMemoryThreshold");
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public long getMemoryCheckIntervalMs() {
        return this.memoryCheckIntervalMs;
    }

    public int getMaxConcurrentSwaps() {
        return this.maxConcurrentSwaps;
    }

    public int getSwapBatchSize() {
        return this.swapBatchSize;
    }

    public long getSwapTimeoutMs() {
        return this.swapTimeoutMs;
    }

    public boolean isEnableAutomaticSwapping() {
        return this.enableAutomaticSwapping;
    }

    public double getCriticalMemoryThreshold() {
        return this.criticalMemoryThreshold;
    }

    public double getHighMemoryThreshold() {
        return this.highMemoryThreshold;
    }

    public double getElevatedMemoryThreshold() {
        return this.elevatedMemoryThreshold;
    }

    public int getMinSwapChunkAgeMs() {
        return this.minSwapChunkAgeMs;
    }

    public boolean isEnableSwapStatistics() {
        return this.enableSwapStatistics;
    }

    public boolean isEnablePerformanceMonitoring() {
        return this.enablePerformanceMonitoring;
    }

    @Override
    public String toString() {
        return String.format("SwapConfiguration{enabled=%s, memoryCheckIntervalMs=%d, maxConcurrentSwaps=%d, swapBatchSize=%d, swapTimeoutMs=%d, enableAutomaticSwapping=%s, criticalMemoryThreshold=%.2f, highMemoryThreshold=%.2f, elevatedMemoryThreshold=%.2f, minSwapChunkAgeMs=%d, enableSwapStatistics=%s, enablePerformanceMonitoring=%s}", this.enabled, this.memoryCheckIntervalMs, this.maxConcurrentSwaps, this.swapBatchSize, this.swapTimeoutMs, this.enableAutomaticSwapping, this.criticalMemoryThreshold, this.highMemoryThreshold, this.elevatedMemoryThreshold, this.minSwapChunkAgeMs, this.enableSwapStatistics, this.enablePerformanceMonitoring);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private boolean enabled = true;
        private long memoryCheckIntervalMs = 5000L;
        private int maxConcurrentSwaps = 10;
        private int swapBatchSize = 50;
        private long swapTimeoutMs = 30000L;
        private boolean enableAutomaticSwapping = true;
        private double criticalMemoryThreshold = 0.95;
        private double highMemoryThreshold = 0.85;
        private double elevatedMemoryThreshold = 0.75;
        private int minSwapChunkAgeMs = 60000;
        private boolean enableSwapStatistics = true;
        private boolean enablePerformanceMonitoring = true;

        public Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder memoryCheckIntervalMs(long memoryCheckIntervalMs) {
            this.memoryCheckIntervalMs = memoryCheckIntervalMs;
            return this;
        }

        public Builder maxConcurrentSwaps(int maxConcurrentSwaps) {
            this.maxConcurrentSwaps = maxConcurrentSwaps;
            return this;
        }

        public Builder swapBatchSize(int swapBatchSize) {
            this.swapBatchSize = swapBatchSize;
            return this;
        }

        public Builder swapTimeoutMs(long swapTimeoutMs) {
            this.swapTimeoutMs = swapTimeoutMs;
            return this;
        }

        public Builder enableAutomaticSwapping(boolean enableAutomaticSwapping) {
            this.enableAutomaticSwapping = enableAutomaticSwapping;
            return this;
        }

        public Builder criticalMemoryThreshold(double criticalMemoryThreshold) {
            this.criticalMemoryThreshold = criticalMemoryThreshold;
            return this;
        }

        public Builder highMemoryThreshold(double highMemoryThreshold) {
            this.highMemoryThreshold = highMemoryThreshold;
            return this;
        }

        public Builder elevatedMemoryThreshold(double elevatedMemoryThreshold) {
            this.elevatedMemoryThreshold = elevatedMemoryThreshold;
            return this;
        }

        public Builder minSwapChunkAgeMs(int minSwapChunkAgeMs) {
            this.minSwapChunkAgeMs = minSwapChunkAgeMs;
            return this;
        }

        public Builder enableSwapStatistics(boolean enableSwapStatistics) {
            this.enableSwapStatistics = enableSwapStatistics;
            return this;
        }

        public Builder enablePerformanceMonitoring(boolean enablePerformanceMonitoring) {
            this.enablePerformanceMonitoring = enablePerformanceMonitoring;
            return this;
        }

        public SwapConfiguration build() {
            return new SwapConfiguration(this);
        }
    }
}

