/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.data.core;

import com.kneaf.core.data.core.DataValidationException;

public final class DataUtils {
    private DataUtils() {
    }

    public static void validateCoordinate(double coordinate, String fieldName) {
        if (coordinate < -3.0E7 || coordinate > 3.0E7) {
            throw new DataValidationException(fieldName, coordinate, String.format("Coordinate must be between %.1f and %.1f", -3.0E7, 3.0E7));
        }
    }

    public static void validateChunkCoordinate(int chunkCoordinate, String fieldName) {
        if (chunkCoordinate < -1875000 || chunkCoordinate > 1875000) {
            throw new DataValidationException(fieldName, chunkCoordinate, String.format("Chunk coordinate must be between %d and %d", -1875000, 1875000));
        }
    }

    public static void validateDistance(double distance, String fieldName) {
        if (distance < 0.0 || distance > 1000000.0) {
            throw new DataValidationException(fieldName, distance, String.format("Distance must be between %.1f and %.1f", 0.0, 1000000.0));
        }
    }

    public static void validateItemCount(int count, String fieldName) {
        if (count < 1 || count > 64) {
            throw new DataValidationException(fieldName, count, String.format("Item count must be between %d and %d", 1, 64));
        }
    }

    public static void validateItemAge(int age, String fieldName) {
        if (age < 0 || age > 6000) {
            throw new DataValidationException(fieldName, age, String.format("Item age must be between %d and %d", 0, 6000));
        }
    }

    public static void validateNotEmpty(String value, String fieldName) {
        if (value == null || value.trim().isEmpty()) {
            throw new DataValidationException(fieldName, value, "String must not be null or empty");
        }
    }

    public static void validateNonNegative(long value, String fieldName) {
        if (value < 0L) {
            throw new DataValidationException(fieldName, value, "Value must not be negative");
        }
    }

    public static void validateNonNegative(int value, String fieldName) {
        if (value < 0) {
            throw new DataValidationException(fieldName, value, "Value must not be negative");
        }
    }

    public static double calculateDistance(double x1, double y1, double z1, double x2, double y2, double z2) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        double dz = z2 - z1;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }
}

