/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.data.entity;

import com.kneaf.core.data.core.DataEntity;
import com.kneaf.core.data.core.DataUtils;
import com.kneaf.core.data.core.Positionable;

public abstract class BaseEntityData
implements DataEntity,
Positionable {
    protected final long id;
    protected final double x;
    protected final double y;
    protected final double z;
    protected final String entityType;

    protected BaseEntityData(long id, double x, double y, double z, String entityType) {
        this.id = id;
        this.x = x;
        this.y = y;
        this.z = z;
        this.entityType = entityType;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public double getZ() {
        return this.z;
    }

    @Override
    public String getType() {
        return this.entityType;
    }

    @Override
    public boolean validate() {
        DataUtils.validateNonNegative(this.id, "id");
        DataUtils.validateCoordinate(this.x, "x");
        DataUtils.validateCoordinate(this.y, "y");
        DataUtils.validateCoordinate(this.z, "z");
        DataUtils.validateNotEmpty(this.entityType, "entityType");
        return true;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BaseEntityData that = (BaseEntityData)obj;
        return this.id == that.id;
    }

    public int hashCode() {
        return Long.hashCode(this.id);
    }

    public String toString() {
        return String.format("%s{id=%d, x=%.2f, y=%.2f, z=%.2f, type='%s'}", this.getClass().getSimpleName(), this.id, this.x, this.y, this.z, this.entityType);
    }
}

