/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.data.entity;

import com.kneaf.core.data.core.DataValidationException;
import com.kneaf.core.data.entity.BaseEntityData;

public abstract class BaseLivingEntityData
extends BaseEntityData {
    protected final double health;
    protected final double maxHealth;
    protected final boolean isAlive;

    protected BaseLivingEntityData(long id, double x, double y, double z, String entityType, double health, double maxHealth, boolean isAlive) {
        super(id, x, y, z, entityType);
        this.health = health;
        this.maxHealth = maxHealth;
        this.isAlive = isAlive;
    }

    public double getHealth() {
        return this.health;
    }

    public double getMaxHealth() {
        return this.maxHealth;
    }

    public boolean isAlive() {
        return this.isAlive;
    }

    @Override
    public boolean validate() {
        super.validate();
        if (this.health < 0.0) {
            throw new DataValidationException("health", this.health, "Health must not be negative");
        }
        if (this.maxHealth <= 0.0) {
            throw new DataValidationException("maxHealth", this.maxHealth, "Max health must be positive");
        }
        if (this.health > this.maxHealth) {
            throw new DataValidationException("health", this.health, String.format("Health (%.2f) cannot exceed max health (%.2f)", this.health, this.maxHealth));
        }
        return true;
    }

    public double getHealthPercentage() {
        return this.maxHealth > 0.0 ? this.health / this.maxHealth : 0.0;
    }

    public boolean isAtFullHealth() {
        return Double.compare(this.health, this.maxHealth) == 0;
    }

    public boolean isCriticallyInjured() {
        return this.getHealthPercentage() < 0.2;
    }
}

