/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.data.entity;

import com.kneaf.core.data.core.DataUtils;
import com.kneaf.core.data.entity.BaseEntityData;

public class EntityData
extends BaseEntityData {
    private final double distance;
    private final boolean isBlockEntity;

    public EntityData(long id, double x, double y, double z, double distance, boolean isBlockEntity, String entityType) {
        super(id, x, y, z, entityType);
        this.distance = distance;
        this.isBlockEntity = isBlockEntity;
    }

    public double getDistance() {
        return this.distance;
    }

    public boolean isBlockEntity() {
        return this.isBlockEntity;
    }

    @Override
    public boolean validate() {
        super.validate();
        DataUtils.validateDistance(this.distance, "distance");
        DataUtils.validateNotEmpty(this.entityType, "entityType");
        return true;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private long id;
        private double x;
        private double y;
        private double z;
        private double distance = 0.0;
        private boolean isBlockEntity = false;
        private String entityType = "";

        public Builder id(long id) {
            this.id = id;
            return this;
        }

        public Builder position(double x, double y, double z) {
            this.x = x;
            this.y = y;
            this.z = z;
            return this;
        }

        public Builder distance(double distance) {
            this.distance = distance;
            return this;
        }

        public Builder isBlockEntity(boolean isBlockEntity) {
            this.isBlockEntity = isBlockEntity;
            return this;
        }

        public Builder entityType(String entityType) {
            this.entityType = entityType;
            return this;
        }

        public EntityData build() {
            return new EntityData(this.id, this.x, this.y, this.z, this.distance, this.isBlockEntity, this.entityType);
        }
    }
}

