/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.data.entity;

import com.kneaf.core.data.core.DataUtils;
import com.kneaf.core.data.entity.BaseEntityData;

public class MobData
extends BaseEntityData {
    private final double distance;
    private final boolean isPassive;

    public MobData(long id, double distance, boolean isPassive, String entityType) {
        super(id, 0.0, 0.0, 0.0, entityType);
        this.distance = distance;
        this.isPassive = isPassive;
    }

    public double getDistance() {
        return this.distance;
    }

    public boolean isPassive() {
        return this.isPassive;
    }

    @Override
    public boolean validate() {
        super.validate();
        DataUtils.validateDistance(this.distance, "distance");
        DataUtils.validateNotEmpty(this.entityType, "entityType");
        return true;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private long id;
        private double distance = 0.0;
        private boolean isPassive = true;
        private String entityType = "";

        public Builder id(long id) {
            this.id = id;
            return this;
        }

        public Builder distance(double distance) {
            this.distance = distance;
            return this;
        }

        public Builder isPassive(boolean isPassive) {
            this.isPassive = isPassive;
            return this;
        }

        public Builder entityType(String entityType) {
            this.entityType = entityType;
            return this;
        }

        public MobData build() {
            return new MobData(this.id, this.distance, this.isPassive, this.entityType);
        }
    }
}

