/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.data.item;

import com.kneaf.core.data.core.DataEntity;
import com.kneaf.core.data.core.DataUtils;

public class ItemEntityData
implements DataEntity {
    private final long id;
    private final int chunkX;
    private final int chunkZ;
    private final String itemType;
    private final int count;
    private final int ageSeconds;

    public ItemEntityData(long id, int chunkX, int chunkZ, String itemType, int count, int ageSeconds) {
        this.id = id;
        this.chunkX = chunkX;
        this.chunkZ = chunkZ;
        this.itemType = itemType;
        this.count = count;
        this.ageSeconds = ageSeconds;
        this.validate();
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public String getType() {
        return "item";
    }

    public int getChunkX() {
        return this.chunkX;
    }

    public int getChunkZ() {
        return this.chunkZ;
    }

    public String getItemType() {
        return this.itemType;
    }

    public int getCount() {
        return this.count;
    }

    public int getAgeSeconds() {
        return this.ageSeconds;
    }

    @Override
    public boolean validate() {
        DataUtils.validateNonNegative(this.id, "id");
        DataUtils.validateChunkCoordinate(this.chunkX, "chunkX");
        DataUtils.validateChunkCoordinate(this.chunkZ, "chunkZ");
        DataUtils.validateNotEmpty(this.itemType, "itemType");
        DataUtils.validateItemCount(this.count, "count");
        DataUtils.validateItemAge(this.ageSeconds, "ageSeconds");
        return true;
    }

    public boolean shouldDespawn() {
        return this.ageSeconds >= 6000;
    }

    public boolean canMergeWith(ItemEntityData other) {
        if (other == null) {
            return false;
        }
        return this.itemType.equals(other.itemType) && this.chunkX == other.chunkX && this.chunkZ == other.chunkZ && this.count + other.count <= 64;
    }

    public ItemEntityData mergeWith(ItemEntityData other) {
        if (!this.canMergeWith(other)) {
            throw new IllegalArgumentException("Items cannot be merged");
        }
        return new ItemEntityData(this.id, this.chunkX, this.chunkZ, this.itemType, this.count + other.count, this.ageSeconds);
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ItemEntityData that = (ItemEntityData)obj;
        return this.id == that.id;
    }

    public int hashCode() {
        return Long.hashCode(this.id);
    }

    public String toString() {
        return String.format("ItemEntityData{id=%d, chunk=[%d,%d], type='%s', count=%d, age=%ds}", this.id, this.chunkX, this.chunkZ, this.itemType, this.count, this.ageSeconds);
    }

    public static class Builder {
        private long id;
        private int chunkX;
        private int chunkZ;
        private String itemType = "";
        private int count = 1;
        private int ageSeconds = 0;

        public Builder id(long id) {
            this.id = id;
            return this;
        }

        public Builder chunkPosition(int chunkX, int chunkZ) {
            this.chunkX = chunkX;
            this.chunkZ = chunkZ;
            return this;
        }

        public Builder itemType(String itemType) {
            this.itemType = itemType;
            return this;
        }

        public Builder count(int count) {
            this.count = count;
            return this;
        }

        public Builder ageSeconds(int ageSeconds) {
            this.ageSeconds = ageSeconds;
            return this;
        }

        public ItemEntityData build() {
            return new ItemEntityData(this.id, this.chunkX, this.chunkZ, this.itemType, this.count, this.ageSeconds);
        }
    }
}

