/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.exceptions.core;

import com.kneaf.core.exceptions.utils.ExceptionContext;
import com.kneaf.core.exceptions.utils.ExceptionSeverity;

public abstract class BaseKneafException
extends RuntimeException {
    private final String errorCode;
    private final ExceptionSeverity severity;
    private final ExceptionContext context;
    private final String suggestion;
    private final boolean logged;

    protected BaseKneafException(Builder<?> builder) {
        super(builder.message, builder.cause);
        this.errorCode = builder.errorCode;
        this.severity = builder.severity;
        this.context = builder.context;
        this.suggestion = builder.suggestion;
        this.logged = builder.logged;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public ExceptionSeverity getSeverity() {
        return this.severity;
    }

    public ExceptionContext getContext() {
        return this.context;
    }

    public String getSuggestion() {
        return this.suggestion;
    }

    public boolean isLogged() {
        return this.logged;
    }

    public abstract BaseKneafException withContext(ExceptionContext var1);

    public abstract BaseKneafException withSuggestion(String var1);

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append(": ");
        if (this.errorCode != null) {
            sb.append("[").append(this.errorCode).append("] ");
        }
        sb.append(this.getMessage());
        if (this.severity != null) {
            sb.append(" [Severity: ").append(this.severity.getName()).append("]");
        }
        if (this.context != null) {
            sb.append(" ").append(this.context.toString());
        }
        if (this.suggestion != null) {
            sb.append(" [Suggestion: ").append(this.suggestion).append("]");
        }
        if (this.getCause() != null) {
            sb.append(" [Cause: ").append(this.getCause().getMessage()).append("]");
        }
        return sb.toString();
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String message;
        protected Throwable cause;
        protected String errorCode;
        protected ExceptionSeverity severity = ExceptionSeverity.ERROR;
        protected ExceptionContext context;
        protected String suggestion;
        protected boolean logged = false;

        protected abstract T self();

        public T message(String message) {
            this.message = message;
            return this.self();
        }

        public T cause(Throwable cause) {
            this.cause = cause;
            return this.self();
        }

        public T errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this.self();
        }

        public T severity(ExceptionSeverity severity) {
            this.severity = severity;
            return this.self();
        }

        public T context(ExceptionContext context) {
            this.context = context;
            return this.self();
        }

        public T suggestion(String suggestion) {
            this.suggestion = suggestion;
            return this.self();
        }

        public T logged(boolean logged) {
            this.logged = logged;
            return this.self();
        }

        protected void validate() {
            if (this.message == null || this.message.trim().isEmpty()) {
                throw new IllegalArgumentException("Exception message cannot be null or empty");
            }
        }
    }
}

