/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.exceptions.nativelib;

import com.kneaf.core.exceptions.core.BaseKneafException;
import com.kneaf.core.exceptions.utils.ExceptionContext;
import com.kneaf.core.exceptions.utils.ExceptionSeverity;

public class NativeLibraryException
extends BaseKneafException {
    private final NativeErrorType errorType;
    private final String libraryName;
    private final String nativeMethod;

    private NativeLibraryException(Builder builder) {
        super(builder);
        this.errorType = builder.errorType;
        this.libraryName = builder.libraryName;
        this.nativeMethod = builder.nativeMethod;
    }

    public NativeErrorType getErrorType() {
        return this.errorType;
    }

    public String getLibraryName() {
        return this.libraryName;
    }

    public String getNativeMethod() {
        return this.nativeMethod;
    }

    @Override
    public NativeLibraryException withContext(ExceptionContext context) {
        return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)new Builder().message(this.getMessage())).cause(this.getCause())).errorCode(this.getErrorCode())).severity(this.getSeverity())).context(context)).suggestion(this.getSuggestion())).logged(this.isLogged())).errorType(this.errorType).libraryName(this.libraryName).nativeMethod(this.nativeMethod).build();
    }

    @Override
    public NativeLibraryException withSuggestion(String suggestion) {
        return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)new Builder().message(this.getMessage())).cause(this.getCause())).errorCode(this.getErrorCode())).severity(this.getSeverity())).context(this.getContext())).suggestion(suggestion)).logged(this.isLogged())).errorType(this.errorType).libraryName(this.libraryName).nativeMethod(this.nativeMethod).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static NativeLibraryException libraryNotAvailable(String libraryName) {
        return ((Builder)((Builder)((Builder)NativeLibraryException.builder().errorType(NativeErrorType.LIBRARY_NOT_AVAILABLE).libraryName(libraryName).message(String.format("Native library '%s' is not available", libraryName))).severity(ExceptionSeverity.ERROR)).suggestion("Check external dependencies and services")).build();
    }

    public static NativeLibraryException binaryProtocolError(String operation, String details, Throwable cause) {
        return ((Builder)((Builder)((Builder)((Builder)NativeLibraryException.builder().errorType(NativeErrorType.BINARY_PROTOCOL_ERROR).libraryName("rustperf").nativeMethod(operation).message(String.format("Binary protocol error in %s: %s", operation, details))).cause(cause)).severity(ExceptionSeverity.ERROR)).suggestion("Check application logs for detailed error information")).build();
    }

    public static NativeLibraryException jniError(String libraryName, String method, String message, Throwable cause) {
        return ((Builder)((Builder)((Builder)((Builder)NativeLibraryException.builder().errorType(NativeErrorType.JNI_ERROR).libraryName(libraryName).nativeMethod(method).message(message)).cause(cause)).severity(ExceptionSeverity.ERROR)).suggestion("Contact system administrator or support team")).build();
    }

    public static NativeLibraryException memoryAllocationFailed(String libraryName, String operation, String details) {
        return ((Builder)((Builder)((Builder)NativeLibraryException.builder().errorType(NativeErrorType.MEMORY_ALLOCATION_FAILED).libraryName(libraryName).nativeMethod(operation).message(String.format("Native memory allocation failed in %s: %s", operation, details))).severity(ExceptionSeverity.CRITICAL)).suggestion("Check system resources (memory, disk space, network)")).build();
    }

    public static class Builder
    extends BaseKneafException.Builder<Builder> {
        private NativeErrorType errorType;
        private String libraryName;
        private String nativeMethod;

        @Override
        protected Builder self() {
            return this;
        }

        public Builder errorType(NativeErrorType errorType) {
            this.errorType = errorType;
            return this;
        }

        public Builder libraryName(String libraryName) {
            this.libraryName = libraryName;
            return this;
        }

        public Builder nativeMethod(String nativeMethod) {
            this.nativeMethod = nativeMethod;
            return this;
        }

        @Override
        protected void validate() {
            super.validate();
            if (this.errorType == null) {
                throw new IllegalArgumentException("Error type cannot be null");
            }
        }

        public NativeLibraryException build() {
            this.validate();
            if (this.errorCode == null && this.errorType != null) {
                this.errorCode = this.errorType.getErrorCode();
            }
            if (this.severity == null) {
                this.severity = ExceptionSeverity.ERROR;
            }
            return new NativeLibraryException(this);
        }
    }

    public static enum NativeErrorType {
        LIBRARY_NOT_AVAILABLE("NAT001", "Native library is not available"),
        LIBRARY_LOAD_FAILED("NAT002", "Failed to load native library"),
        NATIVE_CALL_FAILED("NAT003", "Native method call failed"),
        BINARY_PROTOCOL_ERROR("NAT004", "Binary protocol error"),
        JNI_ERROR("NAT004", "JNI error"),
        MEMORY_ALLOCATION_FAILED("NAT005", "Native memory allocation failed");

        private final String errorCode;
        private final String description;

        private NativeErrorType(String errorCode, String description) {
            this.errorCode = errorCode;
            this.description = description;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

