/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.exceptions.utils;

import com.kneaf.core.exceptions.utils.ExceptionContext;
import com.kneaf.core.exceptions.utils.ExceptionSeverity;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExceptionUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExceptionUtils.class);

    private ExceptionUtils() {
        throw new AssertionError((Object)"Cannot instantiate utility class");
    }

    public static String getStackTraceAsString(Throwable throwable) {
        if (throwable == null) {
            return "";
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        throwable.printStackTrace(pw);
        return sw.toString();
    }

    public static Throwable getRootCause(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        Throwable cause = throwable.getCause();
        while (cause != null && cause != throwable) {
            throwable = cause;
            cause = throwable.getCause();
        }
        return throwable;
    }

    public static boolean hasCause(Throwable throwable, Class<? extends Throwable> causeType) {
        if (throwable == null || causeType == null) {
            return false;
        }
        for (Throwable current = throwable; current != null; current = current.getCause()) {
            if (!causeType.isInstance(current)) continue;
            return true;
        }
        return false;
    }

    public static String formatErrorMessage(String message, ExceptionContext context) {
        if (message == null) {
            message = "Unknown error";
        }
        StringBuilder sb = new StringBuilder(message);
        if (context != null) {
            if (context.getOperation() != null) {
                sb.append(" [Operation: ").append(context.getOperation()).append("]");
            }
            if (context.getComponent() != null) {
                sb.append(" [Component: ").append(context.getComponent()).append("]");
            }
            if (context.getMethod() != null) {
                sb.append(" [Method: ").append(context.getMethod()).append("]");
            }
            if (context.getLineNumber() > 0) {
                sb.append(" [Line: ").append(context.getLineNumber()).append("]");
            }
            if (!context.getContextData().isEmpty()) {
                sb.append(" [Context: ").append(context.getContextData()).append("]");
            }
        }
        return sb.toString();
    }

    public static void logException(Logger logger, ExceptionSeverity severity, String message, Throwable throwable) {
        String formattedMessage = ExceptionUtils.formatErrorMessage(message, null);
        switch (severity) {
            case CRITICAL: {
                logger.error("CRITICAL: { }", (Object)formattedMessage, (Object)throwable);
                break;
            }
            case ERROR: {
                logger.error("ERROR: { }", (Object)formattedMessage, (Object)throwable);
                break;
            }
            case WARNING: {
                logger.warn("WARNING: { }", (Object)formattedMessage, (Object)throwable);
                break;
            }
            case INFO: {
                logger.info("INFO: { }", (Object)formattedMessage, (Object)throwable);
                break;
            }
            case DEBUG: {
                logger.debug("DEBUG: { }", (Object)formattedMessage, (Object)throwable);
                break;
            }
            default: {
                logger.error("UNKNOWN SEVERITY: { }", (Object)formattedMessage, (Object)throwable);
            }
        }
    }

    public static void logExceptionWithContext(Logger logger, ExceptionSeverity severity, String message, Throwable throwable, ExceptionContext context) {
        String formattedMessage = ExceptionUtils.formatErrorMessage(message, context);
        ExceptionUtils.logException(logger, severity, formattedMessage, throwable);
    }

    public static Map<String, Object> createContext(Object ... keyValuePairs) {
        if (keyValuePairs == null || keyValuePairs.length % 2 != 0) {
            throw new IllegalArgumentException("Key-value pairs must be provided in pairs");
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        for (int i = 0; i < keyValuePairs.length; i += 2) {
            String key = String.valueOf(keyValuePairs[i]);
            Object value = keyValuePairs[i + 1];
            context.put(key, value);
        }
        return context;
    }

    public static void safeExecute(Runnable runnable, String operationName) {
        ExceptionUtils.safeExecute(runnable, operationName, ExceptionSeverity.ERROR);
    }

    public static void safeExecute(Runnable runnable, String operationName, ExceptionSeverity severity) {
        try {
            runnable.run();
        }
        catch (Exception e) {
            ExceptionUtils.logException(LOGGER, severity, String.format("Safe execution failed for operation: %s", operationName), e);
        }
    }

    public static String createUserFriendlyMessage(String technicalMessage, String suggestion) {
        if (technicalMessage == null) {
            technicalMessage = "An unexpected error occurred";
        }
        if (suggestion == null) {
            return technicalMessage;
        }
        return String.format("%s. Suggestion: %s", technicalMessage, suggestion);
    }

    public static ExceptionSeverity determineSeverity(Throwable throwable) {
        if (throwable == null) {
            return ExceptionSeverity.INFO;
        }
        String className = throwable.getClass().getSimpleName();
        if (className.contains("OutOfMemoryError") || className.contains("StackOverflowError") || className.contains("VirtualMachineError")) {
            return ExceptionSeverity.CRITICAL;
        }
        if (className.contains("Exception") && !className.contains("RuntimeException")) {
            return ExceptionSeverity.ERROR;
        }
        return ExceptionSeverity.WARNING;
    }
}

