/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.performance;

import com.google.gson.Gson;
import com.kneaf.core.KneafCore;
import com.kneaf.core.binary.ManualSerializers;
import com.kneaf.core.data.block.BlockEntityData;
import com.kneaf.core.data.entity.MobData;
import com.kneaf.core.data.item.ItemEntityData;
import com.kneaf.core.performance.NativeBridge;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;

public class EnhancedNativeBridge {
    private static final int BUFFER_SIZE = 65536;
    private static final int MAX_BUFFERS = 16;
    private static final List<ByteBuffer> SHARED_BUFFERS = new ArrayList<ByteBuffer>();
    private static final AtomicLong BUFFER_USAGE_COUNT = new AtomicLong(0L);
    private static final AtomicLong TOTAL_BATCHES_PROCESSED = new AtomicLong(0L);
    private static final AtomicLong TOTAL_JNI_CALLS_SAVED = new AtomicLong(0L);
    private static final AtomicLong TOTAL_MEMORY_COPIES_AVOIDED = new AtomicLong(0L);
    private long workerHandle = 0L;
    private final ExecutorService callbackExecutor = Executors.newCachedThreadPool(r -> {
        Thread t = new Thread(r, "enhanced-bridge-callback");
        t.setDaemon(true);
        return t;
    });

    public EnhancedNativeBridge() {
        try {
            this.workerHandle = NativeBridge.createOptimizedWorker(4);
            if (this.workerHandle == 0L) {
                throw new RuntimeException("Failed to create optimized worker for EnhancedNativeBridge");
            }
            KneafCore.LOGGER.info("EnhancedNativeBridge created with worker handle: {}", (Object)this.workerHandle);
        }
        catch (Exception e) {
            KneafCore.LOGGER.error("Failed to initialize EnhancedNativeBridge", (Throwable)e);
            throw new RuntimeException("EnhancedNativeBridge initialization failed", e);
        }
    }

    public void processBatchAsync(Object entityData, Consumer<BatchResult> callback) {
        this.processBatchAsync(entityData, 30000L, callback);
    }

    public void processBatchAsync(Object entityData, long timeoutMs, Consumer<BatchResult> callback) {
        if (entityData == null) {
            this.callbackExecutor.execute(() -> callback.accept(BatchResult.failure("Entity data cannot be null")));
            return;
        }
        ((CompletableFuture)CompletableFuture.supplyAsync(() -> this.processBatchInternal(entityData, timeoutMs), this.callbackExecutor).thenAcceptAsync((Consumer)callback, (Executor)this.callbackExecutor)).exceptionally(throwable -> {
            this.callbackExecutor.execute(() -> callback.accept(BatchResult.failure("Async processing failed: " + throwable.getMessage())));
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BatchResult processBatchInternal(Object entityData, long timeoutMs) {
        long startTime = System.nanoTime();
        try {
            ByteBuffer sharedBuffer = this.acquireSharedBuffer();
            if (sharedBuffer == null) {
                return BatchResult.failure("No shared buffers available");
            }
            try {
                sharedBuffer.clear();
                int serializedSize = this.serializeEntityData(entityData, sharedBuffer);
                if (serializedSize == 0) {
                    BatchResult batchResult = BatchResult.failure("Failed to serialize entity data");
                    return batchResult;
                }
                sharedBuffer.flip();
                byte[] resultBytes = this.performBatchJNI(sharedBuffer, timeoutMs);
                TOTAL_BATCHES_PROCESSED.incrementAndGet();
                TOTAL_JNI_CALLS_SAVED.addAndGet(this.calculateJNICallsSaved(entityData));
                TOTAL_MEMORY_COPIES_AVOIDED.addAndGet(serializedSize);
                long processingTimeNs = System.nanoTime() - startTime;
                double processingTimeMs = (double)processingTimeNs / 1000000.0;
                KneafCore.LOGGER.debug("Batch processed in {:.2f}ms, saved {} JNI calls", (Object)processingTimeMs, (Object)this.calculateJNICallsSaved(entityData));
                BatchResult batchResult = BatchResult.success(resultBytes, processingTimeMs);
                return batchResult;
            }
            finally {
                this.releaseSharedBuffer(sharedBuffer);
            }
        }
        catch (Exception e) {
            long processingTimeNs2 = System.nanoTime() - startTime;
            double processingTimeMs2 = (double)processingTimeNs2 / 1000000.0;
            KneafCore.LOGGER.error("Batch processing failed after {:.2f}ms", (Object)processingTimeMs2, (Object)e);
            return BatchResult.failure("Processing failed: " + e.getMessage());
        }
    }

    private ByteBuffer acquireSharedBuffer() {
        for (ByteBuffer buffer : SHARED_BUFFERS) {
            if (buffer.position() != 0) continue;
            BUFFER_USAGE_COUNT.incrementAndGet();
            return buffer;
        }
        return null;
    }

    private void releaseSharedBuffer(ByteBuffer buffer) {
        if (buffer != null) {
            buffer.clear();
            BUFFER_USAGE_COUNT.decrementAndGet();
        }
    }

    private int serializeEntityData(Object entityData, ByteBuffer buffer) {
        try {
            if (entityData instanceof List) {
                List dataList = (List)entityData;
                if (dataList.isEmpty()) {
                    return 0;
                }
                Object firstElement = dataList.get(0);
                if (firstElement instanceof ItemEntityData) {
                    List items = dataList;
                    return this.serializeItemBatch(items, buffer);
                }
                if (firstElement instanceof MobData) {
                    List mobs = dataList;
                    return this.serializeMobBatch(mobs, buffer);
                }
                if (firstElement instanceof BlockEntityData) {
                    List blocks = dataList;
                    return this.serializeBlockBatch(blocks, buffer);
                }
            }
            String jsonData = new Gson().toJson(entityData);
            byte[] jsonBytes = jsonData.getBytes(StandardCharsets.UTF_8);
            if (buffer.remaining() < jsonBytes.length + 4) {
                return 0;
            }
            buffer.putInt(jsonBytes.length);
            buffer.put(jsonBytes);
            return jsonBytes.length + 4;
        }
        catch (Exception e) {
            KneafCore.LOGGER.warn("Failed to serialize entity data", (Throwable)e);
            return 0;
        }
    }

    private int serializeItemBatch(List<ItemEntityData> items, ByteBuffer buffer) {
        try {
            ByteBuffer tempBuffer = ManualSerializers.serializeItemInput(0L, items);
            if (tempBuffer.remaining() > buffer.remaining()) {
                return 0;
            }
            int size = tempBuffer.remaining();
            buffer.put(tempBuffer);
            return size;
        }
        catch (Exception e) {
            KneafCore.LOGGER.warn("Failed to serialize item batch", (Throwable)e);
            return 0;
        }
    }

    private int serializeMobBatch(List<MobData> mobs, ByteBuffer buffer) {
        try {
            ByteBuffer tempBuffer = ManualSerializers.serializeMobInput(0L, mobs);
            if (tempBuffer.remaining() > buffer.remaining()) {
                return 0;
            }
            int size = tempBuffer.remaining();
            buffer.put(tempBuffer);
            return size;
        }
        catch (Exception e) {
            KneafCore.LOGGER.warn("Failed to serialize mob batch", (Throwable)e);
            return 0;
        }
    }

    private int serializeBlockBatch(List<BlockEntityData> blocks, ByteBuffer buffer) {
        try {
            ByteBuffer tempBuffer = ManualSerializers.serializeBlockInput(0L, blocks);
            if (tempBuffer.remaining() > buffer.remaining()) {
                return 0;
            }
            int size = tempBuffer.remaining();
            buffer.put(tempBuffer);
            return size;
        }
        catch (Exception e) {
            KneafCore.LOGGER.warn("Failed to serialize block batch", (Throwable)e);
            return 0;
        }
    }

    private byte[] performBatchJNI(ByteBuffer inputBuffer, long timeoutMs) throws Exception {
        long deadline = System.currentTimeMillis() + timeoutMs;
        NativeBridge.nativePushTaskBuffer(this.workerHandle, inputBuffer);
        byte[] result = null;
        while (System.currentTimeMillis() < deadline && (result = NativeBridge.nativePollResult(this.workerHandle)) == null) {
            Thread.sleep(10L);
        }
        if (result == null) {
            throw new RuntimeException("Batch processing timeout after " + timeoutMs + "ms");
        }
        return result;
    }

    private int calculateJNICallsSaved(Object entityData) {
        if (entityData instanceof List) {
            return ((List)entityData).size();
        }
        return 1;
    }

    public static Map<String, Object> getEnhancedBatchMetrics() {
        ConcurrentHashMap<String, Object> metrics = new ConcurrentHashMap<String, Object>();
        metrics.put("totalBatchesProcessed", TOTAL_BATCHES_PROCESSED.get());
        metrics.put("totalJNICallsSaved", TOTAL_JNI_CALLS_SAVED.get());
        metrics.put("totalMemoryCopiesAvoided", TOTAL_MEMORY_COPIES_AVOIDED.get());
        metrics.put("currentBufferUsage", BUFFER_USAGE_COUNT.get());
        metrics.put("maxBuffers", 16);
        metrics.put("bufferSize", 65536);
        return metrics;
    }

    public void shutdown() {
        try {
            if (this.workerHandle != 0L) {
                NativeBridge.destroyOptimizedWorker(this.workerHandle);
                this.workerHandle = 0L;
            }
        }
        catch (Exception e) {
            KneafCore.LOGGER.warn("Error during bridge shutdown", (Throwable)e);
        }
        this.callbackExecutor.shutdown();
        try {
            if (!this.callbackExecutor.awaitTermination(5L, TimeUnit.SECONDS)) {
                this.callbackExecutor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.callbackExecutor.shutdownNow();
            Thread.currentThread().interrupt();
        }
        KneafCore.LOGGER.info("EnhancedNativeBridge shutdown complete");
    }

    static {
        for (int i = 0; i < 16; ++i) {
            try {
                ByteBuffer buffer = ByteBuffer.allocateDirect(65536);
                buffer.order(ByteOrder.LITTLE_ENDIAN);
                SHARED_BUFFERS.add(buffer);
                continue;
            }
            catch (Exception e) {
                KneafCore.LOGGER.warn("Failed to allocate shared buffer {}: {}", (Object)i, (Object)e.getMessage());
            }
        }
        KneafCore.LOGGER.info("EnhancedNativeBridge initialized with {} shared buffers", (Object)SHARED_BUFFERS.size());
    }

    public static class BatchResult {
        private final boolean success;
        private final byte[] data;
        private final String errorMessage;
        private final double processingTimeMs;

        private BatchResult(boolean success, byte[] data, String errorMessage, double processingTimeMs) {
            this.success = success;
            this.data = data;
            this.errorMessage = errorMessage;
            this.processingTimeMs = processingTimeMs;
        }

        public static BatchResult success(byte[] data, double processingTimeMs) {
            return new BatchResult(true, data, null, processingTimeMs);
        }

        public static BatchResult failure(String errorMessage) {
            return new BatchResult(false, null, errorMessage, 0.0);
        }

        public boolean isSuccess() {
            return this.success;
        }

        public byte[] getData() {
            return this.data;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public double getProcessingTimeMs() {
            return this.processingTimeMs;
        }
    }
}

