/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.performance;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.kneaf.core.KneafCore;
import com.kneaf.core.data.block.BlockEntityData;
import com.kneaf.core.data.entity.EntityData;
import com.kneaf.core.data.entity.MobData;
import com.kneaf.core.data.entity.PlayerData;
import com.kneaf.core.data.entity.VillagerData;
import com.kneaf.core.data.item.ItemEntityData;
import com.kneaf.core.performance.NativeFloatBufferAllocation;
import com.kneaf.core.performance.VillagerGroup;
import com.kneaf.core.performance.VillagerProcessResult;
import com.kneaf.core.performance.bridge.NativeIntegrationManager;
import com.kneaf.core.performance.core.ItemProcessResult;
import com.kneaf.core.performance.core.MobProcessResult;
import com.kneaf.core.performance.core.PerformanceProcessor;
import com.kneaf.core.performance.core.RustPerformanceFacade;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class RustPerformance {
    private static final RustPerformanceFacade FACADE = RustPerformanceFacade.getInstance();
    private static final NativeIntegrationManager NATIVE_MANAGER = new NativeIntegrationManager();
    private static boolean initialized = false;

    public static void initialize() {
        if (!initialized) {
            try {
                FACADE.initialize();
                initialized = true;
                KneafCore.LOGGER.info("RustPerformance initialized successfully");
            }
            catch (Exception e) {
                KneafCore.LOGGER.error("Failed to initialize RustPerformance", (Throwable)e);
                throw new RuntimeException("Failed to initialize performance system", e);
            }
        }
    }

    public static CompletableFuture<List<Long>> getEntitiesToTickAsync(List<EntityData> entities, List<PlayerData> players) {
        RustPerformance.ensureInitialized();
        return FACADE.getEntitiesToTick(entities, players);
    }

    public static List<Long> getEntitiesToTick(List<EntityData> entities, List<PlayerData> players) {
        RustPerformance.ensureInitialized();
        try {
            return FACADE.getEntitiesToTick(entities, players).join();
        }
        catch (Exception e) {
            KneafCore.LOGGER.error("Error getting entities to tick", (Throwable)e);
            return entities.stream().map(entity -> entity.getId()).toList();
        }
    }

    public static CompletableFuture<ItemProcessResult> processItemEntitiesAsync(List<ItemEntityData> items) {
        RustPerformance.ensureInitialized();
        return FACADE.processItemEntities(items);
    }

    public static ItemProcessResult processItemEntities(List<ItemEntityData> items) {
        RustPerformance.ensureInitialized();
        try {
            return FACADE.processItemEntities(items).join();
        }
        catch (Exception e) {
            KneafCore.LOGGER.error("Error processing item entities", (Throwable)e);
            return new ItemProcessResult(new ArrayList<Long>(), 0L, 0L, new ArrayList<PerformanceProcessor.ItemUpdate>());
        }
    }

    public static CompletableFuture<MobProcessResult> processMobAIAsync(List<MobData> mobs) {
        RustPerformance.ensureInitialized();
        return FACADE.processMobAI(mobs);
    }

    public static MobProcessResult processMobAI(List<MobData> mobs) {
        RustPerformance.ensureInitialized();
        try {
            return FACADE.processMobAI(mobs).join();
        }
        catch (Exception e) {
            KneafCore.LOGGER.error("Error processing mob AI", (Throwable)e);
            return new MobProcessResult(new ArrayList<Long>(), new ArrayList<Long>());
        }
    }

    public static VillagerProcessResult processVillagerAI(Object villagersObj) {
        List<VillagerData> converted;
        RustPerformance.ensureInitialized();
        if (villagersObj instanceof List) {
            List list = (List)villagersObj;
            boolean allVillagers = true;
            for (Object o : list) {
                if (o == null || o instanceof VillagerData || o instanceof com.kneaf.core.data.VillagerData) continue;
                allVillagers = false;
                break;
            }
            if (allVillagers) {
                List castList = list;
                converted = castList;
            } else {
                converted = new ArrayList(list.size());
                for (Object o : list) {
                    if (o == null) continue;
                    if (o instanceof VillagerData) {
                        converted.add((VillagerData)o);
                        continue;
                    }
                    if (!(o instanceof com.kneaf.core.data.VillagerData)) continue;
                    converted.add((VillagerData)o);
                }
            }
        } else {
            converted = new ArrayList();
        }
        ArrayList<Long> simplifyList = new ArrayList<Long>(converted.size());
        for (VillagerData v : converted) {
            simplifyList.add(v.getId());
        }
        return new VillagerProcessResult(new ArrayList<Long>(), simplifyList, new ArrayList<Long>(), new ArrayList<VillagerGroup>());
    }

    public static CompletableFuture<List<Long>> getBlockEntitiesToTickAsync(List<BlockEntityData> blockEntities) {
        RustPerformance.ensureInitialized();
        return FACADE.getBlockEntitiesToTick(blockEntities);
    }

    public static List<Long> getBlockEntitiesToTick(List<BlockEntityData> blockEntities) {
        RustPerformance.ensureInitialized();
        try {
            return FACADE.getBlockEntitiesToTick(blockEntities).join();
        }
        catch (Exception e) {
            KneafCore.LOGGER.error("Error getting block entities to tick", (Throwable)e);
            return blockEntities.stream().map(block -> block.getId()).toList();
        }
    }

    public static List<Long> optimizeVillagers(List<VillagerData> villagers, int centerX, int centerZ, int radius) {
        RustPerformance.ensureInitialized();
        return FACADE.optimizeVillagers(villagers, centerX, centerZ, radius);
    }

    public static void optimizeMemory() {
        RustPerformance.ensureInitialized();
        FACADE.optimizeMemory();
    }

    public static PerformanceStatistics getPerformanceStatistics() {
        RustPerformance.ensureInitialized();
        RustPerformanceFacade.PerformanceStatistics FACADEStats = FACADE.getPerformanceStatistics();
        return new PerformanceStatistics(FACADEStats.getTotalEntitiesProcessed(), FACADEStats.getTotalItemsProcessed(), FACADEStats.getTotalMobsProcessed(), FACADEStats.getTotalBlocksProcessed(), FACADEStats.getAverageTickTime(), FACADEStats.isNativeAvailable());
    }

    public static String getMemoryStats() {
        RustPerformance.ensureInitialized();
        return FACADE.getMemoryStats();
    }

    public static String getCpuStats() {
        RustPerformance.ensureInitialized();
        return FACADE.getCpuStats();
    }

    public static CompletableFuture<Integer> preGenerateNearbyChunksAsync(int centerX, int centerZ, int radius) {
        RustPerformance.ensureInitialized();
        return FACADE.preGenerateNearbyChunksAsync(centerX, centerZ, radius);
    }

    public static boolean isChunkGenerated(int x, int z) {
        RustPerformance.ensureInitialized();
        return FACADE.isChunkGenerated(x, z);
    }

    public static long getGeneratedChunkCount() {
        RustPerformance.ensureInitialized();
        return FACADE.getGeneratedChunkCount();
    }

    public static double getCurrentTPS() {
        return FACADE.getCurrentTPS();
    }

    public static void setCurrentTPS(double tps) {
        FACADE.setCurrentTPS(tps);
    }

    public static int getNativeWorkerQueueDepth() {
        RustPerformance.ensureInitialized();
        return FACADE.getNativeWorkerQueueDepth();
    }

    public static double getNativeWorkerAvgProcessingMs() {
        RustPerformance.ensureInitialized();
        return FACADE.getNativeWorkerAvgProcessingMs();
    }

    public static int nativeGetWorkerQueueDepth() {
        try {
            return RustPerformance.getNativeWorkerQueueDepth();
        }
        catch (Throwable t) {
            return 0;
        }
    }

    public static double nativeGetWorkerAvgProcessingMs() {
        try {
            return RustPerformance.getNativeWorkerAvgProcessingMs();
        }
        catch (Throwable t) {
            return 0.0;
        }
    }

    public static String parallelSumNative(String arrJson) {
        if (arrJson == null || arrJson.isEmpty()) {
            return "{\"sum\":0}";
        }
        try {
            JsonElement e = JsonParser.parseString((String)arrJson);
            if (!e.isJsonArray()) {
                return "{\"sum\":0}";
            }
            long sum = 0L;
            for (JsonElement v : e.getAsJsonArray()) {
                try {
                    sum += v.getAsLong();
                }
                catch (Exception exception) {}
            }
            return new Gson().toJson(Map.of("sum", sum));
        }
        catch (Exception ex) {
            return "{\"error\":\"invalid_input\"}";
        }
    }

    public static String matrixMultiplyNative(String aJson, String bJson) {
        try {
            JsonArray a = JsonParser.parseString((String)aJson).getAsJsonArray();
            JsonArray b = JsonParser.parseString((String)bJson).getAsJsonArray();
            double[][] A = RustPerformance.jsonArrayToMatrix(a);
            double[][] B = RustPerformance.jsonArrayToMatrix(b);
            if (A[0].length != B.length) {
                return "{\"error\":\"incompatible\"}";
            }
            double[][] C = new double[A.length][B[0].length];
            for (int i = 0; i < A.length; ++i) {
                for (int j = 0; j < B[0].length; ++j) {
                    double s = 0.0;
                    for (int k = 0; k < A[0].length; ++k) {
                        s += A[i][k] * B[k][j];
                    }
                    C[i][j] = s;
                }
            }
            return new Gson().toJson((Object)C);
        }
        catch (Exception ex) {
            return "{\"error\":\"invalid_input\"}";
        }
    }

    private static double[][] jsonArrayToMatrix(JsonArray arr) {
        int rows = arr.size();
        double[][] out = new double[rows][];
        for (int i = 0; i < rows; ++i) {
            JsonArray row = arr.get(i).getAsJsonArray();
            out[i] = new double[row.size()];
            for (int j = 0; j < row.size(); ++j) {
                out[i][j] = row.get(j).getAsDouble();
            }
        }
        return out;
    }

    public static boolean isNativeAvailable() {
        return FACADE.isNativeAvailable();
    }

    public static void shutdown() {
        if (initialized) {
            FACADE.shutdown();
            initialized = false;
        }
    }

    private static void ensureInitialized() {
        if (!initialized) {
            try {
                FACADE.initialize();
            }
            catch (Throwable t) {
                try {
                    KneafCore.LOGGER.warn("RustPerformance initialize failed (falling back): { }", (Object)t.getMessage());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            finally {
                initialized = true;
            }
        }
    }

    public static long getTotalEntitiesProcessed() {
        RustPerformance.ensureInitialized();
        return FACADE.getPerformanceStatistics().getTotalEntitiesProcessed();
    }

    public static long getTotalMobsProcessed() {
        RustPerformance.ensureInitialized();
        return FACADE.getPerformanceStatistics().getTotalMobsProcessed();
    }

    public static long getTotalBlocksProcessed() {
        RustPerformance.ensureInitialized();
        return FACADE.getPerformanceStatistics().getTotalBlocksProcessed();
    }

    public static long getTotalMerged() {
        RustPerformance.ensureInitialized();
        return FACADE.getPerformanceStatistics().getTotalItemsProcessed();
    }

    public static long getTotalDespawned() {
        RustPerformance.ensureInitialized();
        return FACADE.getPerformanceStatistics().getTotalItemsProcessed();
    }

    public static int preGenerateNearbyChunks(int centerX, int centerZ, int radius) {
        RustPerformance.ensureInitialized();
        try {
            return RustPerformance.preGenerateNearbyChunksAsync(centerX, centerZ, radius).get();
        }
        catch (Exception e) {
            KneafCore.LOGGER.error("Error pre-generating chunks", (Throwable)e);
            return 0;
        }
    }

    public static ByteBuffer generateFloatBufferNative(int size, int flags) {
        RustPerformance.ensureInitialized();
        return NATIVE_MANAGER.generateFloatBuffer(size, flags);
    }

    public static NativeFloatBufferAllocation generateFloatBufferWithShapeNative(long rows, long cols) {
        RustPerformance.ensureInitialized();
        return NATIVE_MANAGER.generateFloatBufferWithShape(rows, cols);
    }

    public static void freeFloatBufferNative(ByteBuffer buffer) {
        RustPerformance.ensureInitialized();
        NATIVE_MANAGER.freeFloatBuffer(buffer);
    }

    public static native void recordJniCallNative(String var0, long var1);

    public static native void recordLockWaitNative(String var0, long var1);

    public static native void recordMemoryUsageNative(long var0, long var2, long var4);

    public static native void recordGcEventNative(long var0);

    public static class PerformanceStatistics {
        private final long totalEntitiesProcessed;
        private final long totalItemsProcessed;
        private final long totalMobsProcessed;
        private final long totalBlocksProcessed;
        private final double averageTickTime;
        private final boolean nativeAvailable;

        public PerformanceStatistics(long totalEntitiesProcessed, long totalItemsProcessed, long totalMobsProcessed, long totalBlocksProcessed, double averageTickTime, boolean nativeAvailable) {
            this.totalEntitiesProcessed = totalEntitiesProcessed;
            this.totalItemsProcessed = totalItemsProcessed;
            this.totalMobsProcessed = totalMobsProcessed;
            this.totalBlocksProcessed = totalBlocksProcessed;
            this.averageTickTime = averageTickTime;
            this.nativeAvailable = nativeAvailable;
        }

        public long getTotalEntitiesProcessed() {
            return this.totalEntitiesProcessed;
        }

        public long getTotalItemsProcessed() {
            return this.totalItemsProcessed;
        }

        public long getTotalMobsProcessed() {
            return this.totalMobsProcessed;
        }

        public long getTotalBlocksProcessed() {
            return this.totalBlocksProcessed;
        }

        public double getAverageTickTime() {
            return this.averageTickTime;
        }

        public boolean isNativeAvailable() {
            return this.nativeAvailable;
        }

        public String toString() {
            return String.format("PerformanceStatistics{entities=%d, items=%d, mobs=%d, blocks=%d, avgTickTime=%.2fms, native=%s}", this.totalEntitiesProcessed, this.totalItemsProcessed, this.totalMobsProcessed, this.totalBlocksProcessed, this.averageTickTime, this.nativeAvailable);
        }
    }
}

