/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.performance.core;

public final class PerformanceConstants {
    public static final String ENTITIES_KEY = "entities";
    public static final String ITEMS_KEY = "items";
    public static final String MOBS_KEY = "mobs";
    public static final String BLOCKS_KEY = "blocks";
    public static final String PLAYERS_KEY = "players";
    public static final String TICK_COUNT_KEY = "tickCount";
    public static final String BINARY_FALLBACK_MESSAGE = "Binary protocol failed, falling back to JSON: { }";
    public static final String NATIVE_NOT_AVAILABLE_ERROR = "Rust native library is not available";
    @Deprecated
    public static final int DEFAULT_BATCH_SIZE = 100;
    @Deprecated
    public static final long DEFAULT_BATCH_TIMEOUT_MS = 50L;
    @Deprecated
    public static final int BATCH_PROCESSOR_SLEEP_MS = 5;
    @Deprecated
    public static final int MAX_CONNECTIONS = 10;
    @Deprecated
    public static final int INITIAL_CONNECTIONS = 5;
    public static final String NATIVE_LIBRARY_NAME = "rustperf";
    @Deprecated
    public static final double DEFAULT_TPS_THRESHOLD = 19.0;
    @Deprecated
    public static final double MIN_TPS_THRESHOLD = 10.0;
    @Deprecated
    public static final double MAX_TPS_THRESHOLD = 20.0;
    @Deprecated
    public static final double DEFAULT_DISTANCE_CUTOFF = 256.0;
    @Deprecated
    public static final int DISTANCE_CALCULATION_INTERVAL = 10;
    @Deprecated
    public static final double DEFAULT_CELL_SIZE = 32.0;
    @Deprecated
    public static final double SPATIAL_GRID_UPDATE_THRESHOLD = 1.0;
    @Deprecated
    public static final int BUFFER_POOL_SIZE = 50;
    @Deprecated
    public static final int MAX_BUFFER_SIZE = 0x100000;
    @Deprecated
    public static final int BUFFER_USE_THRESHOLD = 8192;
    @Deprecated
    public static final int CORE_THREADS = Math.max(4, Runtime.getRuntime().availableProcessors());
    @Deprecated
    public static final int MAX_THREADS = Math.max(8, CORE_THREADS * 2);
    @Deprecated
    public static final long THREAD_KEEP_ALIVE_TIME = 60L;
    @Deprecated
    public static final int QUEUE_CAPACITY = 1000;
    @Deprecated
    public static final int DEFAULT_LOG_INTERVAL_TICKS = 100;
    @Deprecated
    public static final long DEFAULT_MAX_LOG_BYTES = 0xA00000L;
    @Deprecated
    public static final long DEFAULT_SLOW_TICK_THRESHOLD_MS = 50L;
    @Deprecated
    public static final int DEFAULT_PROFILING_SAMPLE_RATE = 100;
    @Deprecated
    public static final int CHUNK_GENERATION_TIMEOUT_MS = 30000;

    private PerformanceConstants() {
    }

    public static int getAdaptiveDistanceCalculationInterval(double tps) {
        if (tps < 15.0) {
            return 20;
        }
        if (tps < 18.0) {
            return 12;
        }
        return 10;
    }

    public static int getAdaptiveBufferUseThreshold(double tps) {
        if (tps < 15.0) {
            return 16384;
        }
        if (tps < 18.0) {
            return 12288;
        }
        return 8192;
    }

    public static int getAdaptiveChunkGenerationTimeoutMs(double tps) {
        if (tps < 15.0) {
            return 15000;
        }
        if (tps < 18.0) {
            return 25000;
        }
        return 30000;
    }

    public static int getAdaptiveMaxConnections(double tps) {
        if (tps < 15.0) {
            return Math.max(2, 5);
        }
        if (tps < 18.0) {
            return Math.max(4, 7);
        }
        return 10;
    }

    public static int getAdaptiveInitialConnections(double tps) {
        if (tps < 15.0) {
            return Math.max(1, 2);
        }
        if (tps < 18.0) {
            return Math.max(2, 3);
        }
        return 5;
    }

    public static int getAdaptiveCoreThreads(double tps) {
        int base = Math.max(4, Runtime.getRuntime().availableProcessors());
        if (tps < 15.0) {
            return Math.max(2, base / 2);
        }
        if (tps < 18.0) {
            return Math.max(3, (int)((double)base * 0.75));
        }
        return base;
    }

    public static long getAdaptiveThreadKeepAliveSeconds(double tps) {
        if (tps < 15.0) {
            return Math.max(10L, 30L);
        }
        if (tps < 18.0) {
            return Math.max(30L, 45L);
        }
        return 60L;
    }

    public static int getAdaptiveBatchSize(double tps, double tickDelayMs) {
        double tpsFactor = Math.max(0.25, tps / 20.0);
        double delayFactor = tickDelayMs > 50.0 ? Math.max(0.5, 50.0 / tickDelayMs) : 1.0;
        return Math.max(10, (int)(100.0 * tpsFactor * delayFactor));
    }

    public static long getAdaptiveBatchTimeoutMs(double tps, double tickDelayMs) {
        if (tps < 15.0) {
            return Math.max(20L, 100L);
        }
        if (tps < 18.0) {
            return Math.max(10L, 50L);
        }
        return 50L;
    }

    public static int getAdaptiveBatchProcessorSleepMs(double tps) {
        if (tps < 15.0) {
            return Math.max(1, 2);
        }
        if (tps < 18.0) {
            return 5;
        }
        return Math.max(1, 10);
    }

    public static double getAdaptiveCellSize(double tps) {
        if (tps < 15.0) {
            return 64.0;
        }
        if (tps < 18.0) {
            return 48.0;
        }
        return 32.0;
    }

    public static int getAdaptiveQueueCapacity(double tps) {
        if (tps < 15.0) {
            return Math.max(100, 500);
        }
        if (tps < 18.0) {
            return Math.max(200, 750);
        }
        return 1000;
    }

    public static int getAdaptivePredictiveRadius(double tps) {
        if (tps < 15.0) {
            return 2;
        }
        if (tps < 18.0) {
            return 3;
        }
        return 4;
    }

    public static int getAdaptiveMaxPredictiveChunksPerTick(double tps) {
        if (tps < 15.0) {
            return 2;
        }
        if (tps < 18.0) {
            return 4;
        }
        return 8;
    }

    public static int getAdaptiveLogIntervalTicks(double tps) {
        if (tps < 15.0) {
            return Math.max(20, 200);
        }
        if (tps < 18.0) {
            return Math.max(50, 100);
        }
        return 100;
    }

    public static long getAdaptiveMaxLogBytes(double tps) {
        if (tps < 15.0) {
            return Math.max(0x200000L, 0x500000L);
        }
        if (tps < 18.0) {
            return Math.max(0x500000L, 0x780000L);
        }
        return 0xA00000L;
    }

    public static int getAdaptiveProfilingSampleRate(double tps) {
        if (tps < 15.0) {
            return Math.max(10, 50);
        }
        if (tps < 18.0) {
            return 100;
        }
        return 100;
    }

    public static int getAdaptiveBufferPoolSize(double tps) {
        if (tps < 15.0) {
            return Math.max(8, 25);
        }
        if (tps < 18.0) {
            return Math.max(16, 37);
        }
        return 50;
    }

    public static int getAdaptiveMaxPoolPerBucket(double tps) {
        if (tps < 15.0) {
            return Math.max(8, 10);
        }
        if (tps < 18.0) {
            return Math.max(16, 20);
        }
        return 20;
    }

    public static int getAdaptiveMaxBucketSize(double tps) {
        if (tps < 15.0) {
            return 20;
        }
        return 24;
    }

    public static int getAdaptivePrefetchCount(double tps) {
        if (tps < 15.0) {
            return 2;
        }
        if (tps < 18.0) {
            return 3;
        }
        return 5;
    }

    public static int getAdaptiveMaxBufferSize(double tps) {
        if (tps < 15.0) {
            return 524288;
        }
        if (tps < 18.0) {
            return 786432;
        }
        return 0x100000;
    }

    public static int getAdaptiveMaxThreads(double tps) {
        if (tps < 15.0) {
            return Math.max(4, MAX_THREADS / 2);
        }
        if (tps < 18.0) {
            return Math.max(6, (int)((double)MAX_THREADS * 0.75));
        }
        return MAX_THREADS;
    }

    public static int getAdaptiveMaxEntities(double tps, double tickDelayMs) {
        double tpsFactor = Math.max(0.5, Math.min(1.5, tps / 20.0));
        double delayFactor = 1.0;
        if (tickDelayMs > 50.0) {
            delayFactor = Math.max(0.5, 50.0 / tickDelayMs);
        }
        return Math.max(10, (int)(200.0 * tpsFactor * delayFactor));
    }

    public static int getAdaptiveMaxItems(double tps) {
        double tpsFactor = Math.max(0.5, Math.min(1.5, tps / 20.0));
        return Math.max(10, (int)(300.0 * tpsFactor));
    }

    public static int getAdaptiveMaxMobs(double tps) {
        double tpsFactor = Math.max(0.4, Math.min(1.2, tps / 20.0));
        return Math.max(5, (int)(150.0 * tpsFactor));
    }

    public static int getAdaptiveMaxBlocks(double tps) {
        double tpsFactor = Math.max(0.6, Math.min(1.3, tps / 20.0));
        return Math.max(10, (int)(500.0 * tpsFactor));
    }

    public static double getAdaptiveTargetTickTimeMs(double tps) {
        return 50.0 * (20.0 / Math.max(0.1, tps));
    }

    public static int getAdaptiveOptimizationThreshold(double tps) {
        double factor = tps >= 20.0 ? 1.0 : Math.max(0.4, tps / 20.0);
        int base = 25;
        return (int)Math.max(1.0, (double)base * factor);
    }

    public static double getAdaptiveMemoryUsageThreshold(double tps) {
        if (tps < 15.0) {
            return 75.0;
        }
        if (tps < 18.0) {
            return 80.0;
        }
        return 85.0;
    }

    public static int getAdaptivePlayerMovementHistorySize(double tps) {
        if (tps < 15.0) {
            return 5;
        }
        if (tps < 18.0) {
            return 8;
        }
        return 10;
    }

    public static double getAdaptiveMinVelocityThreshold(double tps) {
        if (tps < 15.0) {
            return 0.2;
        }
        return 0.1;
    }

    public static long getAdaptivePredictionValidityMs(double tps) {
        if (tps < 15.0) {
            return 3000L;
        }
        if (tps < 18.0) {
            return 5000L;
        }
        return 7000L;
    }

    public static long getAdaptiveBufferCleanupIntervalMs(double tps) {
        if (tps < 15.0) {
            return 30000L;
        }
        if (tps < 18.0) {
            return 45000L;
        }
        return 60000L;
    }

    public static long getAdaptiveEnhancedCheckIntervalMs(double tps) {
        if (tps < 15.0) {
            return 2000L;
        }
        if (tps < 18.0) {
            return 3500L;
        }
        return 5000L;
    }

    public static long getAdaptiveExecutorCheckIntervalMs(double tps) {
        if (tps < 15.0) {
            return 2000L;
        }
        if (tps < 18.0) {
            return 4000L;
        }
        return 5000L;
    }

    public static int getAdaptiveNetworkBatchScheduleMs(double tps) {
        if (tps < 15.0) {
            return 25;
        }
        if (tps < 18.0) {
            return 15;
        }
        return 10;
    }

    public static double getAdaptiveBatchFlushFraction(double tps) {
        if (tps < 15.0) {
            return 0.25;
        }
        if (tps < 18.0) {
            return 0.4;
        }
        return 0.5;
    }

    public static int getAdaptivePacketCompressionThreshold(double tps) {
        if (tps < 15.0) {
            return 1500;
        }
        if (tps < 18.0) {
            return 1200;
        }
        return 1000;
    }

    public static int getAdaptiveRateLimitBaseDelayMs(double tps) {
        if (tps < 15.0) {
            return 5;
        }
        if (tps < 18.0) {
            return 3;
        }
        return 2;
    }

    public static int getAdaptiveRateLimitExtraForSize(int size, double tps) {
        double factor = Math.max(0.5, Math.min(2.0, 20.0 / Math.max(0.1, tps)));
        if (size > 5000) {
            return (int)Math.round(10.0 * factor);
        }
        if (size > 1000) {
            return (int)Math.round(5.0 * factor);
        }
        return 0;
    }
}

