/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.performance.core;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;

public final class PerformanceUtils {
    private static final Gson GSON = new Gson();

    private PerformanceUtils() {
    }

    public static String bytesToHex(byte[] data, int maxBytes) {
        if (data == null) {
            return "";
        }
        int len = Math.min(data.length, Math.max(0, maxBytes));
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            sb.append(String.format("%02x", data[i] & 0xFF));
            if (i >= len - 1) continue;
            sb.append(',');
        }
        if (data.length > len) {
            sb.append("...");
        }
        return sb.toString();
    }

    public static List<Long> parseEntityResultFromJson(String jsonResult) {
        try {
            JsonObject result = (JsonObject)GSON.fromJson(jsonResult, JsonObject.class);
            if (result == null) {
                return new ArrayList<Long>();
            }
            if (result.has("error")) {
                return new ArrayList<Long>();
            }
            if (!result.has("entitiesToTick")) {
                return new ArrayList<Long>();
            }
            JsonElement entitiesElement = result.get("entitiesToTick");
            if (entitiesElement == null || !entitiesElement.isJsonArray()) {
                return new ArrayList<Long>();
            }
            JsonArray entitiesToTick = entitiesElement.getAsJsonArray();
            ArrayList<Long> resultList = new ArrayList<Long>();
            for (JsonElement e : entitiesToTick) {
                if (e == null || !e.isJsonPrimitive()) continue;
                try {
                    resultList.add(e.getAsLong());
                }
                catch (NumberFormatException numberFormatException) {}
            }
            return resultList;
        }
        catch (Exception e) {
            return new ArrayList<Long>();
        }
    }

    public static ItemParseResult parseItemResultFromJson(String jsonResult) {
        try {
            JsonObject result = (JsonObject)GSON.fromJson(jsonResult, JsonObject.class);
            JsonArray itemsToRemove = result.getAsJsonArray("items_to_remove");
            ArrayList<Long> removeList = new ArrayList<Long>();
            for (JsonElement e : itemsToRemove) {
                removeList.add(e.getAsLong());
            }
            long merged = result.get("merged_count").getAsLong();
            long despawned = result.get("despawned_count").getAsLong();
            JsonArray itemUpdatesArray = result.getAsJsonArray("item_updates");
            ArrayList<ItemUpdateParseResult> updates = new ArrayList<ItemUpdateParseResult>();
            for (JsonElement e : itemUpdatesArray) {
                JsonObject obj = e.getAsJsonObject();
                long id = obj.get("id").getAsLong();
                int newCount = obj.get("new_count").getAsInt();
                updates.add(new ItemUpdateParseResult(id, newCount));
            }
            return new ItemParseResult(removeList, merged, despawned, updates);
        }
        catch (Exception e) {
            return new ItemParseResult(new ArrayList<Long>(), 0L, 0L, new ArrayList<ItemUpdateParseResult>());
        }
    }

    public static MobParseResult parseMobResultFromJson(String jsonResult) {
        try {
            JsonObject result = (JsonObject)GSON.fromJson(jsonResult, JsonObject.class);
            JsonArray disableAi = result.getAsJsonArray("mobs_to_disable_ai");
            JsonArray simplifyAi = result.getAsJsonArray("mobs_to_simplify_ai");
            ArrayList<Long> disableList = new ArrayList<Long>();
            ArrayList<Long> simplifyList = new ArrayList<Long>();
            for (JsonElement e : disableAi) {
                disableList.add(e.getAsLong());
            }
            for (JsonElement e : simplifyAi) {
                simplifyList.add(e.getAsLong());
            }
            return new MobParseResult(disableList, simplifyList);
        }
        catch (Exception e) {
            return new MobParseResult(new ArrayList<Long>(), new ArrayList<Long>());
        }
    }

    public static List<Long> parseBlockResultFromJson(String jsonResult) {
        try {
            JsonObject result = (JsonObject)GSON.fromJson(jsonResult, JsonObject.class);
            JsonArray entitiesToTick = result.getAsJsonArray("block_entities_to_tick");
            ArrayList<Long> resultList = new ArrayList<Long>();
            for (JsonElement e : entitiesToTick) {
                resultList.add(e.getAsLong());
            }
            return resultList;
        }
        catch (Exception e) {
            return new ArrayList<Long>();
        }
    }

    public static List<Long> parseEntityResultWithFallback(byte[] resultBytes) {
        if (resultBytes == null) {
            return new ArrayList<Long>();
        }
        try {
            int numItems;
            ByteBuffer resultBuffer = ByteBuffer.wrap(resultBytes).order(ByteOrder.LITTLE_ENDIAN);
            if (resultBuffer.remaining() >= 4 && (numItems = resultBuffer.getInt()) >= 0 && numItems <= 1000000 && resultBuffer.remaining() >= numItems * 8) {
                ArrayList<Long> resultList = new ArrayList<Long>(numItems);
                for (int i = 0; i < numItems; ++i) {
                    resultList.add(resultBuffer.getLong());
                }
                return resultList;
            }
        }
        catch (Exception primaryEx) {
            try {
                ByteBuffer altBuf = ByteBuffer.wrap(resultBytes).order(ByteOrder.LITTLE_ENDIAN);
                int len = resultBytes.length;
                if (len >= 12) {
                    altBuf.getLong(0);
                    int numItems = altBuf.getInt(8);
                    if (numItems >= 0 && numItems <= 1000000 && 12 + numItems * 8 <= len) {
                        ArrayList<Long> altList = new ArrayList<Long>(numItems);
                        for (int i = 0; i < numItems; ++i) {
                            long id = altBuf.getLong(12 + i * 8);
                            altList.add(id);
                        }
                        return altList;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new ArrayList<Long>();
    }

    public static class ItemUpdateParseResult {
        private final long id;
        private final int newCount;

        public ItemUpdateParseResult(long id, int newCount) {
            this.id = id;
            this.newCount = newCount;
        }

        public long getId() {
            return this.id;
        }

        public int getNewCount() {
            return this.newCount;
        }
    }

    public static class ItemParseResult {
        private final List<Long> itemsToRemove;
        private final long mergedCount;
        private final long despawnedCount;
        private final List<ItemUpdateParseResult> itemUpdates;

        public ItemParseResult(List<Long> itemsToRemove, long mergedCount, long despawnedCount, List<ItemUpdateParseResult> itemUpdates) {
            this.itemsToRemove = itemsToRemove;
            this.mergedCount = mergedCount;
            this.despawnedCount = despawnedCount;
            this.itemUpdates = itemUpdates;
        }

        public List<Long> getItemsToRemove() {
            return this.itemsToRemove;
        }

        public long getMergedCount() {
            return this.mergedCount;
        }

        public long getDespawnedCount() {
            return this.despawnedCount;
        }

        public List<ItemUpdateParseResult> getItemUpdates() {
            return this.itemUpdates;
        }
    }

    public static class MobParseResult {
        private final List<Long> disableList;
        private final List<Long> simplifyList;

        public MobParseResult(List<Long> disableList, List<Long> simplifyList) {
            this.disableList = disableList;
            this.simplifyList = simplifyList;
        }

        public List<Long> getDisableList() {
            return this.disableList;
        }

        public List<Long> getSimplifyList() {
            return this.simplifyList;
        }
    }
}

