/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.performance.debug;

import com.kneaf.core.performance.core.PerformanceConstants;
import com.kneaf.core.performance.monitoring.PerformanceManager;

public class AdaptiveProbe {
    public static void main(String[] args) {
        double tps = PerformanceManager.getAverageTPS();
        long tickDelay = PerformanceManager.getLastTickDurationMs();
        System.out.println("Current avgTps=" + String.format("%.2f", tps) + " tickDelayMs=" + tickDelay);
        int BASE_MAX_ENTITIES = 200;
        int BASE_MAX_ITEMS = 300;
        int BASE_MAX_MOBS = 150;
        int BASE_MAX_BLOCKS = 500;
        double BASE_TARGET_TICK_TIME_MS = 50.0;
        double tpsFactor = Math.max(0.5, Math.min(1.5, tps / 20.0));
        double delayFactor = 1.0;
        if ((double)tickDelay > 50.0) {
            delayFactor = Math.max(0.5, 50.0 / (double)tickDelay);
        }
        int maxEntities = (int)Math.max(10.0, 200.0 * tpsFactor * delayFactor);
        int maxItems = (int)Math.max(10.0, 300.0 * tpsFactor);
        int maxMobs = (int)Math.max(5.0, 150.0 * Math.max(0.4, Math.min(1.2, tps / 20.0)));
        int maxBlocks = (int)Math.max(10.0, 500.0 * Math.max(0.6, Math.min(1.3, tps / 20.0)));
        System.out.println("Adaptive PerformanceOptimizer values:");
        System.out.println("  maxEntitiesPerTick=" + maxEntities);
        System.out.println("  maxItemsPerTick=" + maxItems);
        System.out.println("  maxMobsPerTick=" + maxMobs);
        System.out.println("  maxBlocksPerTick=" + maxBlocks);
        System.out.println("  targetTickTimeMs=" + 50.0 * (20.0 / Math.max(0.1, tps)));
        System.out.println("  optimizationThreshold=" + (int)Math.max(1.0, 25.0 * (tps >= 20.0 ? 1.0 : Math.max(0.4, tps / 20.0))));
        int batchSize = PerformanceConstants.getAdaptiveBatchSize(tps, tickDelay);
        long batchTimeout = PerformanceConstants.getAdaptiveBatchTimeoutMs(tps, tickDelay);
        int batchSleep = PerformanceConstants.getAdaptiveBatchProcessorSleepMs(tps);
        System.out.println("Adaptive BatchProcessor values:");
        System.out.println("  batchSize=" + batchSize);
        System.out.println("  batchTimeoutMs=" + batchTimeout);
        System.out.println("  batchProcessorSleepMs=" + batchSleep);
        double closeRadius = Math.max(8.0, 16.0 * (tps / 20.0));
        double mediumRadius = Math.max(16.0, 32.0 * (tps / 20.0));
        double closeRate = Math.max(0.2, Math.min(1.0, tps / 20.0));
        double mediumRate = Math.max(0.1, Math.min(0.8, tps / 20.0 * 0.5));
        double farRate = Math.max(0.05, Math.min(0.5, (20.0 - tps) / 20.0 * 0.2 + 0.1));
        boolean spatial = tps >= 12.0;
        int quadtreeEntities = Math.max(100, (int)(1000.0 * Math.max(0.5, Math.min(1.5, tps / 20.0))));
        int quadtreeDepth = tps > 18.0 ? 10 : (tps > 14.0 ? 8 : 6);
        System.out.println("Adaptive EntityProcessor values:");
        System.out.println("  closeRadius=" + closeRadius);
        System.out.println("  mediumRadius=" + mediumRadius);
        System.out.println("  closeRate=" + closeRate);
        System.out.println("  mediumRate=" + mediumRate);
        System.out.println("  farRate=" + farRate);
        System.out.println("  spatialPartitioning=" + spatial);
        System.out.println("  quadtreeMaxEntities=" + quadtreeEntities);
        System.out.println("  quadtreeMaxDepth=" + quadtreeDepth);
    }
}

