/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.performance.monitoring;

import com.kneaf.core.data.item.ItemEntityData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ItemConsolidator {
    public List<ItemEntityData> consolidateItemEntities(List<ItemEntityData> items) {
        if (items == null || items.isEmpty()) {
            return items;
        }
        int estimatedSize = Math.min(items.size(), items.size() / 2 + 1);
        HashMap<Long, ItemEntityData> agg = new HashMap<Long, ItemEntityData>(estimatedSize);
        for (ItemEntityData it : items) {
            long key = this.packItemKey(it.getChunkX(), it.getChunkZ(), it.getItemType());
            ItemEntityData cur = (ItemEntityData)agg.get(key);
            if (cur == null) {
                agg.put(key, it);
                continue;
            }
            int newCount = cur.getCount() + it.getCount();
            int newAge = Math.min(cur.getAgeSeconds(), it.getAgeSeconds());
            long preservedId = cur.getId();
            agg.put(key, new ItemEntityData(preservedId, it.getChunkX(), it.getChunkZ(), it.getItemType(), newCount, newAge));
        }
        return new ArrayList<ItemEntityData>(agg.values());
    }

    private long packItemKey(int chunkX, int chunkZ, String itemType) {
        long packedChunkX = (long)chunkX & 0x1FFFFFL;
        long packedChunkZ = (long)chunkZ & 0x1FFFFFL;
        long itemHash = itemType == null ? 0L : (long)itemType.hashCode() & 0x3FFFFFL;
        return packedChunkX << 43 | packedChunkZ << 22 | itemHash;
    }
}

