/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.protocol.commands;

import com.kneaf.core.network.NetworkHandler;
import com.kneaf.core.performance.RustPerformance;
import com.kneaf.core.performance.monitoring.PerformanceManager;
import com.kneaf.core.performance.monitoring.PerformanceMetricsLogger;
import com.kneaf.core.protocol.commands.BaseCommand;
import com.kneaf.core.protocol.commands.ChunkCacheCommand;
import com.kneaf.core.protocol.core.ProtocolUtils;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Map;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.server.MinecraftServer;

public class PerformanceCommand
extends BaseCommand {
    private static final String COMMAND_NAME = "perf";
    private static final String DESCRIPTION = "Kneaf performance management commands";
    private static final String USAGE = "/kneaf perf <subcommand>";
    private static final int PERMISSION_LEVEL = 2;

    public PerformanceCommand() {
        super(COMMAND_NAME, DESCRIPTION, 2, USAGE);
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        PerformanceCommand mainCommand = new PerformanceCommand();
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.literal((String)"kneaf").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)COMMAND_NAME).requires(source -> source.hasPermission(2))).then(Commands.literal((String)"toggle").executes(context -> mainCommand.executeToggle((CommandContext<CommandSourceStack>)context)))).then(Commands.literal((String)"status").executes(context -> mainCommand.executeStatus((CommandContext<CommandSourceStack>)context)))).then(Commands.literal((String)"metrics").executes(context -> mainCommand.executeMetrics((CommandContext<CommandSourceStack>)context)))).then(Commands.literal((String)"broadcast").then(Commands.argument((String)"message", (ArgumentType)StringArgumentType.greedyString()).executes(context -> mainCommand.executeBroadcast((CommandContext<CommandSourceStack>)context))))).then(Commands.literal((String)"rotatelog").executes(context -> mainCommand.executeRotateLog((CommandContext<CommandSourceStack>)context)))).then(Commands.literal((String)"help").executes(context -> mainCommand.executeHelp((CommandContext<CommandSourceStack>)context))));
        dispatcher.register(builder);
        ChunkCacheCommand.register(dispatcher);
    }

    @Override
    protected int executeCommand(CommandContext<CommandSourceStack> context) throws Exception {
        throw new UnsupportedOperationException("Use specific execute methods for subcommands");
    }

    private int executeToggle(CommandContext<CommandSourceStack> context) {
        try {
            boolean newVal = !PerformanceManager.isEnabled();
            PerformanceManager.setEnabled(newVal);
            this.sendSuccessFormatted(context, "Kneaf performance manager enabled=%s", newVal);
            this.getLogger().logMetrics("toggle_performance", Map.of("enabled", newVal ? 1 : 0), ProtocolUtils.generateTraceId());
            return 1;
        }
        catch (Exception e) {
            this.sendFailureFormatted(context, "Failed to toggle performance manager: %s", e.getMessage());
            return 0;
        }
    }

    private int executeStatus(CommandContext<CommandSourceStack> context) {
        try {
            double tps = RustPerformance.getCurrentTPS();
            String cpu = RustPerformance.getCpuStats();
            String mem = RustPerformance.getMemoryStats();
            String message = String.format("Kneaf Performance - enabled=%s TPS=%.2f CPU=%s MEM=%s log=run/logs/kneaf-performance.log", PerformanceManager.isEnabled(), tps, cpu, mem);
            this.sendSuccess(context, message);
            this.getLogger().logMetrics("performance_status", Map.of("tps", tps, "enabled", PerformanceManager.isEnabled() ? 1 : 0), ProtocolUtils.generateTraceId());
            return 1;
        }
        catch (Exception e) {
            this.sendFailureFormatted(context, "Failed to get performance status: %s", e.getMessage());
            return 0;
        }
    }

    private int executeMetrics(CommandContext<CommandSourceStack> context) {
        try {
            long entitiesProcessed = RustPerformance.getTotalEntitiesProcessed();
            long mobsProcessed = RustPerformance.getTotalMobsProcessed();
            long blocksProcessed = RustPerformance.getTotalBlocksProcessed();
            long itemsMerged = RustPerformance.getTotalMerged();
            long itemsDespawned = RustPerformance.getTotalDespawned();
            String message = String.format("EntitiesProcessed=%d MobsProcessed=%d BlocksProcessed=%d ItemsMerged=%d ItemsDespawned=%d", entitiesProcessed, mobsProcessed, blocksProcessed, itemsMerged, itemsDespawned);
            this.sendSuccess(context, message);
            this.getLogger().logMetrics("performance_metrics", Map.of("entities_processed", entitiesProcessed, "mobs_processed", mobsProcessed, "blocks_processed", blocksProcessed, "items_merged", itemsMerged, "items_despawned", itemsDespawned), ProtocolUtils.generateTraceId());
            return 1;
        }
        catch (Exception e) {
            this.sendFailureFormatted(context, "Failed to get performance metrics: %s", e.getMessage());
            return 0;
        }
    }

    private int executeRotateLog(CommandContext<CommandSourceStack> context) {
        try {
            PerformanceMetricsLogger.rotateNow();
            this.sendSuccess(context, "Kneaf performance log rotated.");
            this.getLogger().logMetrics("rotate_log", Map.of("rotation_count", 1), ProtocolUtils.generateTraceId());
            return 1;
        }
        catch (Exception e) {
            this.sendFailureFormatted(context, "Failed to rotate performance log: %s", e.getMessage());
            return 0;
        }
    }

    private int executeBroadcast(CommandContext<CommandSourceStack> context) {
        try {
            String message = StringArgumentType.getString(context, (String)"message");
            CommandSourceStack src = (CommandSourceStack)context.getSource();
            MinecraftServer server = src.getServer();
            if (server == null) {
                this.sendFailureFormatted(context, "Server instance not available", new Object[0]);
                return 0;
            }
            NetworkHandler.broadcastPerformanceLine(server, message);
            this.sendSuccess(context, "Broadcasted performance line: " + message);
            return 1;
        }
        catch (Exception e) {
            this.sendFailureFormatted(context, "Failed to broadcast message: %s", e.getMessage());
            return 0;
        }
    }

    private int executeHelp(CommandContext<CommandSourceStack> context) {
        String helpMessage = this.createHelpMessage() + "\n\u00a7bSubcommands:\n\u00a7b  toggle \u00a77- Toggle performance monitoring on/off\n\u00a7b  status \u00a77- Show current performance status\n\u00a7b  metrics \u00a77- Show detailed performance metrics\n\u00a7b  rotatelog \u00a77- Rotate the performance log file\n\u00a7b  help \u00a77- Show this help message";
        this.sendSuccess(context, helpMessage);
        return 1;
    }

    @Override
    public boolean validateArguments(CommandContext<CommandSourceStack> context) {
        return true;
    }
}

