/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.protocol.commands;

import com.kneaf.core.performance.RustPerformance;
import com.kneaf.core.protocol.commands.BaseCommand;
import com.kneaf.core.protocol.core.ProtocolUtils;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Map;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;

public class RustPerfStatusCommand
extends BaseCommand {
    private static final String COMMAND_NAME = "rustperf";
    private static final String DESCRIPTION = "Show Rust performance status information";
    private static final String USAGE = "/rustperf status";
    private static final int PERMISSION_LEVEL = 0;

    public RustPerfStatusCommand() {
        super(COMMAND_NAME, DESCRIPTION, 0, USAGE);
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        RustPerfStatusCommand command = new RustPerfStatusCommand();
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.literal((String)COMMAND_NAME).then(((LiteralArgumentBuilder)Commands.literal((String)"status").requires(source -> source.hasPermission(0))).executes(context -> command.executeStatus((CommandContext<CommandSourceStack>)context)));
        dispatcher.register(builder);
    }

    @Override
    protected int executeCommand(CommandContext<CommandSourceStack> context) throws Exception {
        return this.executeStatus(context);
    }

    private int executeStatus(CommandContext<CommandSourceStack> context) {
        try {
            double tps = RustPerformance.getCurrentTPS();
            String memoryStats = RustPerformance.getMemoryStats();
            String cpuStats = RustPerformance.getCpuStats();
            String message = String.format("RustPerf Status: TPS: %.2f, CPU: %s, Memory: %s", tps, cpuStats, memoryStats);
            this.sendSuccess(context, message);
            this.getLogger().logMetrics("rustperf_status", Map.of("tps", tps, "cpu_Stats_available", cpuStats != null && !cpuStats.isEmpty() ? 1 : 0, "memory_Stats_available", memoryStats != null && !memoryStats.isEmpty() ? 1 : 0), ProtocolUtils.generateTraceId());
            return 1;
        }
        catch (Exception e) {
            this.sendFailureFormatted(context, "Failed to get Rust performance status: %s", e.getMessage());
            return 0;
        }
    }

    @Override
    public boolean validateArguments(CommandContext<CommandSourceStack> context) {
        return true;
    }
}

