/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.protocol.core;

import java.util.List;

public interface ProtocolValidator<T> {
    public ValidationResult validate(T var1);

    public boolean validateFormat(T var1, String var2);

    public boolean validateVersion(T var1, String var2);

    public boolean validateSize(T var1);

    public boolean validateIntegrity(T var1);

    public List<String> getSupportedRules();

    public static class ValidationResult {
        private final boolean valid;
        private final List<String> errors;
        private final List<String> warnings;

        public ValidationResult(boolean valid, List<String> errors, List<String> warnings) {
            this.valid = valid;
            this.errors = errors;
            this.warnings = warnings;
        }

        public boolean isValid() {
            return this.valid;
        }

        public List<String> getErrors() {
            return this.errors;
        }

        public List<String> getWarnings() {
            return this.warnings;
        }

        public boolean hasErrors() {
            return !this.errors.isEmpty();
        }

        public boolean hasWarnings() {
            return !this.warnings.isEmpty();
        }

        public static ValidationResult valid() {
            return new ValidationResult(true, List.of(), List.of());
        }

        public static ValidationResult invalid(List<String> errors) {
            return new ValidationResult(false, errors, List.of());
        }

        public static ValidationResult invalid(List<String> errors, List<String> warnings) {
            return new ValidationResult(false, errors, warnings);
        }
    }
}

