/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.protocol.utils;

import com.kneaf.core.protocol.core.ProtocolUtils;
import com.kneaf.core.protocol.core.ProtocolValidator;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class ProtocolValidatorImpl<T>
implements ProtocolValidator<T> {
    private final Class<T> dataType;
    private final int maxSize;
    private final String supportedVersion;

    public ProtocolValidatorImpl(Class<T> dataType, int maxSize, String supportedVersion) {
        this.dataType = dataType;
        this.maxSize = maxSize;
        this.supportedVersion = supportedVersion;
    }

    @Override
    public ProtocolValidator.ValidationResult validate(T data) {
        ArrayList<String> errors = new ArrayList<String>();
        ArrayList<String> warnings = new ArrayList<String>();
        if (data == null) {
            errors.add("Data cannot be null");
            return ProtocolValidator.ValidationResult.invalid(errors);
        }
        if (!this.dataType.isInstance(data)) {
            errors.add("Invalid data type. Expected: " + this.dataType.getSimpleName() + ", Actual: " + data.getClass().getSimpleName());
        }
        if (ProtocolUtils.exceedsSizeLimit(data, this.maxSize)) {
            errors.add("Data size exceeds maximum allowed size of " + this.maxSize + " bytes");
        }
        int dataSize = ProtocolUtils.getSizeInBytes(data);
        if (data instanceof String) {
            String str = (String)data;
            if (ProtocolUtils.isValidJson(str) && dataSize > 0xA00000) {
                errors.add("JSON data size exceeds limit of 10485760 bytes");
            } else if (dataSize > 0x3200000) {
                errors.add("Binary data size exceeds limit of 52428800 bytes");
            }
        } else if ((data instanceof byte[] || data instanceof ByteBuffer) && dataSize > 0x3200000) {
            errors.add("Binary data size exceeds limit of 52428800 bytes");
        }
        if ((double)dataSize > (double)this.maxSize * 0.8) {
            warnings.add("Data size is approaching maximum limit (" + String.format("%.1f%%", (double)dataSize * 100.0 / (double)this.maxSize) + ")");
        }
        return errors.isEmpty() ? ProtocolValidator.ValidationResult.valid() : ProtocolValidator.ValidationResult.invalid(errors, warnings);
    }

    @Override
    public boolean validateFormat(T data, String format) {
        if (data == null || format == null) {
            return false;
        }
        switch (format.toLowerCase()) {
            case "json": {
                return data instanceof String && ProtocolUtils.isValidJson((String)data);
            }
            case "binary": {
                return data instanceof byte[] || data instanceof ByteBuffer;
            }
            case "xml": {
                return data instanceof String && this.isValidXml((String)data);
            }
        }
        return false;
    }

    @Override
    public boolean validateVersion(T data, String protocolVersion) {
        if (protocolVersion == null) {
            return false;
        }
        return this.supportedVersion.equals(protocolVersion);
    }

    @Override
    public boolean validateSize(T data) {
        if (data == null) {
            return false;
        }
        int size = ProtocolUtils.getSizeInBytes(data);
        return size <= this.maxSize;
    }

    @Override
    public boolean validateIntegrity(T data) {
        if (data == null) {
            return false;
        }
        try {
            if (data instanceof String) {
                String str = (String)data;
                return !str.contains("\u0000") && !this.containsInvalidControlChars(str);
            }
            if (data instanceof byte[]) {
                return ((byte[])data).length > 0;
            }
            if (data instanceof ByteBuffer) {
                return ((ByteBuffer)data).remaining() > 0;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public List<String> getSupportedRules() {
        return List.of("format", "version", "size", "integrity", "schema");
    }

    private boolean containsInvalidControlChars(String str) {
        for (char c : str.toCharArray()) {
            if (!Character.isISOControl(c) || c == '\n' || c == '\r' || c == '\t') continue;
            return true;
        }
        return false;
    }

    private boolean isValidXml(String xml) {
        int closeTags;
        if (xml == null || xml.trim().isEmpty()) {
            return false;
        }
        String trimmed = xml.trim();
        if (!trimmed.startsWith("<") || !trimmed.endsWith(">")) {
            return false;
        }
        int openTags = this.countOccurrences(trimmed, "<");
        return openTags == (closeTags = this.countOccurrences(trimmed, ">")) && openTags > 0;
    }

    private int countOccurrences(String str, String sub) {
        int count = 0;
        int index = 0;
        while ((index = str.indexOf(sub, index)) != -1) {
            ++count;
            index += sub.length();
        }
        return count;
    }

    public static ProtocolValidatorImpl<String> createJsonValidator() {
        return new ProtocolValidatorImpl<String>(String.class, 0xA00000, "2.0");
    }

    public static ProtocolValidatorImpl<byte[]> createBinaryValidator() {
        return new ProtocolValidatorImpl<byte[]>(byte[].class, 0x3200000, "2.0");
    }
}

