/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.binary;

import com.kneaf.core.binary.ManualSerializers;
import com.kneaf.core.data.entity.EntityData;
import com.kneaf.core.data.entity.MobData;
import com.kneaf.core.data.entity.PlayerData;
import com.kneaf.core.performance.BinaryZeroCopyFacade;
import com.kneaf.core.performance.core.MobProcessResult;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;

public final class EnhancedManualSerializers {
    private static final BinaryZeroCopyFacade.ZeroCopyWrapper ZERO_COPY_WRAPPER = new BinaryZeroCopyFacade.ZeroCopyWrapper();

    private EnhancedManualSerializers() {
    }

    public static ByteBuffer serializeEntityInputZeroCopy(long tickCount, List<EntityData> entities, List<PlayerData> players) throws Exception {
        try {
            ByteBuffer stdBuffer = ManualSerializers.serializeEntityInput(tickCount, entities, players);
            ByteBuffer zeroCopyBuffer = BinaryZeroCopyFacade.ZeroCopyWrapper.createDirectBuffer(stdBuffer.remaining());
            zeroCopyBuffer.put(stdBuffer);
            zeroCopyBuffer.flip();
            return zeroCopyBuffer;
        }
        catch (Exception e) {
            return ManualSerializers.serializeEntityInput(tickCount, entities, players);
        }
    }

    public static List<Long> deserializeEntityProcessResultZeroCopy(ByteBuffer buffer) throws Exception {
        if (buffer.isDirect()) {
            try {
                return ManualSerializers.deserializeEntityProcessResult(buffer);
            }
            catch (Exception e) {
                return ManualSerializers.deserializeEntityProcessResult(buffer);
            }
        }
        return ManualSerializers.deserializeEntityProcessResult(buffer);
    }

    public static ByteBuffer serializeMobInputZeroCopy(long tickCount, List<MobData> mobs) throws Exception {
        try {
            ByteBuffer stdBuffer = ManualSerializers.serializeMobInput(tickCount, mobs);
            ByteBuffer zeroCopyBuffer = BinaryZeroCopyFacade.ZeroCopyWrapper.createDirectBuffer(stdBuffer.remaining());
            zeroCopyBuffer.put(stdBuffer);
            zeroCopyBuffer.flip();
            return zeroCopyBuffer;
        }
        catch (Exception e) {
            return ManualSerializers.serializeMobInput(tickCount, mobs);
        }
    }

    public static List<MobData> deserializeMobProcessResultZeroCopy(ByteBuffer buffer) throws Exception {
        if (buffer.isDirect()) {
            try {
                byte[] resultBytes = ZERO_COPY_WRAPPER.deserializeMobInput(buffer);
                ByteBuffer resultBuffer = ByteBuffer.wrap(resultBytes).order(ByteOrder.LITTLE_ENDIAN);
                return ManualSerializers.deserializeMobProcessResult(resultBuffer);
            }
            catch (Exception e) {
                return ManualSerializers.deserializeMobProcessResult(buffer);
            }
        }
        return ManualSerializers.deserializeMobProcessResult(buffer);
    }

    public static byte[] serializeMobResultZeroCopy(MobProcessResult result) throws Exception {
        try {
            byte[] stdBuffer = ManualSerializers.serializeMobResult(result);
            ByteBuffer directBuffer = BinaryZeroCopyFacade.ZeroCopyWrapper.createDirectBuffer(stdBuffer.length);
            directBuffer.put(stdBuffer);
            directBuffer.flip();
            return ZERO_COPY_WRAPPER.serializeMobResult(directBuffer);
        }
        catch (Exception e) {
            byte[] resultBytes = ManualSerializers.serializeMobResult(result);
            return resultBytes;
        }
    }

    public static boolean isZeroCopyAvailable() {
        try {
            ByteBuffer testBuffer = BinaryZeroCopyFacade.ZeroCopyWrapper.createDirectBuffer(16);
            return testBuffer != null && testBuffer.isDirect();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getZeroCopyStats() {
        try {
            return ZERO_COPY_WRAPPER.getNativeVersion();
        }
        catch (Exception e) {
            return "zero-copy: unavailable";
        }
    }
}

