/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.chunkstorage.database;

import com.kneaf.core.chunkstorage.common.ChunkStorageExceptionHandler;
import com.kneaf.core.chunkstorage.database.DatabaseAdapter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public abstract class AbstractDatabaseAdapter
implements DatabaseAdapter {
    protected final String databaseName;
    protected volatile boolean healthy = true;

    public AbstractDatabaseAdapter(String databaseName) {
        if (databaseName == null || databaseName.isEmpty()) {
            throw new IllegalArgumentException("Database name cannot be null or empty");
        }
        this.databaseName = databaseName;
    }

    @Override
    public CompletableFuture<Void> putChunkAsync(String key, byte[] data) {
        return CompletableFuture.runAsync(() -> {
            try {
                this.putChunk(key, data);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to put chunk asynchronously", e);
            }
        });
    }

    @Override
    public CompletableFuture<Optional<byte[]>> getChunkAsync(String key) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.getChunk(key);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to get chunk asynchronously", e);
            }
        });
    }

    @Override
    public CompletableFuture<Boolean> deleteChunkAsync(String key) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.deleteChunk(key);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to delete chunk asynchronously", e);
            }
        });
    }

    @Override
    public boolean isHealthy() {
        return this.healthy;
    }

    @Override
    public void createBackup(String backupPath) throws IOException {
        throw new UnsupportedOperationException("Backup not supported by this database adapter");
    }

    @Override
    public boolean swapOutChunk(String chunkKey) throws IOException {
        try {
            byte[] swapMarker = this.createSwapMarker(chunkKey);
            this.putChunk(this.getSwapKey(chunkKey), swapMarker);
            return true;
        }
        catch (Exception e) {
            ChunkStorageExceptionHandler.logDebug(this.getDatabaseType(), "Swap out failed for chunk { }: { }", chunkKey, e.getMessage());
            return false;
        }
    }

    @Override
    public Optional<byte[]> swapInChunk(String chunkKey) throws IOException {
        try {
            String swapKey = this.getSwapKey(chunkKey);
            if (this.hasChunk(swapKey)) {
                this.deleteChunk(swapKey);
                return this.getChunk(chunkKey);
            }
            return Optional.empty();
        }
        catch (Exception e) {
            ChunkStorageExceptionHandler.logDebug(this.getDatabaseType(), "Swap in failed for chunk { }: { }", chunkKey, e.getMessage());
            return Optional.empty();
        }
    }

    protected byte[] createSwapMarker(String chunkKey) {
        String marker = "SWAP_MARKER:" + chunkKey + ":" + System.currentTimeMillis();
        return marker.getBytes(StandardCharsets.UTF_8);
    }

    protected String getSwapKey(String chunkKey) {
        return "SWAP:" + chunkKey;
    }

    protected void setHealthy(boolean healthy) {
        this.healthy = healthy;
    }

    public String toString() {
        return String.format("%s[name=%s, healthy=%s]", this.getClass().getSimpleName(), this.databaseName, this.healthy);
    }
}

