/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.config;

import java.util.Arrays;

public class PerformanceConfiguration {
    private final boolean enabled;
    private final int threadpoolSize;
    private final int logIntervalTicks;
    private final int scanIntervalTicks;
    private final double tpsThresholdForAsync;
    private final int maxEntitiesToCollect;
    private final double entityDistanceCutoff;
    private final long maxLogBytes;
    private final boolean adaptiveThreadPool;
    private final int maxThreadpoolSize;
    private final String[] excludedEntityTypes;
    private final int networkExecutorpoolSize;
    private final boolean profilingEnabled;
    private final long slowTickThresholdMs;
    private final int profilingSampleRate;
    private final int minThreadpoolSize;
    private final boolean dynamicThreadScaling;
    private final double threadScaleUpThreshold;
    private final double threadScaleDownThreshold;
    private final int threadScaleUpDelayTicks;
    private final int threadScaleDownDelayTicks;
    private final boolean workStealingEnabled;
    private final int workStealingQueueSize;
    private final boolean cpuAwareThreadSizing;
    private final double cpuLoadThreshold;
    private final int threadPoolKeepAliveSeconds;
    private final int distanceCalculationInterval;
    private final boolean distanceApproximationEnabled;
    private final int distanceCacheSize;
    private final int itemProcessingIntervalMultiplier;
    private final int spatialGridUpdateInterval;
    private final boolean incrementalSpatialUpdates;
    private final boolean enableExtremeAvx512;
    private final boolean enableLockFreePooling;
    private final double memoryPressureThreshold;
    private final boolean enableAggressivePreallocation;
    private final int preallocationBufferSize;
    private final boolean enableSafetyChecks;
    private final boolean enableMemoryLeakDetection;
    private final boolean enablePerformanceMonitoring;
    private final boolean enableErrorRecovery;
    private final boolean enableMinimalMonitoring;
    private final int monitoringSampleRate;
    private final boolean enablePerformanceWarnings;
    private final boolean enableFeatureFlags;
    private final boolean enableAutoRollback;
    private final double rollbackThreshold;
    private final int rollbackCheckInterval;
    private final boolean enableUltraPerformanceMode;
    private final boolean enableAggressiveOptimizations;
    private final int maxConcurrentOperations;
    private final int batchSize;
    private final int prefetchDistance;
    private final int cacheSizeMb;
    private final boolean enableSafetyChecksUltra;
    private final boolean enableBoundsCheckingUltra;
    private final boolean enableNullChecksUltra;
    private final boolean enableAggressiveInlining;
    private final boolean enableLoopUnrolling;
    private final boolean enableVectorization;
    private final boolean enableMemoryPoolingUltra;
    private final int poolSizeMbUltra;
    private final boolean enableSimdUltra;
    private final int simdBatchSizeUltra;
    private final boolean enableBranchHints;
    private final boolean enableCachePrefetching;

    private PerformanceConfiguration(Builder builder) {
        this.enabled = builder.enabled;
        this.threadpoolSize = builder.threadpoolSize;
        this.logIntervalTicks = builder.logIntervalTicks;
        this.scanIntervalTicks = builder.scanIntervalTicks;
        this.tpsThresholdForAsync = builder.tpsThresholdForAsync;
        this.maxEntitiesToCollect = builder.maxEntitiesToCollect;
        this.entityDistanceCutoff = builder.entityDistanceCutoff;
        this.maxLogBytes = builder.maxLogBytes;
        this.adaptiveThreadPool = builder.adaptiveThreadPool;
        this.maxThreadpoolSize = builder.maxThreadpoolSize;
        this.excludedEntityTypes = builder.excludedEntityTypes == null ? new String[]{} : (String[])builder.excludedEntityTypes.clone();
        this.networkExecutorpoolSize = builder.networkExecutorpoolSize;
        this.profilingEnabled = builder.profilingEnabled;
        this.slowTickThresholdMs = builder.slowTickThresholdMs;
        this.profilingSampleRate = builder.profilingSampleRate;
        this.minThreadpoolSize = builder.minThreadpoolSize;
        this.dynamicThreadScaling = builder.dynamicThreadScaling;
        this.threadScaleUpThreshold = builder.threadScaleUpThreshold;
        this.threadScaleDownThreshold = builder.threadScaleDownThreshold;
        this.threadScaleUpDelayTicks = builder.threadScaleUpDelayTicks;
        this.threadScaleDownDelayTicks = builder.threadScaleDownDelayTicks;
        this.workStealingEnabled = builder.workStealingEnabled;
        this.workStealingQueueSize = builder.workStealingQueueSize;
        this.cpuAwareThreadSizing = builder.cpuAwareThreadSizing;
        this.cpuLoadThreshold = builder.cpuLoadThreshold;
        this.threadPoolKeepAliveSeconds = builder.threadPoolKeepAliveSeconds;
        this.distanceCalculationInterval = builder.distanceCalculationInterval;
        this.distanceApproximationEnabled = builder.distanceApproximationEnabled;
        this.distanceCacheSize = builder.distanceCacheSize;
        this.itemProcessingIntervalMultiplier = builder.itemProcessingIntervalMultiplier;
        this.spatialGridUpdateInterval = builder.spatialGridUpdateInterval;
        this.incrementalSpatialUpdates = builder.incrementalSpatialUpdates;
        this.enableExtremeAvx512 = builder.enableExtremeAvx512;
        this.enableLockFreePooling = builder.enableLockFreePooling;
        this.memoryPressureThreshold = builder.memoryPressureThreshold;
        this.enableAggressivePreallocation = builder.enableAggressivePreallocation;
        this.preallocationBufferSize = builder.preallocationBufferSize;
        this.enableSafetyChecks = builder.enableSafetyChecks;
        this.enableMemoryLeakDetection = builder.enableMemoryLeakDetection;
        this.enablePerformanceMonitoring = builder.enablePerformanceMonitoring;
        this.enableErrorRecovery = builder.enableErrorRecovery;
        this.enableMinimalMonitoring = builder.enableMinimalMonitoring;
        this.monitoringSampleRate = builder.monitoringSampleRate;
        this.enablePerformanceWarnings = builder.enablePerformanceWarnings;
        this.enableFeatureFlags = builder.enableFeatureFlags;
        this.enableAutoRollback = builder.enableAutoRollback;
        this.rollbackThreshold = builder.rollbackThreshold;
        this.rollbackCheckInterval = builder.rollbackCheckInterval;
        this.enableUltraPerformanceMode = builder.enableUltraPerformanceMode;
        this.enableAggressiveOptimizations = builder.enableAggressiveOptimizations;
        this.maxConcurrentOperations = builder.maxConcurrentOperations;
        this.batchSize = builder.batchSize;
        this.prefetchDistance = builder.prefetchDistance;
        this.cacheSizeMb = builder.cacheSizeMb;
        this.enableSafetyChecksUltra = builder.enableSafetyChecksUltra;
        this.enableBoundsCheckingUltra = builder.enableBoundsCheckingUltra;
        this.enableNullChecksUltra = builder.enableNullChecksUltra;
        this.enableAggressiveInlining = builder.enableAggressiveInlining;
        this.enableLoopUnrolling = builder.enableLoopUnrolling;
        this.enableVectorization = builder.enableVectorization;
        this.enableMemoryPoolingUltra = builder.enableMemoryPoolingUltra;
        this.poolSizeMbUltra = builder.poolSizeMbUltra;
        this.enableSimdUltra = builder.enableSimdUltra;
        this.simdBatchSizeUltra = builder.simdBatchSizeUltra;
        this.enableBranchHints = builder.enableBranchHints;
        this.enableCachePrefetching = builder.enableCachePrefetching;
        this.validate();
    }

    private void validate() {
        if (this.minThreadpoolSize > this.maxThreadpoolSize) {
            throw new IllegalArgumentException("minThreadpoolSize (" + this.minThreadpoolSize + ") cannot be greater than maxThreadpoolSize (" + this.maxThreadpoolSize + ")");
        }
        if (this.threadScaleUpThreshold <= this.threadScaleDownThreshold) {
            throw new IllegalArgumentException("threadScaleUpThreshold (" + this.threadScaleUpThreshold + ") must be greater than threadScaleDownThreshold (" + this.threadScaleDownThreshold + ")");
        }
        if (this.scanIntervalTicks < 1 || this.scanIntervalTicks > 100) {
            throw new IllegalArgumentException("scanIntervalTicks must be between 1 and 100, got: " + this.scanIntervalTicks);
        }
        if (this.tpsThresholdForAsync < 10.0 || this.tpsThresholdForAsync > 20.0) {
            throw new IllegalArgumentException("tpsThresholdForAsync must be between 10.0 and 20.0, got: " + this.tpsThresholdForAsync);
        }
        this.validateThreadScalingConfiguration();
        this.validateConfigurationConsistency();
    }

    private void validateThreadScalingConfiguration() {
        if (this.dynamicThreadScaling && this.adaptiveThreadPool) {
            if (this.threadpoolSize < this.minThreadpoolSize) {
                throw new IllegalArgumentException("When both dynamicThreadScaling and adaptiveThreadPool are enabled, threadpoolSize (" + this.threadpoolSize + ") must be >= minThreadpoolSize (" + this.minThreadpoolSize + ")");
            }
            if (this.maxThreadpoolSize < this.threadpoolSize) {
                throw new IllegalArgumentException("When both dynamicThreadScaling and adaptiveThreadPool are enabled, maxThreadpoolSize (" + this.maxThreadpoolSize + ") must be >= threadpoolSize (" + this.threadpoolSize + ")");
            }
        }
        if (this.dynamicThreadScaling && !this.adaptiveThreadPool && this.minThreadpoolSize == this.maxThreadpoolSize) {
            throw new IllegalArgumentException("When dynamicThreadScaling is enabled without adaptiveThreadPool, minThreadpoolSize and maxThreadpoolSize must be different to allow scaling");
        }
        if (!this.dynamicThreadScaling && this.adaptiveThreadPool && this.threadpoolSize == this.minThreadpoolSize && this.threadpoolSize == this.maxThreadpoolSize) {
            throw new IllegalArgumentException("When adaptiveThreadPool is enabled without dynamicThreadScaling, threadpoolSize should be different from minThreadpoolSize/maxThreadpoolSize to allow adaptation");
        }
    }

    private void validateConfigurationConsistency() {
        if (this.workStealingEnabled && this.workStealingQueueSize <= 0) {
            throw new IllegalArgumentException("workStealingQueueSize must be positive when workStealingEnabled is true, got: " + this.workStealingQueueSize);
        }
        if (this.cpuAwareThreadSizing && this.cpuLoadThreshold < 0.0 || this.cpuLoadThreshold > 1.0) {
            throw new IllegalArgumentException("cpuLoadThreshold must be between 0.0 and 1.0 when cpuAwareThreadSizing is enabled, got: " + this.cpuLoadThreshold);
        }
        if (this.threadPoolKeepAliveSeconds < 0) {
            throw new IllegalArgumentException("threadPoolKeepAliveSeconds must be non-negative, got: " + this.threadPoolKeepAliveSeconds);
        }
        if (this.distanceCacheSize <= 0) {
            throw new IllegalArgumentException("distanceCacheSize must be positive, got: " + this.distanceCacheSize);
        }
        if (this.itemProcessingIntervalMultiplier <= 0) {
            throw new IllegalArgumentException("itemProcessingIntervalMultiplier must be positive, got: " + this.itemProcessingIntervalMultiplier);
        }
        if (this.memoryPressureThreshold < 0.0 || this.memoryPressureThreshold > 1.0) {
            throw new IllegalArgumentException("memoryPressureThreshold must be between 0.0 and 1.0, got: " + this.memoryPressureThreshold);
        }
        if (this.preallocationBufferSize < 0) {
            throw new IllegalArgumentException("preallocationBufferSize must be non-negative, got: " + this.preallocationBufferSize);
        }
        if (this.rollbackThreshold < 0.0 || this.rollbackThreshold > 100.0) {
            throw new IllegalArgumentException("rollbackThreshold must be between 0.0 and 100.0, got: " + this.rollbackThreshold);
        }
        if (this.rollbackCheckInterval <= 0) {
            throw new IllegalArgumentException("rollbackCheckInterval must be positive, got: " + this.rollbackCheckInterval);
        }
        if (this.monitoringSampleRate <= 0) {
            throw new IllegalArgumentException("monitoringSampleRate must be positive, got: " + this.monitoringSampleRate);
        }
    }

    public void checkRuntimeConsistency() {
        if (this.dynamicThreadScaling && this.getCurrentThreadpoolSize() < this.minThreadpoolSize) {
            throw new IllegalStateException("Runtime threadpool size (" + this.getCurrentThreadpoolSize() + ") is below minThreadpoolSize (" + this.minThreadpoolSize + ")");
        }
        if (this.adaptiveThreadPool && this.getCurrentThreadpoolSize() > this.maxThreadpoolSize) {
            throw new IllegalStateException("Runtime threadpool size (" + this.getCurrentThreadpoolSize() + ") exceeds maxThreadpoolSize (" + this.maxThreadpoolSize + ")");
        }
        if (this.dynamicThreadScaling != this.isDynamicThreadScaling()) {
            throw new IllegalStateException("Dynamic thread scaling configuration has drifted - runtime value differs from configured value");
        }
        if (this.adaptiveThreadPool != this.isAdaptiveThreadPool()) {
            throw new IllegalStateException("Adaptive thread pool configuration has drifted - runtime value differs from configured value");
        }
    }

    private int getCurrentThreadpoolSize() {
        return this.threadpoolSize;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getThreadpoolSize() {
        return this.threadpoolSize;
    }

    public int getLogIntervalTicks() {
        return this.logIntervalTicks;
    }

    public int getScanIntervalTicks() {
        return this.scanIntervalTicks;
    }

    public double getTpsThresholdForAsync() {
        return this.tpsThresholdForAsync;
    }

    public int getMaxEntitiesToCollect() {
        return this.maxEntitiesToCollect;
    }

    public double getEntityDistanceCutoff() {
        return this.entityDistanceCutoff;
    }

    public long getMaxLogBytes() {
        return this.maxLogBytes;
    }

    public boolean isAdaptiveThreadPool() {
        return this.adaptiveThreadPool;
    }

    public int getMaxThreadpoolSize() {
        return this.maxThreadpoolSize;
    }

    public String[] getExcludedEntityTypes() {
        return (String[])this.excludedEntityTypes.clone();
    }

    public int getNetworkExecutorpoolSize() {
        return this.networkExecutorpoolSize;
    }

    public boolean isProfilingEnabled() {
        return this.profilingEnabled;
    }

    public long getSlowTickThresholdMs() {
        return this.slowTickThresholdMs;
    }

    public int getProfilingSampleRate() {
        return this.profilingSampleRate;
    }

    public int getMinThreadpoolSize() {
        return this.minThreadpoolSize;
    }

    public boolean isDynamicThreadScaling() {
        return this.dynamicThreadScaling;
    }

    public double getThreadScaleUpThreshold() {
        return this.threadScaleUpThreshold;
    }

    public double getThreadScaleDownThreshold() {
        return this.threadScaleDownThreshold;
    }

    public int getThreadScaleUpDelayTicks() {
        return this.threadScaleUpDelayTicks;
    }

    public int getThreadScaleDownDelayTicks() {
        return this.threadScaleDownDelayTicks;
    }

    public boolean isWorkStealingEnabled() {
        return this.workStealingEnabled;
    }

    public int getWorkStealingQueueSize() {
        return this.workStealingQueueSize;
    }

    public boolean isCpuAwareThreadSizing() {
        return this.cpuAwareThreadSizing;
    }

    public double getCpuLoadThreshold() {
        return this.cpuLoadThreshold;
    }

    public int getThreadPoolKeepAliveSeconds() {
        return this.threadPoolKeepAliveSeconds;
    }

    public int getDistanceCalculationInterval() {
        return this.distanceCalculationInterval;
    }

    public boolean isDistanceApproximationEnabled() {
        return this.distanceApproximationEnabled;
    }

    public int getDistanceCacheSize() {
        return this.distanceCacheSize;
    }

    public int getItemProcessingIntervalMultiplier() {
        return this.itemProcessingIntervalMultiplier;
    }

    public int getSpatialGridUpdateInterval() {
        return this.spatialGridUpdateInterval;
    }

    public boolean isIncrementalSpatialUpdates() {
        return this.incrementalSpatialUpdates;
    }

    public boolean isEnableExtremeAvx512() {
        return this.enableExtremeAvx512;
    }

    public boolean isEnableLockFreePooling() {
        return this.enableLockFreePooling;
    }

    public double getMemoryPressureThreshold() {
        return this.memoryPressureThreshold;
    }

    public boolean isEnableAggressivePreallocation() {
        return this.enableAggressivePreallocation;
    }

    public int getPreallocationBufferSize() {
        return this.preallocationBufferSize;
    }

    public boolean isEnableSafetyChecks() {
        return this.enableSafetyChecks;
    }

    public boolean isEnableMemoryLeakDetection() {
        return this.enableMemoryLeakDetection;
    }

    public boolean isEnablePerformanceMonitoring() {
        return this.enablePerformanceMonitoring;
    }

    public boolean isEnableErrorRecovery() {
        return this.enableErrorRecovery;
    }

    public boolean isEnableMinimalMonitoring() {
        return this.enableMinimalMonitoring;
    }

    public int getMonitoringSampleRate() {
        return this.monitoringSampleRate;
    }

    public boolean isEnablePerformanceWarnings() {
        return this.enablePerformanceWarnings;
    }

    public boolean isEnableFeatureFlags() {
        return this.enableFeatureFlags;
    }

    public boolean isEnableAutoRollback() {
        return this.enableAutoRollback;
    }

    public double getRollbackThreshold() {
        return this.rollbackThreshold;
    }

    public int getRollbackCheckInterval() {
        return this.rollbackCheckInterval;
    }

    public boolean isEnableUltraPerformanceMode() {
        return this.enableUltraPerformanceMode;
    }

    public boolean isEnableAggressiveOptimizations() {
        return this.enableAggressiveOptimizations;
    }

    public int getMaxConcurrentOperations() {
        return this.maxConcurrentOperations;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public int getPrefetchDistance() {
        return this.prefetchDistance;
    }

    public int getCacheSizeMb() {
        return this.cacheSizeMb;
    }

    public boolean isEnableSafetyChecksUltra() {
        return this.enableSafetyChecksUltra;
    }

    public boolean isEnableBoundsCheckingUltra() {
        return this.enableBoundsCheckingUltra;
    }

    public boolean isEnableNullChecksUltra() {
        return this.enableNullChecksUltra;
    }

    public boolean isEnableAggressiveInlining() {
        return this.enableAggressiveInlining;
    }

    public boolean isEnableLoopUnrolling() {
        return this.enableLoopUnrolling;
    }

    public boolean isEnableVectorization() {
        return this.enableVectorization;
    }

    public boolean isEnableMemoryPoolingUltra() {
        return this.enableMemoryPoolingUltra;
    }

    public int getPoolSizeMbUltra() {
        return this.poolSizeMbUltra;
    }

    public boolean isEnableSimdUltra() {
        return this.enableSimdUltra;
    }

    public int getSimdBatchSizeUltra() {
        return this.simdBatchSizeUltra;
    }

    public boolean isEnableBranchHints() {
        return this.enableBranchHints;
    }

    public boolean isEnableCachePrefetching() {
        return this.enableCachePrefetching;
    }

    public String toString() {
        return "PerformanceConfiguration{enabled=" + this.enabled + ", threadpoolSize=" + this.threadpoolSize + ", logIntervalTicks=" + this.logIntervalTicks + ", scanIntervalTicks=" + this.scanIntervalTicks + ", tpsThresholdForAsync=" + this.tpsThresholdForAsync + ", maxEntitiesToCollect=" + this.maxEntitiesToCollect + ", entityDistanceCutoff=" + this.entityDistanceCutoff + ", maxLogBytes=" + this.maxLogBytes + ", adaptiveThreadPool=" + this.adaptiveThreadPool + ", maxThreadpoolSize=" + this.maxThreadpoolSize + ", excludedEntityTypes=" + Arrays.toString(this.excludedEntityTypes) + ", profilingEnabled=" + this.profilingEnabled + ", slowTickThresholdMs=" + this.slowTickThresholdMs + ", profilingSampleRate=" + this.profilingSampleRate + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private boolean enabled = true;
        private int threadpoolSize = 4;
        private int logIntervalTicks = 100;
        private int scanIntervalTicks = 1;
        private double tpsThresholdForAsync = 19.0;
        private int maxEntitiesToCollect = 20000;
        private double entityDistanceCutoff = 256.0;
        private long maxLogBytes = 0xA00000L;
        private boolean adaptiveThreadPool = false;
        private int maxThreadpoolSize = Math.max(1, Runtime.getRuntime().availableProcessors() - 1);
        private String[] excludedEntityTypes = new String[0];
        private int networkExecutorpoolSize = Math.max(1, Runtime.getRuntime().availableProcessors() / 2);
        private boolean profilingEnabled = true;
        private long slowTickThresholdMs = 50L;
        private int profilingSampleRate = 100;
        private int minThreadpoolSize = 2;
        private boolean dynamicThreadScaling = true;
        private double threadScaleUpThreshold = 0.8;
        private double threadScaleDownThreshold = 0.3;
        private int threadScaleUpDelayTicks = 100;
        private int threadScaleDownDelayTicks = 200;
        private boolean workStealingEnabled = true;
        private int workStealingQueueSize = 100;
        private boolean cpuAwareThreadSizing = false;
        private double cpuLoadThreshold = 0.7;
        private int threadPoolKeepAliveSeconds = 60;
        private int distanceCalculationInterval = 1;
        private boolean distanceApproximationEnabled = true;
        private int distanceCacheSize = 100;
        private int itemProcessingIntervalMultiplier = 1;
        private int spatialGridUpdateInterval = 1;
        private boolean incrementalSpatialUpdates = true;
        private boolean enableExtremeAvx512 = false;
        private boolean enableLockFreePooling = false;
        private double memoryPressureThreshold = 0.9;
        private boolean enableAggressivePreallocation = false;
        private int preallocationBufferSize = 512;
        private boolean enableSafetyChecks = true;
        private boolean enableMemoryLeakDetection = true;
        private boolean enablePerformanceMonitoring = true;
        private boolean enableErrorRecovery = true;
        private boolean enableMinimalMonitoring = false;
        private int monitoringSampleRate = 100;
        private boolean enablePerformanceWarnings = true;
        private boolean enableFeatureFlags = false;
        private boolean enableAutoRollback = false;
        private double rollbackThreshold = 20.0;
        private int rollbackCheckInterval = 1000;
        private boolean enableUltraPerformanceMode = false;
        private boolean enableAggressiveOptimizations = false;
        private int maxConcurrentOperations = 32;
        private int batchSize = 64;
        private int prefetchDistance = 8;
        private int cacheSizeMb = 512;
        private boolean enableSafetyChecksUltra = false;
        private boolean enableBoundsCheckingUltra = false;
        private boolean enableNullChecksUltra = false;
        private boolean enableAggressiveInlining = false;
        private boolean enableLoopUnrolling = false;
        private boolean enableVectorization = false;
        private boolean enableMemoryPoolingUltra = false;
        private int poolSizeMbUltra = 256;
        private boolean enableSimdUltra = false;
        private int simdBatchSizeUltra = 16;
        private boolean enableBranchHints = false;
        private boolean enableCachePrefetching = false;

        public Builder enabled(boolean v) {
            this.enabled = v;
            return this;
        }

        public Builder threadpoolSize(int v) {
            this.threadpoolSize = v;
            return this;
        }

        public Builder logIntervalTicks(int v) {
            this.logIntervalTicks = v;
            return this;
        }

        public Builder scanIntervalTicks(int v) {
            this.scanIntervalTicks = v;
            return this;
        }

        public Builder tpsThresholdForAsync(double v) {
            this.tpsThresholdForAsync = v;
            return this;
        }

        public Builder maxEntitiesToCollect(int v) {
            this.maxEntitiesToCollect = v;
            return this;
        }

        public Builder entityDistanceCutoff(double v) {
            this.entityDistanceCutoff = v;
            return this;
        }

        public Builder maxLogBytes(long v) {
            this.maxLogBytes = v;
            return this;
        }

        public Builder adaptiveThreadPool(boolean v) {
            this.adaptiveThreadPool = v;
            return this;
        }

        public Builder maxThreadpoolSize(int v) {
            this.maxThreadpoolSize = v;
            return this;
        }

        public Builder excludedEntityTypes(String[] v) {
            this.excludedEntityTypes = v == null ? new String[]{} : (String[])v.clone();
            return this;
        }

        public Builder networkExecutorpoolSize(int v) {
            this.networkExecutorpoolSize = v;
            return this;
        }

        public Builder profilingEnabled(boolean v) {
            this.profilingEnabled = v;
            return this;
        }

        public Builder slowTickThresholdMs(long v) {
            this.slowTickThresholdMs = v;
            return this;
        }

        public Builder profilingSampleRate(int v) {
            this.profilingSampleRate = v;
            return this;
        }

        public Builder minThreadpoolSize(int v) {
            this.minThreadpoolSize = v;
            return this;
        }

        public Builder dynamicThreadScaling(boolean v) {
            this.dynamicThreadScaling = v;
            return this;
        }

        public Builder threadScaleUpThreshold(double v) {
            this.threadScaleUpThreshold = v;
            return this;
        }

        public Builder threadScaleDownThreshold(double v) {
            this.threadScaleDownThreshold = v;
            return this;
        }

        public Builder threadScaleUpDelayTicks(int v) {
            this.threadScaleUpDelayTicks = v;
            return this;
        }

        public Builder threadScaleDownDelayTicks(int v) {
            this.threadScaleDownDelayTicks = v;
            return this;
        }

        public Builder workStealingEnabled(boolean v) {
            this.workStealingEnabled = v;
            return this;
        }

        public Builder workStealingQueueSize(int v) {
            this.workStealingQueueSize = v;
            return this;
        }

        public Builder cpuAwareThreadSizing(boolean v) {
            this.cpuAwareThreadSizing = v;
            return this;
        }

        public Builder cpuLoadThreshold(double v) {
            this.cpuLoadThreshold = v;
            return this;
        }

        public Builder threadPoolKeepAliveSeconds(int v) {
            this.threadPoolKeepAliveSeconds = v;
            return this;
        }

        public Builder distanceCalculationInterval(int v) {
            this.distanceCalculationInterval = v;
            return this;
        }

        public Builder distanceApproximationEnabled(boolean v) {
            this.distanceApproximationEnabled = v;
            return this;
        }

        public Builder distanceCacheSize(int v) {
            this.distanceCacheSize = v;
            return this;
        }

        public Builder itemProcessingIntervalMultiplier(int v) {
            this.itemProcessingIntervalMultiplier = v;
            return this;
        }

        public Builder spatialGridUpdateInterval(int v) {
            this.spatialGridUpdateInterval = v;
            return this;
        }

        public Builder incrementalSpatialUpdates(boolean v) {
            this.incrementalSpatialUpdates = v;
            return this;
        }

        public Builder enableExtremeAvx512(boolean v) {
            this.enableExtremeAvx512 = v;
            return this;
        }

        public Builder enableLockFreePooling(boolean v) {
            this.enableLockFreePooling = v;
            return this;
        }

        public Builder memoryPressureThreshold(double v) {
            this.memoryPressureThreshold = v;
            return this;
        }

        public Builder enableAggressivePreallocation(boolean v) {
            this.enableAggressivePreallocation = v;
            return this;
        }

        public Builder preallocationBufferSize(int v) {
            this.preallocationBufferSize = v;
            return this;
        }

        public Builder enableSafetyChecks(boolean v) {
            this.enableSafetyChecks = v;
            return this;
        }

        public Builder enableMemoryLeakDetection(boolean v) {
            this.enableMemoryLeakDetection = v;
            return this;
        }

        public Builder enablePerformanceMonitoring(boolean v) {
            this.enablePerformanceMonitoring = v;
            return this;
        }

        public Builder enableErrorRecovery(boolean v) {
            this.enableErrorRecovery = v;
            return this;
        }

        public Builder enableMinimalMonitoring(boolean v) {
            this.enableMinimalMonitoring = v;
            return this;
        }

        public Builder monitoringSampleRate(int v) {
            this.monitoringSampleRate = v;
            return this;
        }

        public Builder enablePerformanceWarnings(boolean v) {
            this.enablePerformanceWarnings = v;
            return this;
        }

        public Builder enableFeatureFlags(boolean v) {
            this.enableFeatureFlags = v;
            return this;
        }

        public Builder enableAutoRollback(boolean v) {
            this.enableAutoRollback = v;
            return this;
        }

        public Builder rollbackThreshold(double v) {
            this.rollbackThreshold = v;
            return this;
        }

        public Builder rollbackCheckInterval(int v) {
            this.rollbackCheckInterval = v;
            return this;
        }

        public Builder enableUltraPerformanceMode(boolean v) {
            this.enableUltraPerformanceMode = v;
            return this;
        }

        public Builder enableAggressiveOptimizations(boolean v) {
            this.enableAggressiveOptimizations = v;
            return this;
        }

        public Builder maxConcurrentOperations(int v) {
            this.maxConcurrentOperations = v;
            return this;
        }

        public Builder batchSize(int v) {
            this.batchSize = v;
            return this;
        }

        public Builder prefetchDistance(int v) {
            this.prefetchDistance = v;
            return this;
        }

        public Builder cacheSizeMb(int v) {
            this.cacheSizeMb = v;
            return this;
        }

        public Builder enableSafetyChecksUltra(boolean v) {
            this.enableSafetyChecksUltra = v;
            return this;
        }

        public Builder enableBoundsCheckingUltra(boolean v) {
            this.enableBoundsCheckingUltra = v;
            return this;
        }

        public Builder enableNullChecksUltra(boolean v) {
            this.enableNullChecksUltra = v;
            return this;
        }

        public Builder enableAggressiveInlining(boolean v) {
            this.enableAggressiveInlining = v;
            return this;
        }

        public Builder enableLoopUnrolling(boolean v) {
            this.enableLoopUnrolling = v;
            return this;
        }

        public Builder enableVectorization(boolean v) {
            this.enableVectorization = v;
            return this;
        }

        public Builder enableMemoryPoolingUltra(boolean v) {
            this.enableMemoryPoolingUltra = v;
            return this;
        }

        public Builder poolSizeMbUltra(int v) {
            this.poolSizeMbUltra = v;
            return this;
        }

        public Builder enableSimdUltra(boolean v) {
            this.enableSimdUltra = v;
            return this;
        }

        public Builder simdBatchSizeUltra(int v) {
            this.simdBatchSizeUltra = v;
            return this;
        }

        public Builder enableBranchHints(boolean v) {
            this.enableBranchHints = v;
            return this;
        }

        public Builder enableCachePrefetching(boolean v) {
            this.enableCachePrefetching = v;
            return this;
        }

        public PerformanceConfiguration build() {
            return new PerformanceConfiguration(this);
        }
    }
}

