/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.config;

import com.kneaf.core.config.PerformanceConfiguration;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;

public class UltraPerformanceConfiguration {
    private static final String CONFIG_FILE = "config/kneaf-performance-ultra.properties";
    private static PerformanceConfiguration config;

    public static PerformanceConfiguration load() {
        if (config != null) {
            return config;
        }
        Properties props = new Properties();
        Path configPath = Paths.get(CONFIG_FILE, new String[0]);
        try {
            if (Files.exists(configPath, new LinkOption[0])) {
                props.load(Files.newInputStream(configPath, new OpenOption[0]));
            }
        }
        catch (IOException e) {
            System.err.println("Failed to load ultra-performance configuration: " + e.getMessage());
        }
        config = PerformanceConfiguration.builder().enabled(UltraPerformanceConfiguration.getBoolean(props, "enabled", true)).threadpoolSize(UltraPerformanceConfiguration.getInt(props, "threadpoolSize", Math.max(1, Runtime.getRuntime().availableProcessors()))).logIntervalTicks(UltraPerformanceConfiguration.getInt(props, "logIntervalTicks", 1000)).scanIntervalTicks(UltraPerformanceConfiguration.getInt(props, "scanIntervalTicks", 1)).tpsThresholdForAsync(UltraPerformanceConfiguration.getDouble(props, "tpsThresholdForAsync", 17.0)).maxEntitiesToCollect(UltraPerformanceConfiguration.getInt(props, "maxEntitiesToCollect", 50000)).entityDistanceCutoff(UltraPerformanceConfiguration.getDouble(props, "entityDistanceCutoff", 128.0)).maxLogBytes(UltraPerformanceConfiguration.getLong(props, "maxLogBytes", 0x500000L)).adaptiveThreadPool(UltraPerformanceConfiguration.getBoolean(props, "adaptiveThreadPool", true)).maxThreadpoolSize(UltraPerformanceConfiguration.getInt(props, "maxThreadpoolSize", Math.max(1, Runtime.getRuntime().availableProcessors() * 2))).profilingEnabled(UltraPerformanceConfiguration.getBoolean(props, "profilingEnabled", false)).slowTickThresholdMs(UltraPerformanceConfiguration.getLong(props, "slowTickThresholdMs", 30L)).profilingSampleRate(UltraPerformanceConfiguration.getInt(props, "profilingSampleRate", 10)).minThreadpoolSize(UltraPerformanceConfiguration.getInt(props, "minThreadpoolSize", 1)).dynamicThreadScaling(UltraPerformanceConfiguration.getBoolean(props, "dynamicThreadScaling", true)).threadScaleUpThreshold(UltraPerformanceConfiguration.getDouble(props, "threadScaleUpThreshold", 0.9)).threadScaleDownThreshold(UltraPerformanceConfiguration.getDouble(props, "threadScaleDownThreshold", 0.2)).threadScaleUpDelayTicks(UltraPerformanceConfiguration.getInt(props, "threadScaleUpDelayTicks", 50)).threadScaleDownDelayTicks(UltraPerformanceConfiguration.getInt(props, "threadScaleDownDelayTicks", 100)).workStealingEnabled(UltraPerformanceConfiguration.getBoolean(props, "workStealingEnabled", true)).workStealingQueueSize(UltraPerformanceConfiguration.getInt(props, "workStealingQueueSize", 200)).cpuAwareThreadSizing(UltraPerformanceConfiguration.getBoolean(props, "cpuAwareThreadSizing", true)).cpuLoadThreshold(UltraPerformanceConfiguration.getDouble(props, "cpuLoadThreshold", 0.8)).threadPoolKeepAliveSeconds(UltraPerformanceConfiguration.getInt(props, "threadPoolKeepAliveSeconds", 30)).distanceCalculationInterval(UltraPerformanceConfiguration.getInt(props, "distanceCalculationInterval", 1)).distanceApproximationEnabled(UltraPerformanceConfiguration.getBoolean(props, "distanceApproximationEnabled", true)).distanceCacheSize(UltraPerformanceConfiguration.getInt(props, "distanceCacheSize", 500)).itemProcessingIntervalMultiplier(UltraPerformanceConfiguration.getInt(props, "itemProcessingIntervalMultiplier", 1)).spatialGridUpdateInterval(UltraPerformanceConfiguration.getInt(props, "spatialGridUpdateInterval", 1)).incrementalSpatialUpdates(UltraPerformanceConfiguration.getBoolean(props, "incrementalSpatialUpdates", true)).enableExtremeAvx512(UltraPerformanceConfiguration.getBoolean(props, "enableExtremeAvx512", true)).enableLockFreePooling(UltraPerformanceConfiguration.getBoolean(props, "enableLockFreePooling", true)).memoryPressureThreshold(UltraPerformanceConfiguration.getDouble(props, "memoryPressureThreshold", 0.95)).enableAggressivePreallocation(UltraPerformanceConfiguration.getBoolean(props, "enableAggressivePreallocation", true)).preallocationBufferSize(UltraPerformanceConfiguration.getInt(props, "preallocationBufferSize", 512)).enableSafetyChecks(UltraPerformanceConfiguration.getBoolean(props, "enableSafetyChecks", false)).enableMemoryLeakDetection(UltraPerformanceConfiguration.getBoolean(props, "enableMemoryLeakDetection", false)).enablePerformanceMonitoring(UltraPerformanceConfiguration.getBoolean(props, "enablePerformanceMonitoring", false)).enableErrorRecovery(UltraPerformanceConfiguration.getBoolean(props, "enableErrorRecovery", false)).enableMinimalMonitoring(UltraPerformanceConfiguration.getBoolean(props, "enableMinimalMonitoring", true)).monitoringSampleRate(UltraPerformanceConfiguration.getInt(props, "monitoringSampleRate", 5)).enablePerformanceWarnings(UltraPerformanceConfiguration.getBoolean(props, "enablePerformanceWarnings", false)).enableFeatureFlags(UltraPerformanceConfiguration.getBoolean(props, "enableFeatureFlags", true)).enableAutoRollback(UltraPerformanceConfiguration.getBoolean(props, "enableAutoRollback", false)).rollbackThreshold(UltraPerformanceConfiguration.getDouble(props, "rollbackThreshold", 50.0)).rollbackCheckInterval(UltraPerformanceConfiguration.getInt(props, "rollbackCheckInterval", 500)).enableUltraPerformanceMode(true).enableAggressiveOptimizations(true).maxConcurrentOperations(UltraPerformanceConfiguration.getInt(props, "maxConcurrentOperations", 64)).batchSize(UltraPerformanceConfiguration.getInt(props, "batchSize", 128)).prefetchDistance(UltraPerformanceConfiguration.getInt(props, "prefetchDistance", 16)).cacheSizeMb(UltraPerformanceConfiguration.getInt(props, "cacheSizeMb", 1024)).enableSafetyChecksUltra(false).enableBoundsCheckingUltra(false).enableNullChecksUltra(false).enableAggressiveInlining(true).enableLoopUnrolling(true).enableVectorization(true).enableMemoryPoolingUltra(true).poolSizeMbUltra(UltraPerformanceConfiguration.getInt(props, "poolSizeMbUltra", 512)).enableSimdUltra(true).simdBatchSizeUltra(UltraPerformanceConfiguration.getInt(props, "simdBatchSizeUltra", 32)).enableBranchHints(true).enableCachePrefetching(true).build();
        return config;
    }

    private static boolean getBoolean(Properties props, String key, boolean defaultValue) {
        String value = props.getProperty(key);
        return value != null ? Boolean.parseBoolean(value) : defaultValue;
    }

    private static int getInt(Properties props, String key, int defaultValue) {
        String value = props.getProperty(key);
        return value != null ? Integer.parseInt(value) : defaultValue;
    }

    private static long getLong(Properties props, String key, long defaultValue) {
        String value = props.getProperty(key);
        return value != null ? Long.parseLong(value) : defaultValue;
    }

    private static double getDouble(Properties props, String key, double defaultValue) {
        String value = props.getProperty(key);
        return value != null ? Double.parseDouble(value) : defaultValue;
    }

    public static PerformanceConfiguration getConfig() {
        return UltraPerformanceConfiguration.load();
    }
}

