/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.exceptions;

import com.kneaf.core.exceptions.nativelib.NativeLibraryException;

@Deprecated
public class NativeLibraryException
extends RuntimeException {
    private final com.kneaf.core.exceptions.nativelib.NativeLibraryException delegate;
    private final NativeErrorType errorType;
    private final String libraryName;
    private final String nativeMethod;

    public NativeLibraryException(NativeErrorType errorType, String message) {
        super(message);
        this.delegate = ((NativeLibraryException.Builder)com.kneaf.core.exceptions.nativelib.NativeLibraryException.builder().errorType(NativeLibraryException.convertErrorType(errorType)).message(message)).build();
        this.errorType = errorType;
        this.libraryName = null;
        this.nativeMethod = null;
    }

    public NativeLibraryException(NativeErrorType errorType, String message, Throwable cause) {
        super(message, cause);
        this.delegate = ((NativeLibraryException.Builder)((NativeLibraryException.Builder)com.kneaf.core.exceptions.nativelib.NativeLibraryException.builder().errorType(NativeLibraryException.convertErrorType(errorType)).message(message)).cause(cause)).build();
        this.errorType = errorType;
        this.libraryName = null;
        this.nativeMethod = null;
    }

    public NativeLibraryException(NativeErrorType errorType, String libraryName, String nativeMethod, String message, Throwable cause) {
        super(message, cause);
        this.delegate = ((NativeLibraryException.Builder)((NativeLibraryException.Builder)com.kneaf.core.exceptions.nativelib.NativeLibraryException.builder().errorType(NativeLibraryException.convertErrorType(errorType)).libraryName(libraryName).nativeMethod(nativeMethod).message(message)).cause(cause)).build();
        this.errorType = errorType;
        this.libraryName = libraryName;
        this.nativeMethod = nativeMethod;
    }

    public NativeErrorType getErrorType() {
        return this.errorType != null ? this.errorType : NativeLibraryException.convertErrorTypeBack(this.delegate.getErrorType());
    }

    public String getLibraryName() {
        return this.libraryName != null ? this.libraryName : this.delegate.getLibraryName();
    }

    public String getNativeMethod() {
        return this.nativeMethod != null ? this.nativeMethod : this.delegate.getNativeMethod();
    }

    public com.kneaf.core.exceptions.nativelib.NativeLibraryException getDelegate() {
        return this.delegate;
    }

    public static NativeLibraryException libraryNotAvailable(String libraryName) {
        return new NativeLibraryException(NativeErrorType.LIBRARY_NOT_AVAILABLE, libraryName, null, String.format("Native library '%s' is not available", libraryName), null);
    }

    public static NativeLibraryException binaryProtocolError(String operation, String details, Throwable cause) {
        return new NativeLibraryException(NativeErrorType.BINARY_PROTOCOL_ERROR, "rustperf", operation, String.format("Binary protocol error in %s: %s", operation, details), cause);
    }

    private static NativeLibraryException.NativeErrorType convertErrorType(NativeErrorType errorType) {
        if (errorType == null) {
            return null;
        }
        switch (errorType.ordinal()) {
            case 0: {
                return NativeLibraryException.NativeErrorType.LIBRARY_NOT_AVAILABLE;
            }
            case 1: {
                return NativeLibraryException.NativeErrorType.LIBRARY_LOAD_FAILED;
            }
            case 2: {
                return NativeLibraryException.NativeErrorType.NATIVE_CALL_FAILED;
            }
            case 3: {
                return NativeLibraryException.NativeErrorType.BINARY_PROTOCOL_ERROR;
            }
            case 4: {
                return NativeLibraryException.NativeErrorType.JNI_ERROR;
            }
            case 5: {
                return NativeLibraryException.NativeErrorType.MEMORY_ALLOCATION_FAILED;
            }
        }
        return NativeLibraryException.NativeErrorType.NATIVE_CALL_FAILED;
    }

    private static NativeErrorType convertErrorTypeBack(NativeLibraryException.NativeErrorType errorType) {
        if (errorType == null) {
            return null;
        }
        switch (errorType) {
            case LIBRARY_NOT_AVAILABLE: {
                return NativeErrorType.LIBRARY_NOT_AVAILABLE;
            }
            case LIBRARY_LOAD_FAILED: {
                return NativeErrorType.LIBRARY_LOAD_FAILED;
            }
            case NATIVE_CALL_FAILED: {
                return NativeErrorType.NATIVE_CALL_FAILED;
            }
            case BINARY_PROTOCOL_ERROR: {
                return NativeErrorType.BINARY_PROTOCOL_ERROR;
            }
            case JNI_ERROR: {
                return NativeErrorType.JNI_ERROR;
            }
            case MEMORY_ALLOCATION_FAILED: {
                return NativeErrorType.MEMORY_ALLOCATION_FAILED;
            }
        }
        return NativeErrorType.NATIVE_CALL_FAILED;
    }

    public static enum NativeErrorType {
        LIBRARY_NOT_AVAILABLE("Native library is not available"),
        LIBRARY_LOAD_FAILED("Failed to load native library"),
        NATIVE_CALL_FAILED("Native method call failed"),
        BINARY_PROTOCOL_ERROR("Binary protocol error"),
        JNI_ERROR("JNI error"),
        MEMORY_ALLOCATION_FAILED("Native memory allocation failed");

        private final String description;

        private NativeErrorType(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

