/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.performance.bridge;

import com.kneaf.core.performance.NativeFloatBuffer;
import com.kneaf.core.performance.RustPerformance;
import com.kneaf.core.performance.core.PerformanceConstants;
import com.kneaf.core.performance.monitoring.PerformanceManager;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class NativeBridge {
    private static final Logger LOGGER = Logger.getLogger(NativeBridge.class.getName());
    private static final ConcurrentLinkedQueue<byte[]> ENTITY_BATCH_BUFFER;
    private static final AtomicInteger ENTITY_BATCH_SIZE;
    private static final AtomicInteger FLUSH_IN_PROGRESS;
    private static final AtomicLong TOTAL_BATCHES_PROCESSED;
    private static final AtomicLong TOTAL_TASKS_PROCESSED;
    private static final AtomicLong TOTAL_MEMORY_SAVED;
    private static final AtomicInteger CURRENT_WORKER_COUNT;
    private static final ConcurrentLinkedQueue<ByteBuffer> BUFFER_POOL;
    private static final AtomicInteger POOLED_BUFFER_COUNT;
    private static final ConcurrentHashMap<Long, ByteBuffer> ZERO_COPY_BUFFERS;
    private static final AtomicLong NEXT_ZERO_COPY_ID;
    private static final ConcurrentHashMap<Long, ConnectionPool> CONNECTION_POOLS;
    private static final AtomicLong NEXT_POOL_ID;
    private static final int DEFAULT_POOL_SIZE = 8;
    private static final int MAX_POOL_SIZE = 32;
    private static volatile boolean unifiedMemoryArenaInitialized;
    private static final ReentrantLock ARENA_INIT_LOCK;
    private static final AtomicLong NEXT_HANDLE;
    private static final ConcurrentHashMap<Long, Worker> WORKERS;

    private static int maxBatchSize() {
        return Math.max(50, PerformanceConstants.getAdaptiveBatchSize(PerformanceManager.getAverageTPS(), PerformanceManager.getLastTickDurationMs()) * 2);
    }

    private static int minBatchSize() {
        return Math.max(5, PerformanceConstants.getAdaptiveBatchSize(PerformanceManager.getAverageTPS(), PerformanceManager.getLastTickDurationMs()) / 4);
    }

    private static int bufferPoolSize() {
        return Math.max(8, PerformanceConstants.getAdaptiveQueueCapacity(PerformanceManager.getAverageTPS()) / 20);
    }

    private static int maxBufferSize() {
        return PerformanceConstants.getAdaptiveMaxBufferSize(PerformanceManager.getAverageTPS());
    }

    public static void initRustAllocator() {
        LOGGER.info("Initializing Rust allocator with unified memory arena support");
        unifiedMemoryArenaInitialized = true;
    }

    public static void initRustAllocatorFallback() {
        LOGGER.info("Using fallback allocator initialization");
    }

    private NativeBridge() {
    }

    public static long nativeCreateWorker(int concurrency) {
        long h = NEXT_HANDLE.getAndIncrement();
        Worker w = new Worker(concurrency);
        WORKERS.put(h, w);
        return h;
    }

    public static void nativePushTask(long workerHandle, byte[] payload) {
        Worker w = WORKERS.get(workerHandle);
        if (w == null) {
            throw new IllegalArgumentException("invalid worker handle");
        }
        if (payload == null) {
            return;
        }
        w.tasks.offer(payload);
    }

    public static void nativePushTaskBuffer(long workerHandle, ByteBuffer payload) {
        if (payload == null) {
            return;
        }
        byte[] b = new byte[payload.remaining()];
        payload.get(b);
        NativeBridge.nativePushTask(workerHandle, b);
    }

    public static byte[] nativePollResult(long workerHandle) {
        Worker w = WORKERS.get(workerHandle);
        if (w == null) {
            throw new IllegalArgumentException("invalid worker handle");
        }
        return (byte[])w.results.poll();
    }

    public static ByteBuffer nativePollResultBuffer(long workerHandle) {
        byte[] r = NativeBridge.nativePollResult(workerHandle);
        if (r == null) {
            return null;
        }
        return ByteBuffer.wrap(r);
    }

    public static void nativeDestroyWorker(long workerHandle) {
        Worker w = WORKERS.remove(workerHandle);
        if (w != null) {
            w.stop();
        }
    }

    public static void nativePushBatch(long workerHandle, byte[][] payloads, int batchSize) {
        if (payloads == null) {
            return;
        }
        int limit = Math.min(batchSize, payloads.length);
        for (int i = 0; i < limit; ++i) {
            NativeBridge.nativePushTask(workerHandle, payloads[i]);
        }
    }

    public static void nativePushBatchBuffer(long workerHandle, ByteBuffer[] payloads, int batchSize) {
        if (payloads == null) {
            return;
        }
        int limit = Math.min(batchSize, payloads.length);
        for (int i = 0; i < limit; ++i) {
            NativeBridge.nativePushTaskBuffer(workerHandle, payloads[i]);
        }
    }

    public static byte[][] nativePollBatchResults(long workerHandle, int maxResults) {
        byte[] r;
        Worker w = WORKERS.get(workerHandle);
        if (w == null) {
            throw new IllegalArgumentException("invalid worker handle");
        }
        ArrayList<byte[]> out = new ArrayList<byte[]>();
        for (int i = 0; i < maxResults && (r = (byte[])w.results.poll()) != null; ++i) {
            out.add(r);
        }
        return (byte[][])out.toArray((T[])new byte[out.size()][]);
    }

    public static ByteBuffer[] nativePollBatchResultsBuffer(long workerHandle, int maxResults) {
        byte[][] arr = NativeBridge.nativePollBatchResults(workerHandle, maxResults);
        if (arr == null) {
            return null;
        }
        ByteBuffer[] out = new ByteBuffer[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            out[i] = ByteBuffer.wrap(arr[i]);
        }
        return out;
    }

    public static ByteBuffer nativeAllocateBuffer(int size) {
        try {
            return ByteBuffer.allocateDirect(size);
        }
        catch (Throwable t) {
            return ByteBuffer.allocate(size);
        }
    }

    public static void nativeFreeBuffer(ByteBuffer buffer) {
    }

    public static long nativeGetBufferAddress(ByteBuffer buffer) {
        return 0L;
    }

    public static long nativeGetWorkerQueueDepth(long workerHandle) {
        Worker w = WORKERS.get(workerHandle);
        if (w == null) {
            return 0L;
        }
        return w.tasks.size();
    }

    public static double nativeGetWorkerAvgProcessingMs(long workerHandle) {
        Worker w = WORKERS.get(workerHandle);
        if (w == null) {
            return 0.0;
        }
        long processed = w.tasksProcessed.get();
        if (processed == 0L) {
            return 0.0;
        }
        double avgNs = (double)w.totalProcessingNs.get() / (double)processed;
        return avgNs / 1000000.0;
    }

    public static long nativeGetWorkerMemoryUsage(long workerHandle) {
        return 0L;
    }

    public static long createOptimizedWorker(int concurrency) {
        long workerHandle = NativeBridge.nativeCreateWorker(concurrency);
        if (workerHandle != 0L) {
            CURRENT_WORKER_COUNT.incrementAndGet();
        }
        return workerHandle;
    }

    public static void destroyOptimizedWorker(long workerHandle) {
        if (workerHandle != 0L) {
            NativeBridge.nativeDestroyWorker(workerHandle);
            CURRENT_WORKER_COUNT.decrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pushTaskOptimized(long workerHandle, byte[] payload) {
        if (payload == null || payload.length == 0) {
            return;
        }
        double tps = PerformanceManager.getAverageTPS();
        int bufferThreshold = PerformanceConstants.getAdaptiveBufferUseThreshold(tps);
        if (payload.length > bufferThreshold) {
            ByteBuffer buffer = NativeBridge.getPooledBuffer(payload.length);
            try {
                buffer.clear();
                buffer.put(payload);
                buffer.flip();
                NativeBridge.nativePushTaskBuffer(workerHandle, buffer);
            }
            finally {
                NativeBridge.returnPooledBuffer(buffer);
            }
        } else {
            NativeBridge.nativePushTask(workerHandle, payload);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pushBatchOptimized(long workerHandle, byte[][] payloads) {
        if (payloads == null || payloads.length == 0) {
            return;
        }
        int batchSize = Math.min(payloads.length, NativeBridge.maxBatchSize());
        TOTAL_BATCHES_PROCESSED.incrementAndGet();
        TOTAL_TASKS_PROCESSED.addAndGet(batchSize);
        boolean useBuffers = false;
        int totalSize = 0;
        for (int i = 0; i < batchSize; ++i) {
            if (payloads[i] == null || payloads[i].length <= 4096) continue;
            useBuffers = true;
            totalSize += payloads[i].length;
        }
        if (useBuffers && totalSize > 16384) {
            ByteBuffer[] buffers = new ByteBuffer[batchSize];
            try {
                for (int i = 0; i < batchSize; ++i) {
                    if (payloads[i] == null) continue;
                    buffers[i] = NativeBridge.getPooledBuffer(payloads[i].length);
                    buffers[i].clear();
                    buffers[i].put(payloads[i]);
                    buffers[i].flip();
                }
                NativeBridge.nativePushBatchBuffer(workerHandle, buffers, batchSize);
            }
            finally {
                for (ByteBuffer buffer : buffers) {
                    if (buffer == null) continue;
                    NativeBridge.returnPooledBuffer(buffer);
                }
            }
        } else {
            NativeBridge.nativePushBatch(workerHandle, payloads, batchSize);
        }
    }

    public static byte[] pollResultOptimized(long workerHandle) {
        ByteBuffer bufferResult = NativeBridge.nativePollResultBuffer(workerHandle);
        if (bufferResult != null) {
            byte[] result = new byte[bufferResult.remaining()];
            bufferResult.get(result);
            NativeBridge.returnPooledBuffer(bufferResult);
            return result;
        }
        return NativeBridge.nativePollResult(workerHandle);
    }

    private static ByteBuffer getPooledBuffer(int size) {
        if (size > NativeBridge.maxBufferSize()) {
            return NativeBridge.nativeAllocateBuffer(size);
        }
        ByteBuffer buffer = BUFFER_POOL.poll();
        if (buffer != null && buffer.capacity() >= size) {
            POOLED_BUFFER_COUNT.decrementAndGet();
            TOTAL_MEMORY_SAVED.addAndGet(size);
            return buffer;
        }
        return NativeBridge.nativeAllocateBuffer(size);
    }

    private static void returnPooledBuffer(ByteBuffer buffer) {
        if (buffer == null || buffer.capacity() > NativeBridge.maxBufferSize()) {
            if (buffer != null) {
                NativeBridge.nativeFreeBuffer(buffer);
            }
            return;
        }
        if (POOLED_BUFFER_COUNT.get() < NativeBridge.bufferPoolSize()) {
            buffer.clear();
            BUFFER_POOL.offer(buffer);
            POOLED_BUFFER_COUNT.incrementAndGet();
        } else {
            NativeBridge.nativeFreeBuffer(buffer);
        }
    }

    public static long submitZeroCopyOperation(long workerHandle, ByteBuffer buffer, int operationType) {
        if (buffer == null || !buffer.isDirect()) {
            throw new IllegalArgumentException("Zero-copy operations require direct ByteBuffer");
        }
        if (operationType <= 0) {
            throw new IllegalArgumentException("Invalid operation type: " + operationType);
        }
        long operationId = NEXT_ZERO_COPY_ID.getAndIncrement();
        ZERO_COPY_BUFFERS.put(operationId, buffer);
        long bufferAddress = NativeBridge.getBufferAddress(buffer);
        int bufferSize = buffer.remaining();
        try {
            RustPerformance.submitZeroCopyOperation(workerHandle, bufferAddress, bufferSize, operationType);
            return operationId;
        }
        catch (Throwable t) {
            ZERO_COPY_BUFFERS.remove(operationId);
            throw t;
        }
    }

    public static long submitZeroCopyOperation(long workerHandle, NativeFloatBuffer buffer, int operationType) {
        if (buffer == null || buffer.buffer() == null || !buffer.buffer().isDirect()) {
            throw new IllegalArgumentException("Zero-copy operations require direct ByteBuffer");
        }
        if (operationType <= 0) {
            throw new IllegalArgumentException("Invalid operation type: " + operationType);
        }
        long operationId = NEXT_ZERO_COPY_ID.getAndIncrement();
        ZERO_COPY_BUFFERS.put(operationId, buffer.buffer());
        long bufferAddress = NativeBridge.getBufferAddress(buffer.buffer());
        int bufferSize = buffer.buffer().remaining();
        try {
            RustPerformance.submitZeroCopyOperation(workerHandle, bufferAddress, bufferSize, operationType);
            return operationId;
        }
        catch (Throwable t) {
            ZERO_COPY_BUFFERS.remove(operationId);
            throw t;
        }
    }

    public static ByteBuffer pollZeroCopyResult(long operationId) {
        return RustPerformance.pollZeroCopyResult(operationId);
    }

    public static NativeFloatBuffer pollZeroCopyResultAsFloatBuffer(long operationId) {
        ByteBuffer resultBuffer = NativeBridge.pollZeroCopyResult(operationId);
        if (resultBuffer == null) {
            return null;
        }
        try {
            return NativeFloatBuffer.allocateFromNative(resultBuffer.limit() / 4, resultBuffer.limit() / 4, true);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void cleanupZeroCopyOperation(long operationId) {
        ZERO_COPY_BUFFERS.remove(operationId);
        RustPerformance.cleanupZeroCopyOperation(operationId);
    }

    private static native long getBufferAddress(ByteBuffer var0);

    public static Map<String, Object> getBatchStats() {
        HashMap<String, Object> Stats = new HashMap<String, Object>();
        Stats.put("TOTAL_BATCHES_PROCESSED", TOTAL_BATCHES_PROCESSED.get());
        Stats.put("totalTasksProcessed", TOTAL_TASKS_PROCESSED.get());
        Stats.put("totalMemorySaved", TOTAL_MEMORY_SAVED.get());
        Stats.put("currentWorkerCount", CURRENT_WORKER_COUNT.get());
        Stats.put("pooledBufferCount", POOLED_BUFFER_COUNT.get());
        if (TOTAL_BATCHES_PROCESSED.get() > 0L) {
            double avgBatchSize = (double)TOTAL_TASKS_PROCESSED.get() / (double)TOTAL_BATCHES_PROCESSED.get();
            Stats.put("AVERAGE_BATCH_SIZE", String.format("%.2f", avgBatchSize));
        }
        return Stats;
    }

    public static void cleanupBufferPool() {
        ByteBuffer buffer;
        while ((buffer = BUFFER_POOL.poll()) != null) {
            NativeBridge.nativeFreeBuffer(buffer);
            POOLED_BUFFER_COUNT.decrementAndGet();
        }
    }

    public static int getOptimalBatchSize(int requestedSize) {
        if (requestedSize <= NativeBridge.minBatchSize()) {
            return NativeBridge.minBatchSize();
        }
        if (requestedSize >= NativeBridge.maxBatchSize()) {
            return NativeBridge.maxBatchSize();
        }
        int batchSize = Math.round((float)requestedSize / 25.0f) * 25;
        return Math.max(NativeBridge.minBatchSize(), Math.min(NativeBridge.maxBatchSize(), batchSize));
    }

    public static native String nativeGetMemoryPressureConfig();

    public static native int nativeUpdateMemoryPressureConfig(String var0);

    public static native boolean nativeValidateMemoryPressureConfig(String var0);

    public static native int nativeGetMemoryPressureLevel(double var0);

    public static void bufferEntityOperation(byte[] payload) {
        if (payload == null || payload.length == 0) {
            return;
        }
        ENTITY_BATCH_BUFFER.offer(payload);
        int currentSize = ENTITY_BATCH_SIZE.incrementAndGet();
        if (currentSize >= NativeBridge.maxBatchSize()) {
            NativeBridge.flushEntityBatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void flushEntityBatch() {
        if (FLUSH_IN_PROGRESS.getAndSet(1) != 0) {
            return;
        }
        try {
            byte[] payload;
            int batchSize = ENTITY_BATCH_SIZE.get();
            if (batchSize == 0) {
                return;
            }
            int actualCollected = 0;
            byte[][] batchPayloads = new byte[batchSize][];
            while ((payload = ENTITY_BATCH_BUFFER.poll()) != null && actualCollected < batchSize) {
                batchPayloads[actualCollected++] = payload;
            }
            if (actualCollected > 0) {
                ENTITY_BATCH_SIZE.addAndGet(-actualCollected);
                if (actualCollected > 0) {
                    long workerHandle = 0L;
                    workerHandle = WORKERS.isEmpty() ? NativeBridge.createOptimizedWorker(4) : (Long)((ConcurrentHashMap.KeySetView)WORKERS.keySet()).iterator().next();
                    if (workerHandle != 0L) {
                        NativeBridge.pushBatchOptimized(workerHandle, batchPayloads);
                        TOTAL_BATCHES_PROCESSED.incrementAndGet();
                        TOTAL_TASKS_PROCESSED.addAndGet(actualCollected);
                    }
                }
            }
        }
        finally {
            FLUSH_IN_PROGRESS.set(0);
        }
    }

    public static int getEntityBatchBufferSize() {
        return ENTITY_BATCH_SIZE.get();
    }

    public static void forceFlushEntityBatch() {
        NativeBridge.flushEntityBatch();
    }

    static {
        try {
            System.loadLibrary("rustperf");
            LOGGER.info("Native library rustperf loaded successfully");
        }
        catch (UnsatisfiedLinkError e) {
            LOGGER.warning("Native library rustperf not available, using fallback mode: " + e.getMessage());
        }
        ENTITY_BATCH_BUFFER = new ConcurrentLinkedQueue();
        ENTITY_BATCH_SIZE = new AtomicInteger(0);
        FLUSH_IN_PROGRESS = new AtomicInteger(0);
        TOTAL_BATCHES_PROCESSED = new AtomicLong(0L);
        TOTAL_TASKS_PROCESSED = new AtomicLong(0L);
        TOTAL_MEMORY_SAVED = new AtomicLong(0L);
        CURRENT_WORKER_COUNT = new AtomicInteger(0);
        BUFFER_POOL = new ConcurrentLinkedQueue();
        POOLED_BUFFER_COUNT = new AtomicInteger(0);
        ZERO_COPY_BUFFERS = new ConcurrentHashMap();
        NEXT_ZERO_COPY_ID = new AtomicLong(1L);
        CONNECTION_POOLS = new ConcurrentHashMap();
        NEXT_POOL_ID = new AtomicLong(1L);
        unifiedMemoryArenaInitialized = false;
        ARENA_INIT_LOCK = new ReentrantLock();
        NEXT_HANDLE = new AtomicLong(1L);
        WORKERS = new ConcurrentHashMap();
    }

    private static final class Worker {
        final BlockingQueue<byte[]> tasks = new LinkedBlockingQueue<byte[]>();
        final BlockingQueue<byte[]> results = new LinkedBlockingQueue<byte[]>();
        final AtomicLong totalProcessingNs = new AtomicLong(0L);
        final AtomicLong tasksProcessed = new AtomicLong(0L);
        final AtomicLong consecutiveErrors = new AtomicLong(0L);
        final AtomicLong lastHealthCheckTime = new AtomicLong(System.currentTimeMillis());
        final Thread thread;
        volatile boolean running = true;
        volatile boolean healthy = true;
        volatile long lastSuccessfulProcessTime = System.currentTimeMillis();

        Worker(int concurrency) {
            this.thread = new Thread(this::runLoop, "native-worker-fallback-" + NEXT_HANDLE.get());
            this.thread.setDaemon(true);
            this.thread.start();
        }

        void runLoop() {
            long MAX_CONSECUTIVE_ERRORS = 10L;
            long HEALTH_CHECK_INTERVAL_MS = 5000L;
            while (this.running && this.healthy) {
                if (this.consecutiveErrors.get() >= 10L) {
                    LOGGER.warning("Circuit breaker triggered for worker " + this.thread.getName() + " with " + this.consecutiveErrors.get() + " consecutive errors");
                    this.healthy = false;
                    break;
                }
                long currentTime = System.currentTimeMillis();
                if (currentTime - this.lastSuccessfulProcessTime > 5000L && this.tasksProcessed.get() > 0L) {
                    LOGGER.warning("Worker " + this.thread.getName() + " health check failed - no successful processing in " + (currentTime - this.lastSuccessfulProcessTime) + "ms");
                    this.consecutiveErrors.incrementAndGet();
                }
                try {
                    long start;
                    byte[] t;
                    block32: {
                        t = this.tasks.poll(100L, TimeUnit.MILLISECONDS);
                        if (t == null) continue;
                        start = System.nanoTime();
                        try {
                            Thread.sleep(ThreadLocalRandom.current().nextInt(1, 3));
                        }
                        catch (InterruptedException ie) {
                            Thread.currentThread().interrupt();
                            if (this.running) break block32;
                            LOGGER.info("Worker " + this.thread.getName() + " interrupted for shutdown");
                            break;
                        }
                    }
                    try {
                        ByteBuffer in = ByteBuffer.wrap(t).order(ByteOrder.LITTLE_ENDIAN);
                        long taskId = 0L;
                        byte taskType = 0;
                        byte[] payload = new byte[]{};
                        if (t.length < 13) {
                            taskId = 0L;
                            taskType = 0;
                            payload = new byte[]{};
                            String msg = "Malformed envelope: too short";
                            byte[] msgBytes = msg.getBytes(StandardCharsets.UTF_8);
                            ByteBuffer outErr = ByteBuffer.allocate(13 + msgBytes.length).order(ByteOrder.LITTLE_ENDIAN);
                            outErr.putLong(0L);
                            outErr.put((byte)1);
                            outErr.putInt(msgBytes.length);
                            outErr.put(msgBytes);
                            this.results.offer(outErr.array());
                            LOGGER.warning("Malformed task envelope received: too short");
                            this.consecutiveErrors.incrementAndGet();
                        } else {
                            taskId = in.getLong();
                            taskType = in.get();
                            int len = in.getInt();
                            if (len < 0 || in.remaining() < len) {
                                msg = "Task envelope payload length mismatch";
                                byte[] msgBytes = ((String)msg).getBytes(StandardCharsets.UTF_8);
                                outErr = ByteBuffer.allocate(13 + msgBytes.length).order(ByteOrder.LITTLE_ENDIAN);
                                outErr.putLong(0L);
                                outErr.put((byte)1);
                                outErr.putInt(msgBytes.length);
                                outErr.put(msgBytes);
                                this.results.offer(outErr.array());
                                LOGGER.warning("Task envelope payload length mismatch: expected=" + len + ", remaining=" + in.remaining());
                                this.consecutiveErrors.incrementAndGet();
                            } else {
                                if (len > 0) {
                                    payload = new byte[len];
                                    in.get(payload);
                                }
                                if (taskType == 1) {
                                    ByteBuffer out = ByteBuffer.allocate(13 + payload.length).order(ByteOrder.LITTLE_ENDIAN);
                                    out.putLong(taskId);
                                    out.put((byte)0);
                                    out.putInt(payload.length);
                                    if (payload.length > 0) {
                                        out.put(payload);
                                    }
                                    this.results.offer(out.array());
                                    this.consecutiveErrors.set(0L);
                                    this.lastSuccessfulProcessTime = System.currentTimeMillis();
                                } else if (taskType == 2) {
                                    try {
                                        String s = new String(payload, StandardCharsets.UTF_8);
                                        long n = Long.parseLong(s.trim());
                                        long sum = 0L;
                                        for (long i = 1L; i <= n; ++i) {
                                            sum += i * i;
                                        }
                                        String json = String.format("{\"task\":\"heavy\",\"n\":%d,\"sum\":%d}", n, sum);
                                        byte[] jb = json.getBytes(StandardCharsets.UTF_8);
                                        ByteBuffer out = ByteBuffer.allocate(13 + jb.length).order(ByteOrder.LITTLE_ENDIAN);
                                        out.putLong(taskId);
                                        out.put((byte)0);
                                        out.putInt(jb.length);
                                        out.put(jb);
                                        this.results.offer(out.array());
                                        this.consecutiveErrors.set(0L);
                                        this.lastSuccessfulProcessTime = System.currentTimeMillis();
                                    }
                                    catch (NumberFormatException nfe) {
                                        String msg = "Invalid number in payload";
                                        byte[] msgBytes = msg.getBytes(StandardCharsets.UTF_8);
                                        ByteBuffer outErr = ByteBuffer.allocate(13 + msgBytes.length).order(ByteOrder.LITTLE_ENDIAN);
                                        outErr.putLong(taskId);
                                        outErr.put((byte)1);
                                        outErr.putInt(msgBytes.length);
                                        outErr.put(msgBytes);
                                        this.results.offer(outErr.array());
                                        LOGGER.warning("Invalid number in payload: " + nfe.getMessage());
                                        this.consecutiveErrors.incrementAndGet();
                                    }
                                } else if ((taskType & 0xFF) == 255) {
                                    msg = "panic: Intentional panic for testing";
                                    byte[] msgBytes = ((String)msg).getBytes(StandardCharsets.UTF_8);
                                    outErr = ByteBuffer.allocate(13 + msgBytes.length).order(ByteOrder.LITTLE_ENDIAN);
                                    outErr.putLong(taskId);
                                    outErr.put((byte)1);
                                    outErr.putInt(msgBytes.length);
                                    outErr.put(msgBytes);
                                    this.results.offer(outErr.array());
                                    LOGGER.info("Intentional panic test handled for task: " + taskId);
                                    this.consecutiveErrors.incrementAndGet();
                                } else {
                                    msg = "Unknown task type: " + taskType;
                                    byte[] msgBytes = ((String)msg).getBytes(StandardCharsets.UTF_8);
                                    outErr = ByteBuffer.allocate(13 + msgBytes.length).order(ByteOrder.LITTLE_ENDIAN);
                                    outErr.putLong(taskId);
                                    outErr.put((byte)1);
                                    outErr.putInt(msgBytes.length);
                                    outErr.put(msgBytes);
                                    this.results.offer(outErr.array());
                                    LOGGER.warning("Unknown task type: " + taskType);
                                    this.consecutiveErrors.incrementAndGet();
                                }
                            }
                        }
                    }
                    catch (Exception ex) {
                        try {
                            String base = ex.getMessage();
                            Object msg = base == null ? "internal error" : "internal error: " + base;
                            byte[] msgBytes = ((String)msg).getBytes(StandardCharsets.UTF_8);
                            ByteBuffer out = ByteBuffer.allocate(13 + msgBytes.length).order(ByteOrder.LITTLE_ENDIAN);
                            out.putLong(0L);
                            out.put((byte)1);
                            out.putInt(msgBytes.length);
                            out.put(msgBytes);
                            this.results.offer(out.array());
                            LOGGER.log(Level.SEVERE, "Internal error processing task: " + ex.getMessage(), ex);
                            this.consecutiveErrors.incrementAndGet();
                        }
                        catch (Throwable secondaryEx) {
                            LOGGER.log(Level.SEVERE, "Secondary error during error handling: " + secondaryEx.getMessage(), secondaryEx);
                            this.consecutiveErrors.incrementAndGet();
                        }
                    }
                    long dur = System.nanoTime() - start;
                    this.totalProcessingNs.addAndGet(dur);
                    this.tasksProcessed.incrementAndGet();
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    if (this.running) continue;
                    LOGGER.info("Worker " + this.thread.getName() + " interrupted for shutdown");
                    break;
                }
                catch (Throwable ex) {
                    LOGGER.log(Level.SEVERE, "Critical error in worker loop: " + ex.getMessage(), ex);
                    this.consecutiveErrors.incrementAndGet();
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                        if (this.running) continue;
                        break;
                    }
                }
            }
            if (!this.running) {
                LOGGER.info("Worker " + this.thread.getName() + " performing graceful shutdown");
                this.processRemainingTasks();
            } else if (!this.healthy) {
                LOGGER.warning("Worker " + this.thread.getName() + " marked unhealthy, attempting recovery");
                this.attemptRecovery();
            }
        }

        void stop() {
            this.running = false;
            this.thread.interrupt();
        }

        void processRemainingTasks() {
            byte[] task;
            LOGGER.info("Processing remaining tasks in queue: " + this.tasks.size());
            while ((task = (byte[])this.tasks.poll()) != null) {
                try {
                    ByteBuffer in = ByteBuffer.wrap(task).order(ByteOrder.LITTLE_ENDIAN);
                    if (task.length < 13) continue;
                    long taskId = in.getLong();
                    int len = in.getInt();
                    if (len <= 0 || in.remaining() < len) continue;
                    byte[] payload = new byte[len];
                    in.get(payload);
                    String msg = "Task cancelled due to shutdown";
                    byte[] msgBytes = msg.getBytes(StandardCharsets.UTF_8);
                    ByteBuffer outErr = ByteBuffer.allocate(13 + msgBytes.length).order(ByteOrder.LITTLE_ENDIAN);
                    outErr.putLong(taskId);
                    outErr.put((byte)1);
                    outErr.putInt(msgBytes.length);
                    outErr.put(msgBytes);
                    this.results.offer(outErr.array());
                }
                catch (Exception e) {
                    LOGGER.warning("Failed to process remaining task during shutdown: " + e.getMessage());
                }
            }
        }

        void attemptRecovery() {
            LOGGER.info("Attempting recovery for worker " + this.thread.getName());
            this.consecutiveErrors.set(0L);
            this.healthy = true;
            this.lastSuccessfulProcessTime = System.currentTimeMillis();
            this.results.clear();
            LOGGER.info("Worker " + this.thread.getName() + " recovery completed");
        }
    }

    public static class ConnectionPoolStats {
        public final long poolId;
        public final int availableConnections;
        public final int activeConnections;
        public final int totalConnections;
        public final boolean closed;

        ConnectionPoolStats(long poolId, int available, int active, int total, boolean closed) {
            this.poolId = poolId;
            this.availableConnections = available;
            this.activeConnections = active;
            this.totalConnections = total;
            this.closed = closed;
        }

        public String toString() {
            return String.format("Pool %d: available=%d, active=%d, total=%d, closed=%b", this.poolId, this.availableConnections, this.activeConnections, this.totalConnections, this.closed);
        }
    }

    private static class ConnectionPool {
        private final long poolId = NEXT_POOL_ID.getAndIncrement();
        private final int poolSize;
        private final ConcurrentLinkedQueue<Long> availableWorkers;
        private final AtomicInteger activeConnections;
        private final AtomicInteger totalConnections;
        private volatile boolean closed = false;

        ConnectionPool(int size) {
            this.poolSize = Math.min(size, 32);
            this.availableWorkers = new ConcurrentLinkedQueue();
            this.activeConnections = new AtomicInteger(0);
            this.totalConnections = new AtomicInteger(0);
            this.initializePool();
        }

        private void initializePool() {
            for (int i = 0; i < this.poolSize; ++i) {
                long workerHandle = NativeBridge.nativeCreateWorker(4);
                if (workerHandle == 0L) continue;
                this.availableWorkers.offer(workerHandle);
                this.totalConnections.incrementAndGet();
                CURRENT_WORKER_COUNT.incrementAndGet();
            }
            LOGGER.info("Connection pool initialized with " + this.totalConnections.get() + " workers");
        }

        public long acquireConnection() {
            long newWorker;
            if (this.closed) {
                throw new IllegalStateException("Connection pool is closed");
            }
            Long workerHandle = this.availableWorkers.poll();
            if (workerHandle != null) {
                this.activeConnections.incrementAndGet();
                return workerHandle;
            }
            if (this.totalConnections.get() < 32 && (newWorker = NativeBridge.nativeCreateWorker(4)) != 0L) {
                this.activeConnections.incrementAndGet();
                this.totalConnections.incrementAndGet();
                CURRENT_WORKER_COUNT.incrementAndGet();
                return newWorker;
            }
            try {
                Thread.sleep(10L);
                workerHandle = this.availableWorkers.poll();
                if (workerHandle != null) {
                    this.activeConnections.incrementAndGet();
                    return workerHandle;
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            throw new RuntimeException("No available connections in pool");
        }

        public void releaseConnection(long workerHandle) {
            if (this.closed || workerHandle == 0L) {
                if (workerHandle != 0L) {
                    NativeBridge.nativeDestroyWorker(workerHandle);
                    CURRENT_WORKER_COUNT.decrementAndGet();
                }
                return;
            }
            this.activeConnections.decrementAndGet();
            this.availableWorkers.offer(workerHandle);
        }

        public void close() {
            Long workerHandle;
            this.closed = true;
            while ((workerHandle = this.availableWorkers.poll()) != null) {
                NativeBridge.nativeDestroyWorker(workerHandle);
                CURRENT_WORKER_COUNT.decrementAndGet();
            }
            LOGGER.info("Connection pool " + this.poolId + " closed");
        }

        public ConnectionPoolStats getStats() {
            return new ConnectionPoolStats(this.poolId, this.availableWorkers.size(), this.activeConnections.get(), this.totalConnections.get(), this.closed);
        }
    }
}

