/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.performance.core;

import com.kneaf.core.KneafCore;
import com.kneaf.core.data.block.BlockEntityData;
import com.kneaf.core.data.entity.EntityData;
import com.kneaf.core.data.entity.MobData;
import com.kneaf.core.data.entity.PlayerData;
import com.kneaf.core.data.entity.VillagerData;
import com.kneaf.core.data.item.ItemEntityData;
import com.kneaf.core.performance.bridge.NativeIntegrationManager;
import com.kneaf.core.performance.core.BatchProcessor;
import com.kneaf.core.performance.core.EntityProcessor;
import com.kneaf.core.performance.core.ItemProcessResult;
import com.kneaf.core.performance.core.MobProcessResult;
import com.kneaf.core.performance.core.PerformanceMonitor;
import com.kneaf.core.performance.core.PerformanceOptimizer;
import com.kneaf.core.performance.core.PerformanceProcessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;

public class RustPerformanceFacade {
    private static RustPerformanceFacade instance;
    private final EntityProcessor entityProcessor;
    private final BatchProcessor batchProcessor;
    private final NativeIntegrationManager NATIVE_MANAGER;
    private final PerformanceOptimizer optimizer;
    private final PerformanceMonitor monitor;
    private final AtomicLong tickCount = new AtomicLong(0L);
    private volatile boolean initialized = false;

    private RustPerformanceFacade() {
        this.monitor = new PerformanceMonitor(this){
            private final AtomicLong totalEntities = new AtomicLong(0L);
            private final AtomicLong totalItems = new AtomicLong(0L);
            private final AtomicLong totalMobs = new AtomicLong(0L);
            private final AtomicLong totalBlocks = new AtomicLong(0L);
            private final AtomicLong totalItemsMerged = new AtomicLong(0L);
            private final AtomicLong totalItemsDespawned = new AtomicLong(0L);
            private volatile double currentTPS = 20.0;

            @Override
            public void recordEntityProcessing(int inputCount, long processingTime) {
                this.totalEntities.addAndGet(inputCount);
            }

            @Override
            public void recordItemProcessing(int inputCount, long mergedCount, long despawnedCount, long processingTime) {
                this.totalItems.addAndGet(inputCount);
                this.totalItemsMerged.addAndGet(mergedCount);
                this.totalItemsDespawned.addAndGet(despawnedCount);
            }

            @Override
            public void recordMobProcessing(int inputCount, int disableCount, int simplifyCount, long processingTime) {
                this.totalMobs.addAndGet(inputCount);
            }

            @Override
            public void recordVillagerProcessing(int inputCount, int disableCount, int simplifyCount, int reducePathfindCount, long processingTime) {
                this.totalMobs.addAndGet(inputCount);
            }

            @Override
            public void recordBlockProcessing(int processedCount, long processingTime) {
                this.totalBlocks.addAndGet(processedCount);
            }

            @Override
            public void recordNativeCall(String methodName, long processingTime, boolean success) {
            }

            @Override
            public void recordBatchProcessing(int batchSize, long processingTime) {
            }

            @Override
            public long getTotalEntitiesProcessed() {
                return this.totalEntities.get();
            }

            @Override
            public long getTotalItemsProcessed() {
                return this.totalItems.get();
            }

            @Override
            public long getTotalMobsProcessed() {
                return this.totalMobs.get();
            }

            @Override
            public long getTotalBlocksProcessed() {
                return this.totalBlocks.get();
            }

            @Override
            public long getTotalItemsMerged() {
                return this.totalItemsMerged.get();
            }

            @Override
            public long getTotalItemsDespawned() {
                return this.totalItemsDespawned.get();
            }

            @Override
            public double getCurrentTPS() {
                return this.currentTPS;
            }

            @Override
            public void setCurrentTPS(double tps) {
                this.currentTPS = tps;
            }

            @Override
            public Map<String, Object> getPerformanceStats() {
                HashMap<String, Object> Stats = new HashMap<String, Object>();
                Stats.put("totalEntities", this.totalEntities.get());
                Stats.put("totalItems", this.totalItems.get());
                Stats.put("totalMobs", this.totalMobs.get());
                Stats.put("totalBlocks", this.totalBlocks.get());
                Stats.put("currentTPS", this.currentTPS);
                return Stats;
            }

            @Override
            public void logPerformanceSummary() {
                KneafCore.LOGGER.info("Performance Summary - Entities: { }, Items: { }, Mobs: { }, Blocks: { }, TPS: { }", new Object[]{this.totalEntities.get(), this.totalItems.get(), this.totalMobs.get(), this.totalBlocks.get(), this.currentTPS});
            }

            @Override
            public void resetMetrics() {
                this.totalEntities.set(0L);
                this.totalItems.set(0L);
                this.totalMobs.set(0L);
                this.totalBlocks.set(0L);
                this.totalItemsMerged.set(0L);
                this.totalItemsDespawned.set(0L);
            }
        };
        this.NATIVE_MANAGER = new NativeIntegrationManager();
        this.entityProcessor = new EntityProcessor(this.NATIVE_MANAGER, this.monitor);
        this.batchProcessor = new BatchProcessor(this.entityProcessor, this.monitor, this.NATIVE_MANAGER);
        this.optimizer = new PerformanceOptimizer(this.monitor, this.NATIVE_MANAGER, this.entityProcessor, this.batchProcessor);
    }

    public static synchronized RustPerformanceFacade getInstance() {
        if (instance == null) {
            instance = new RustPerformanceFacade();
        }
        return instance;
    }

    public synchronized void initialize() {
        if (this.initialized) {
            return;
        }
        try {
            KneafCore.LOGGER.info("Initializing RustPerformance FACADE");
            boolean nativeAvailable = this.NATIVE_MANAGER.initialize();
            if (nativeAvailable) {
                KneafCore.LOGGER.info("Native integration initialized successfully");
            } else {
                KneafCore.LOGGER.warn("Native integration not available, using Java fallback");
            }
            this.initialized = true;
            KneafCore.LOGGER.info("RustPerformance FACADE initialization complete");
        }
        catch (Exception e) {
            KneafCore.LOGGER.error("Failed to initialize RustPerformance FACADE", (Throwable)e);
            throw new RuntimeException("Failed to initialize performance system", e);
        }
    }

    public synchronized void shutdown() {
        if (!this.initialized) {
            return;
        }
        KneafCore.LOGGER.info("Shutting down RustPerformance FACADE");
        try {
            this.NATIVE_MANAGER.shutdown();
            this.tickCount.set(0L);
            this.initialized = false;
            KneafCore.LOGGER.info("RustPerformance FACADE shutdown complete");
        }
        catch (Exception e) {
            KneafCore.LOGGER.error("Error during shutdown", (Throwable)e);
        }
    }

    public CompletableFuture<List<Long>> getEntitiesToTick(List<EntityData> entities, List<PlayerData> players) {
        this.ensureInitialized();
        try {
            return this.optimizer.optimizeEntities(entities, players).exceptionally(ex -> {
                KneafCore.LOGGER.error("Error getting entities to tick", ex);
                return entities.stream().map(entity -> entity.getId()).toList();
            });
        }
        catch (Exception e) {
            KneafCore.LOGGER.error("Error getting entities to tick", (Throwable)e);
            return CompletableFuture.completedFuture(entities.stream().map(entity -> entity.getId()).toList());
        }
    }

    public CompletableFuture<ItemProcessResult> processItemEntities(List<ItemEntityData> items) {
        this.ensureInitialized();
        try {
            if (items.size() >= 25 && this.NATIVE_MANAGER.isNativeAvailable()) {
                return this.batchProcessor.submitItemRequest("items", items);
            }
            ItemProcessResult result = this.entityProcessor.processItemEntities(items);
            return CompletableFuture.completedFuture(result);
        }
        catch (Exception e) {
            KneafCore.LOGGER.error("Error processing item entities", (Throwable)e);
            return CompletableFuture.completedFuture(new ItemProcessResult(new ArrayList<Long>(), 0L, 0L, new ArrayList<PerformanceProcessor.ItemUpdate>()));
        }
    }

    public CompletableFuture<MobProcessResult> processMobAI(List<MobData> mobs) {
        this.ensureInitialized();
        try {
            if (mobs.size() >= 25 && this.NATIVE_MANAGER.isNativeAvailable()) {
                return this.batchProcessor.submitMobRequest("mobs", mobs);
            }
            MobProcessResult result = this.entityProcessor.processMobAI(mobs);
            return CompletableFuture.completedFuture(result);
        }
        catch (Exception e) {
            KneafCore.LOGGER.error("Error processing mob AI", (Throwable)e);
            return CompletableFuture.completedFuture(new MobProcessResult(new ArrayList<Long>(), new ArrayList<Long>()));
        }
    }

    public CompletableFuture<List<Long>> processVillagerAI(List<VillagerData> villagers) {
        this.ensureInitialized();
        try {
            if (villagers.size() >= 25 && this.NATIVE_MANAGER.isNativeAvailable()) {
                return this.batchProcessor.submitLongListRequest("villagers", villagers);
            }
            List<Long> result = this.entityProcessor.processVillagerAI(villagers);
            return CompletableFuture.completedFuture(result);
        }
        catch (Exception e) {
            KneafCore.LOGGER.error("Error processing villager AI", (Throwable)e);
            return CompletableFuture.completedFuture(new ArrayList());
        }
    }

    public CompletableFuture<List<Long>> getBlockEntitiesToTick(List<BlockEntityData> blockEntities) {
        this.ensureInitialized();
        try {
            if (blockEntities.size() >= 25 && this.NATIVE_MANAGER.isNativeAvailable()) {
                return this.batchProcessor.submitLongListRequest("blocks", blockEntities);
            }
            List<Long> result = this.entityProcessor.getBlockEntitiesToTick(blockEntities);
            return CompletableFuture.completedFuture(result);
        }
        catch (Exception e) {
            KneafCore.LOGGER.error("Error getting block entities to tick", (Throwable)e);
            return CompletableFuture.completedFuture(blockEntities.stream().map(block -> block.getId()).toList());
        }
    }

    public List<Long> optimizeVillagers(List<VillagerData> villagers, int centerX, int centerZ, int radius) {
        this.ensureInitialized();
        try {
            return this.optimizer.optimizeVillagers(villagers, centerX, centerZ, radius);
        }
        catch (Exception e) {
            KneafCore.LOGGER.error("Error optimizing villagers", (Throwable)e);
            return villagers.stream().map(v -> v.hashCode()).toList();
        }
    }

    public void optimizeMemory() {
        this.ensureInitialized();
        try {
            this.optimizer.optimizeMemory();
        }
        catch (Exception e) {
            KneafCore.LOGGER.error("Error during memory optimization", (Throwable)e);
        }
    }

    public PerformanceStatistics getPerformanceStatistics() {
        this.ensureInitialized();
        return new PerformanceStatistics(this.monitor.getTotalEntitiesProcessed(), this.monitor.getTotalItemsProcessed(), this.monitor.getTotalMobsProcessed(), this.monitor.getTotalBlocksProcessed(), this.monitor.getCurrentTPS(), this.NATIVE_MANAGER.isNativeAvailable(), this.optimizer.getOptimizationStatistics());
    }

    public String getMemoryStats() {
        this.ensureInitialized();
        try {
            return this.NATIVE_MANAGER.getMemoryStats();
        }
        catch (Exception e) {
            KneafCore.LOGGER.error("Error getting memory Stats", (Throwable)e);
            return "{\"error\": \"Failed to get memory Stats\"}";
        }
    }

    public String getCpuStats() {
        this.ensureInitialized();
        try {
            return this.NATIVE_MANAGER.getCpuStats();
        }
        catch (Exception e) {
            KneafCore.LOGGER.error("Error getting CPU Stats", (Throwable)e);
            return "{\"error\": \"Failed to get CPU Stats\"}";
        }
    }

    public CompletableFuture<Integer> preGenerateNearbyChunksAsync(int centerX, int centerZ, int radius) {
        this.ensureInitialized();
        return this.NATIVE_MANAGER.preGenerateNearbyChunksAsync(centerX, centerZ, radius);
    }

    public boolean isChunkGenerated(int x, int z) {
        this.ensureInitialized();
        return this.NATIVE_MANAGER.isChunkGenerated(x, z);
    }

    public long getGeneratedChunkCount() {
        this.ensureInitialized();
        return this.NATIVE_MANAGER.getGeneratedChunkCount();
    }

    public double getCurrentTPS() {
        return this.monitor.getCurrentTPS();
    }

    public void setCurrentTPS(double tps) {
        this.monitor.setCurrentTPS(tps);
    }

    public int getNativeWorkerQueueDepth() {
        this.ensureInitialized();
        return this.NATIVE_MANAGER.getNativeWorkerQueueDepth();
    }

    public double getNativeWorkerAvgProcessingMs() {
        this.ensureInitialized();
        return this.NATIVE_MANAGER.getNativeWorkerAvgProcessingMs();
    }

    public boolean isNativeAvailable() {
        return this.NATIVE_MANAGER.isNativeAvailable();
    }

    private void ensureInitialized() {
        if (!this.initialized) {
            throw new IllegalStateException("RustPerformance FACADE not initialized. Call initialize() first.");
        }
    }

    public PerformanceOptimizer.OptimizationLevel getCurrentOptimizationLevel() {
        this.ensureInitialized();
        return this.optimizer.getOptimizationStatistics().getCurrentLevel();
    }

    public static class PerformanceStatistics {
        private final long totalEntitiesProcessed;
        private final long totalItemsProcessed;
        private final long totalMobsProcessed;
        private final long totalBlocksProcessed;
        private final double averageTickTime;
        private final boolean nativeAvailable;
        private final PerformanceOptimizer.OptimizationStatistics optimizationStats;

        public PerformanceStatistics(long totalEntitiesProcessed, long totalItemsProcessed, long totalMobsProcessed, long totalBlocksProcessed, double averageTickTime, boolean nativeAvailable, PerformanceOptimizer.OptimizationStatistics optimizationStats) {
            this.totalEntitiesProcessed = totalEntitiesProcessed;
            this.totalItemsProcessed = totalItemsProcessed;
            this.totalMobsProcessed = totalMobsProcessed;
            this.totalBlocksProcessed = totalBlocksProcessed;
            this.averageTickTime = averageTickTime;
            this.nativeAvailable = nativeAvailable;
            this.optimizationStats = optimizationStats;
        }

        public long getTotalEntitiesProcessed() {
            return this.totalEntitiesProcessed;
        }

        public long getTotalItemsProcessed() {
            return this.totalItemsProcessed;
        }

        public long getTotalMobsProcessed() {
            return this.totalMobsProcessed;
        }

        public long getTotalBlocksProcessed() {
            return this.totalBlocksProcessed;
        }

        public double getAverageTickTime() {
            return this.averageTickTime;
        }

        public boolean isNativeAvailable() {
            return this.nativeAvailable;
        }

        public PerformanceOptimizer.OptimizationStatistics getOptimizationStats() {
            return this.optimizationStats;
        }

        public String toString() {
            return String.format("PerformanceStatistics{entities=%d, items=%d, mobs=%d, blocks=%d, avgTickTime=%.2fms, native=%s}", this.totalEntitiesProcessed, this.totalItemsProcessed, this.totalMobsProcessed, this.totalBlocksProcessed, this.averageTickTime, this.nativeAvailable);
        }
    }
}

