/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.binary.block;

import com.kneaf.core.binary.block.BlockInput;
import com.kneaf.core.binary.core.BaseBinarySerializer;
import com.kneaf.core.binary.core.SerializationUtils;
import com.kneaf.core.binary.utils.BufferPool;
import com.kneaf.core.binary.utils.SchemaValidator;
import com.kneaf.core.binary.utils.SerializationException;
import com.kneaf.core.data.block.BlockEntityData;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class BlockSerializer
extends BaseBinarySerializer<BlockInput, List<Long>> {
    public BlockSerializer() {
        super("block", "1.0.0");
    }

    public BlockSerializer(BufferPool bufferPool) {
        super("block", "1.0.0", bufferPool);
    }

    public BlockSerializer(BufferPool bufferPool, SchemaValidator<BlockInput> validator) {
        super("block", "1.0.0", bufferPool, validator);
    }

    @Override
    protected void serializeToBufferInternal(BlockInput input, ByteBuffer buffer) throws SerializationException {
        if (input == null) {
            throw new SerializationException("Block input cannot be null", this.getSerializerType(), "serializeToBufferInternal");
        }
        try {
            buffer.putLong(input.tickCount);
            List<BlockEntityData> blockEntities = input.blockEntities;
            buffer.putInt(blockEntities.size());
            for (BlockEntityData blockEntity : blockEntities) {
                this.writeBlockEntityData(buffer, blockEntity);
            }
        }
        catch (Exception e) {
            throw new SerializationException("Failed to serialize block input", e, this.getSerializerType(), "serializeToBufferInternal", buffer.array());
        }
    }

    @Override
    protected List<Long> deserializeFromBufferInternal(ByteBuffer buffer) throws SerializationException {
        try {
            buffer.getLong();
            int blockEntityCount = buffer.getInt();
            if (blockEntityCount < 0) {
                throw new SerializationException("Invalid block entity count: " + blockEntityCount, this.getSerializerType(), "deserializeFromBufferInternal");
            }
            ArrayList<Long> blockEntitiesToTick = new ArrayList<Long>(blockEntityCount);
            for (int i = 0; i < blockEntityCount; ++i) {
                blockEntitiesToTick.add(buffer.getLong());
            }
            return blockEntitiesToTick;
        }
        catch (SerializationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SerializationException("Failed to deserialize block result", e, this.getSerializerType(), "deserializeFromBufferInternal", null);
        }
    }

    private void writeBlockEntityData(ByteBuffer buffer, BlockEntityData blockEntity) {
        buffer.putLong(blockEntity.getId());
        buffer.putFloat((float)blockEntity.getDistance());
        SerializationUtils.writeString(buffer, blockEntity.getBlockType());
        buffer.putInt((int)blockEntity.getX());
        buffer.putInt((int)blockEntity.getY());
        buffer.putInt((int)blockEntity.getZ());
    }
}

