/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.chunkstorage;

class SwapStats {
    private final int swapOuts;
    private final int swapIns;
    private final int swapOutFailures;
    private final int swapInFailures;
    private final double avgSwapOutTime;
    private final double avgSwapInTime;
    private final double failureRate;

    public SwapStats(int swapOuts, int swapIns, int swapOutFailures, int swapInFailures, double avgSwapOutTime, double avgSwapInTime, double failureRate) {
        this.swapOuts = swapOuts;
        this.swapIns = swapIns;
        this.swapOutFailures = swapOutFailures;
        this.swapInFailures = swapInFailures;
        this.avgSwapOutTime = avgSwapOutTime;
        this.avgSwapInTime = avgSwapInTime;
        this.failureRate = failureRate;
    }

    public int getSwapOuts() {
        return this.swapOuts;
    }

    public int getSwapIns() {
        return this.swapIns;
    }

    public int getSwapOutFailures() {
        return this.swapOutFailures;
    }

    public int getSwapInFailures() {
        return this.swapInFailures;
    }

    public double getAvgSwapOutTime() {
        return this.avgSwapOutTime;
    }

    public double getAvgSwapInTime() {
        return this.avgSwapInTime;
    }

    public double getFailureRate() {
        return this.failureRate;
    }

    public int getTotalSwaps() {
        return this.swapOuts + this.swapIns;
    }

    public int getTotalFailures() {
        return this.swapOutFailures + this.swapInFailures;
    }

    public String toString() {
        return String.format("SwapStats{swapOuts=%d, swapIns=%d, failures=%d/%d, failureRate=%.2f%%, avgSwapOutTime=%.2fms, avgSwapInTime=%.2fms}", this.swapOuts, this.swapIns, this.getTotalFailures(), this.getTotalSwaps(), this.failureRate * 100.0, this.avgSwapOutTime, this.avgSwapInTime);
    }
}

