/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.compatibility;

import com.mojang.logging.LogUtils;
import java.util.HashMap;
import java.util.Map;
import net.neoforged.fml.ModList;
import org.slf4j.Logger;

public class ModCompatibility {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String[] INCOMPATIBLE_MODS = new String[]{"lithium", "starlight"};
    private static final String[] COMPATIBLE_MODS = new String[]{"ferritecore"};
    private static final Map<String, String> CONFLICT_DESCRIPTIONS = Map.of("lithium", "Lithium optimizes entity ticking, which may conflict with KneafMod's parallel processing optimizations.", "starlight", "Starlight replaces the lighting engine, which may interfere with performance optimizations.");
    private static final Map<String, String> COMPAT_DESCRIPTIONS = Map.of("ferritecore", "FerriteCore provides memory/pooling optimizations and is compatible with KneafMod. When present, KneafMod will avoid duplicating pooling logic and prefers FerriteCore's implementations.");

    public static Map<String, String> checkForConflicts() {
        HashMap<String, String> conflicts = new HashMap<String, String>();
        for (String modId : INCOMPATIBLE_MODS) {
            if (!ModList.get().isLoaded(modId)) continue;
            String description = CONFLICT_DESCRIPTIONS.getOrDefault(modId, "Unknown conflict with " + modId);
            conflicts.put(modId, description);
            LOGGER.warn("Detected potentially conflicting mod: { } - { }", (Object)modId, (Object)description);
        }
        for (String modId : COMPATIBLE_MODS) {
            if (!ModList.get().isLoaded(modId)) continue;
            String info = COMPAT_DESCRIPTIONS.getOrDefault(modId, "Detected compatible mod: " + modId);
            LOGGER.info("Detected compatible mod: { } - { }", (Object)modId, (Object)info);
        }
        if (conflicts.isEmpty()) {
            LOGGER.info("No conflicting performance mods detected.");
        } else {
            LOGGER.warn("Found { } potentially conflicting performance mod(s). Consider reviewing configuration.", (Object)conflicts.size());
        }
        return conflicts;
    }

    public static boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }
}

