/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.performance.execution;

import com.kneaf.core.performance.core.PerformanceConstants;
import com.kneaf.core.performance.monitoring.PerformanceManager;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.StampedLock;
import java.util.function.Supplier;
import org.slf4j.Logger;

public final class UnifiedExecutorManager {
    private static final UnifiedExecutorManager INSTANCE = new UnifiedExecutorManager();
    private static final Logger LOGGER = LogUtils.getLogger();
    private final int baseCoreThreads;
    private final int baseMaxThreads;
    private final long keepAliveTimeSeconds;
    private final TimeUnit KEEP_ALIVE_UNIT = TimeUnit.SECONDS;
    private final int baseQueueCapacity;
    private static final double HIGH_LOAD_THRESHOLD = 0.8;
    private static final double LOW_LOAD_THRESHOLD = 0.3;
    private static final int THREAD_SCALING_FACTOR = 2;
    private final ThreadPoolExecutor primaryExecutor;
    private final ForkJoinPool forkJoinPool;
    private final ScheduledExecutorService scheduler;
    private final ExecutorService ioExecutor;
    private final AtomicLong submittedTasks = new AtomicLong(0L);
    private final AtomicLong completedTasks = new AtomicLong(0L);
    private final AtomicLong rejectedTasks = new AtomicLong(0L);
    private final AtomicLong queueWaits = new AtomicLong(0L);
    private final AtomicLong ADAPTIVE_RESIZES = new AtomicLong(0L);
    private final AtomicInteger currentCoreThreads;
    private final AtomicInteger currentMaxThreads;
    private final StampedLock CONFIG_LOCK = new StampedLock();
    private final ConcurrentHashMap<String, TaskMetrics> taskMetrics = new ConcurrentHashMap();
    private final ConcurrentHashMap<Long, TaskInfo> activeTasks = new ConcurrentHashMap();
    private final PriorityBlockingQueue<PriorityTask> highPriorityQueue;
    private final LinkedBlockingQueue<Runnable> normalQueue;
    private final LinkedBlockingQueue<Runnable> backgroundQueue;
    private static final AtomicLong TASK_ID_GENERATOR = new AtomicLong(1L);

    private UnifiedExecutorManager() {
        double tps = PerformanceManager.getAverageTPS();
        this.baseCoreThreads = PerformanceConstants.getAdaptiveCoreThreads(tps);
        this.baseMaxThreads = PerformanceConstants.getAdaptiveMaxThreads(tps);
        this.keepAliveTimeSeconds = PerformanceConstants.getAdaptiveThreadKeepAliveSeconds(tps);
        this.baseQueueCapacity = PerformanceConstants.getAdaptiveQueueCapacity(tps);
        this.highPriorityQueue = new PriorityBlockingQueue();
        this.normalQueue = new LinkedBlockingQueue(this.baseQueueCapacity);
        this.backgroundQueue = new LinkedBlockingQueue(this.baseQueueCapacity * 2);
        this.currentCoreThreads = new AtomicInteger(this.baseCoreThreads);
        this.currentMaxThreads = new AtomicInteger(this.baseMaxThreads);
        this.forkJoinPool = new ForkJoinPool(Math.max(1, this.baseCoreThreads), ForkJoinPool.defaultForkJoinWorkerThreadFactory, (t, e) -> System.err.println("ForkJoinPool exception in thread " + t.getName() + ": " + e.getMessage()), true);
        this.ioExecutor = new ThreadPoolExecutor(Math.max(1, this.baseCoreThreads / 2), Math.max(this.baseCoreThreads + 1, this.baseMaxThreads), this.keepAliveTimeSeconds, this.KEEP_ALIVE_UNIT, new LinkedBlockingQueue<Runnable>(this.baseQueueCapacity), new EnhancedThreadFactory("UnifiedExecutor-IO-", true), new ThreadPoolExecutor.CallerRunsPolicy());
        this.primaryExecutor = new ThreadPoolExecutor(this.baseCoreThreads, this.baseMaxThreads, this.keepAliveTimeSeconds, this.KEEP_ALIVE_UNIT, new EnhancedBlockingQueue(), new EnhancedThreadFactory("UnifiedExecutor-Primary-", true), new EnhancedRejectedExecutionHandler(this.forkJoinPool));
        this.primaryExecutor.allowCoreThreadTimeOut(true);
        this.scheduler = Executors.newScheduledThreadPool(2, new EnhancedThreadFactory("UnifiedExecutor-Scheduler-", true));
        this.startAdaptiveManagement();
    }

    public static UnifiedExecutorManager getInstance() {
        return INSTANCE;
    }

    public CompletableFuture<Void> submitHighPriority(Runnable task, String taskType) {
        return this.submitTask(task, TaskPriority.HIGH, taskType);
    }

    public CompletableFuture<Void> submitNormalPriority(Runnable task, String taskType) {
        return this.submitTask(task, TaskPriority.NORMAL, taskType);
    }

    public CompletableFuture<Void> submitBackgroundTask(Runnable task, String taskType) {
        return this.submitTask(task, TaskPriority.BACKGROUND, taskType);
    }

    public CompletableFuture<Void> submitIOTask(Runnable task, String taskType) {
        return this.submitToExecutor(task, this.ioExecutor, TaskPriority.NORMAL, taskType);
    }

    public <T> CompletableFuture<T> submitParallelTask(Supplier<T> task, String taskType) {
        long taskId = TASK_ID_GENERATOR.getAndIncrement();
        TaskInfo taskInfo = new TaskInfo(taskId, taskType, System.currentTimeMillis(), TaskPriority.NORMAL);
        this.activeTasks.put(taskId, taskInfo);
        CompletionStage future = CompletableFuture.supplyAsync(task, this.forkJoinPool).whenComplete((result, throwable) -> {
            this.activeTasks.remove(taskId);
            this.recordTaskCompletion(taskType, System.currentTimeMillis() - taskInfo.startTime);
        });
        this.submittedTasks.incrementAndGet();
        return future;
    }

    public CompletableFuture<Void> submitBatch(List<Runnable> tasks, TaskPriority priority, String taskType) {
        if (tasks.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        for (Runnable task : tasks) {
            futures.add(this.submitTask(task, priority, taskType));
        }
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
    }

    private CompletableFuture<Void> submitTask(Runnable task, TaskPriority priority, String taskType) {
        return this.submitToExecutor(task, this.primaryExecutor, priority, taskType);
    }

    private CompletableFuture<Void> submitToExecutor(Runnable task, ExecutorService executor, TaskPriority priority, String taskType) {
        long taskId = TASK_ID_GENERATOR.getAndIncrement();
        TaskInfo taskInfo = new TaskInfo(taskId, taskType, System.currentTimeMillis(), priority);
        this.activeTasks.put(taskId, taskInfo);
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        Runnable wrappedTask = () -> {
            long startTime = System.currentTimeMillis();
            try {
                task.run();
                future.complete(null);
            }
            catch (Exception e) {
                future.completeExceptionally(e);
                System.err.println("Task execution failed: " + taskType + " - " + e.getMessage());
            }
            finally {
                long duration = System.currentTimeMillis() - startTime;
                this.activeTasks.remove(taskId);
                this.recordTaskCompletion(taskType, duration);
                this.completedTasks.incrementAndGet();
            }
        };
        try {
            switch (priority.ordinal()) {
                case 0: {
                    PriorityTask priorityTask = new PriorityTask(wrappedTask, priority);
                    this.highPriorityQueue.offer(priorityTask);
                    break;
                }
                case 1: {
                    this.normalQueue.offer(wrappedTask);
                    break;
                }
                case 2: {
                    this.backgroundQueue.offer(wrappedTask);
                }
            }
            this.submittedTasks.incrementAndGet();
        }
        catch (Exception e) {
            this.rejectedTasks.incrementAndGet();
            future.completeExceptionally(e);
        }
        return future;
    }

    private void recordTaskCompletion(String taskType, long duration) {
        TaskMetrics metrics = this.taskMetrics.computeIfAbsent(taskType, k -> new TaskMetrics());
        metrics.recordExecution(duration);
    }

    private void startAdaptiveManagement() {
        this.scheduler.scheduleAtFixedRate(() -> {
            try {
                this.performAdaptiveThreadSizing();
            }
            catch (Exception e) {
                System.err.println("Error in adaptive thread sizing: " + e.getMessage());
            }
        }, 0L, this.getAdaptiveExecutorInterval(), TimeUnit.MILLISECONDS);
        this.scheduler.scheduleAtFixedRate(() -> {
            try {
                this.logPerformanceMetrics();
            }
            catch (Exception e) {
                System.err.println("Error in performance monitoring: " + e.getMessage());
            }
        }, 30000L, 30000L, TimeUnit.MILLISECONDS);
    }

    private long getAdaptiveExecutorInterval() {
        double tps = PerformanceManager.getAverageTPS();
        return PerformanceConstants.getAdaptiveExecutorCheckIntervalMs(tps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performAdaptiveThreadSizing() {
        block13: {
            long stamp = this.CONFIG_LOCK.readLock();
            try {
                int activeCount = this.primaryExecutor.getActiveCount();
                int poolSize = this.primaryExecutor.getPoolSize();
                int queueSize = this.primaryExecutor.getQueue().size();
                if (poolSize == 0) {
                    return;
                }
                double loadFactor = (double)activeCount / (double)poolSize;
                double adaptiveQueueCapacity = PerformanceConstants.getAdaptiveQueueCapacity(PerformanceManager.getAverageTPS());
                double queueLoadFactor = adaptiveQueueCapacity > 0.0 ? (double)queueSize / adaptiveQueueCapacity : 0.0;
                boolean slowTick = false;
                try {
                    long lastTickMs = PerformanceManager.getLastTickDurationMs();
                    slowTick = lastTickMs > 50L;
                }
                catch (Throwable t) {
                    slowTick = false;
                }
                if (loadFactor > 0.8 || queueLoadFactor > 0.7 || slowTick) {
                    int newCoreSize = Math.min(this.currentCoreThreads.get() + 2, this.baseMaxThreads);
                    int newMaxSize = Math.min(this.currentMaxThreads.get() + 2, this.baseMaxThreads * 2);
                    if (newCoreSize <= this.currentCoreThreads.get() && newMaxSize <= this.currentMaxThreads.get()) break block13;
                    if (slowTick) {
                        try {
                            long lastTickMs = PerformanceManager.getLastTickDurationMs();
                            LOGGER.info("Scaling up threads due to slow tick: { } ms", (Object)lastTickMs);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    this.primaryExecutor.setCorePoolSize(newCoreSize);
                    this.primaryExecutor.setMaximumPoolSize(newMaxSize);
                    this.currentCoreThreads.set(newCoreSize);
                    this.currentMaxThreads.set(newMaxSize);
                    this.ADAPTIVE_RESIZES.incrementAndGet();
                    break block13;
                }
                if (loadFactor < 0.3 && queueLoadFactor < 0.2) {
                    int newCoreSize = Math.max(this.baseCoreThreads, this.currentCoreThreads.get() - 2);
                    int newMaxSize = Math.max(this.baseMaxThreads, this.currentMaxThreads.get() - 2);
                    if (newCoreSize < this.currentCoreThreads.get() || newMaxSize < this.currentMaxThreads.get()) {
                        this.primaryExecutor.setCorePoolSize(newCoreSize);
                        this.primaryExecutor.setMaximumPoolSize(newMaxSize);
                        this.currentCoreThreads.set(newCoreSize);
                        this.currentMaxThreads.set(newMaxSize);
                        this.ADAPTIVE_RESIZES.incrementAndGet();
                    }
                }
            }
            finally {
                this.CONFIG_LOCK.unlockRead(stamp);
            }
        }
    }

    private void logPerformanceMetrics() {
        System.out.println("=== UnifiedExecutorManager Performance Metrics ===");
        System.out.println("Submitted Tasks: " + this.submittedTasks.get());
        System.out.println("Completed Tasks: " + this.completedTasks.get());
        System.out.println("Rejected Tasks: " + this.rejectedTasks.get());
        System.out.println("Queue Waits: " + this.queueWaits.get());
        System.out.println("Adaptive Resizes: " + this.ADAPTIVE_RESIZES.get());
        System.out.println("Active Threads: " + this.primaryExecutor.getActiveCount() + "/" + this.primaryExecutor.getPoolSize());
        System.out.println("Queue Size: " + this.primaryExecutor.getQueue().size());
        System.out.println("Current Config: Core=" + this.currentCoreThreads.get() + ", Max=" + this.currentMaxThreads.get());
        System.out.println("Task Execution Metrics:");
        for (Map.Entry<String, TaskMetrics> entry : this.taskMetrics.entrySet()) {
            TaskMetrics metrics = entry.getValue();
            System.out.println("  " + entry.getKey() + ":");
            System.out.println("    Count: " + metrics.executionCount.get());
            System.out.println("    Avg: " + String.format("%.2f", metrics.getAverageExecutionTime()) + "ms");
            System.out.println("    Min: " + metrics.getMinExecutionTime() + "ms");
            System.out.println("    Max: " + metrics.getMaxExecutionTime() + "ms");
        }
        System.out.println("Active Tasks: " + this.activeTasks.size());
        System.out.println("=============================================");
    }

    public String getPerformanceStats() {
        StringBuilder Stats = new StringBuilder();
        Stats.append("UnifiedExecutorManager Statistics:\n");
        Stats.append("Submitted: ").append(this.submittedTasks.get()).append("\n");
        Stats.append("Completed: ").append(this.completedTasks.get()).append("\n");
        Stats.append("Rejected: ").append(this.rejectedTasks.get()).append("\n");
        Stats.append("Active Threads: ").append(this.primaryExecutor.getActiveCount()).append("/").append(this.primaryExecutor.getPoolSize()).append("\n");
        Stats.append("Queue Size: ").append(this.primaryExecutor.getQueue().size()).append("\n");
        Stats.append("Current Config: Core=").append(this.currentCoreThreads.get()).append(", Max=").append(this.currentMaxThreads.get()).append("\n");
        return Stats.toString();
    }

    public void shutdown() {
        System.out.println("Shutting down UnifiedExecutorManager...");
        this.scheduler.shutdown();
        try {
            if (!this.scheduler.awaitTermination(5L, TimeUnit.SECONDS)) {
                this.scheduler.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.scheduler.shutdownNow();
            Thread.currentThread().interrupt();
        }
        this.primaryExecutor.shutdown();
        this.forkJoinPool.shutdown();
        this.ioExecutor.shutdown();
        try {
            if (!this.primaryExecutor.awaitTermination(10L, TimeUnit.SECONDS)) {
                this.primaryExecutor.shutdownNow();
            }
            if (!this.forkJoinPool.awaitTermination(10L, TimeUnit.SECONDS)) {
                this.forkJoinPool.shutdownNow();
            }
            if (!this.ioExecutor.awaitTermination(10L, TimeUnit.SECONDS)) {
                this.ioExecutor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.primaryExecutor.shutdownNow();
            this.forkJoinPool.shutdownNow();
            this.ioExecutor.shutdownNow();
            Thread.currentThread().interrupt();
        }
        System.out.println("UnifiedExecutorManager shutdown complete.");
    }

    private static final class EnhancedThreadFactory
    implements ThreadFactory {
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;
        private final boolean isDaemon;

        EnhancedThreadFactory(String namePrefix, boolean isDaemon) {
            this.namePrefix = namePrefix;
            this.isDaemon = isDaemon;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r, this.namePrefix + "-" + this.threadNumber.getAndIncrement());
            thread.setDaemon(this.isDaemon);
            thread.setUncaughtExceptionHandler((t, e) -> {
                System.err.println("Uncaught exception in thread " + t.getName() + ": " + e.getMessage());
                e.printStackTrace();
            });
            return thread;
        }
    }

    private final class EnhancedBlockingQueue
    extends LinkedBlockingQueue<Runnable> {
        private EnhancedBlockingQueue() {
        }

        @Override
        public Runnable take() throws InterruptedException {
            PriorityTask priorityTask = UnifiedExecutorManager.this.highPriorityQueue.poll();
            if (priorityTask != null) {
                UnifiedExecutorManager.this.queueWaits.incrementAndGet();
                return priorityTask.getTask();
            }
            Runnable normalTask = UnifiedExecutorManager.this.normalQueue.poll();
            if (normalTask != null) {
                return normalTask;
            }
            Runnable backgroundTask = UnifiedExecutorManager.this.backgroundQueue.poll();
            if (backgroundTask != null) {
                return backgroundTask;
            }
            return (Runnable)super.take();
        }

        @Override
        public Runnable poll(long timeout, TimeUnit unit) throws InterruptedException {
            long deadline = System.nanoTime() + unit.toNanos(timeout);
            while (System.nanoTime() < deadline) {
                PriorityTask priorityTask = UnifiedExecutorManager.this.highPriorityQueue.poll();
                if (priorityTask != null) {
                    UnifiedExecutorManager.this.queueWaits.incrementAndGet();
                    return priorityTask.getTask();
                }
                Runnable normalTask = UnifiedExecutorManager.this.normalQueue.poll();
                if (normalTask != null) {
                    return normalTask;
                }
                Runnable backgroundTask = UnifiedExecutorManager.this.backgroundQueue.poll();
                if (backgroundTask != null) {
                    return backgroundTask;
                }
                Thread.sleep(1L);
            }
            return (Runnable)super.poll(timeout, unit);
        }

        @Override
        public int size() {
            return UnifiedExecutorManager.this.highPriorityQueue.size() + UnifiedExecutorManager.this.normalQueue.size() + UnifiedExecutorManager.this.backgroundQueue.size() + super.size();
        }
    }

    private static final class EnhancedRejectedExecutionHandler
    implements RejectedExecutionHandler {
        private final ExecutorService fallbackExecutor;

        EnhancedRejectedExecutionHandler(ExecutorService fallbackExecutor) {
            this.fallbackExecutor = fallbackExecutor;
        }

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            try {
                this.fallbackExecutor.execute(r);
            }
            catch (RejectedExecutionException e) {
                r.run();
            }
        }
    }

    public static enum TaskPriority {
        HIGH(1),
        NORMAL(2),
        BACKGROUND(3);

        private final int priority;

        private TaskPriority(int priority) {
            this.priority = priority;
        }

        public int getPriority() {
            return this.priority;
        }
    }

    private static final class TaskInfo {
        private final long taskId;
        private final String taskType;
        private final long startTime;
        private final TaskPriority priority;

        TaskInfo(long taskId, String taskType, long startTime, TaskPriority priority) {
            this.taskId = taskId;
            this.taskType = taskType;
            this.startTime = startTime;
            this.priority = priority;
        }
    }

    private static final class PriorityTask
    implements Comparable<PriorityTask> {
        private final Runnable task;
        private final TaskPriority priority;
        private final long sequence;
        private static final AtomicLong SEQUENCE_GENERATOR = new AtomicLong(0L);

        PriorityTask(Runnable task, TaskPriority priority) {
            this.task = task;
            this.priority = priority;
            this.sequence = SEQUENCE_GENERATOR.incrementAndGet();
        }

        @Override
        public int compareTo(PriorityTask other) {
            int priorityCompare = Integer.compare(this.priority.getPriority(), other.priority.getPriority());
            return priorityCompare != 0 ? priorityCompare : Long.compare(this.sequence, other.sequence);
        }

        Runnable getTask() {
            return this.task;
        }
    }

    private static final class TaskMetrics {
        private final AtomicLong executionCount = new AtomicLong(0L);
        private final AtomicLong totalExecutionTime = new AtomicLong(0L);
        private final AtomicLong maxExecutionTime = new AtomicLong(0L);
        private final AtomicLong minExecutionTime = new AtomicLong(Long.MAX_VALUE);

        private TaskMetrics() {
        }

        void recordExecution(long duration) {
            this.executionCount.incrementAndGet();
            this.totalExecutionTime.addAndGet(duration);
            this.maxExecutionTime.updateAndGet(current -> Math.max(current, duration));
            this.minExecutionTime.updateAndGet(current -> Math.min(current, duration));
        }

        double getAverageExecutionTime() {
            long count = this.executionCount.get();
            return count > 0L ? (double)this.totalExecutionTime.get() / (double)count : 0.0;
        }

        long getMaxExecutionTime() {
            return this.maxExecutionTime.get();
        }

        long getMinExecutionTime() {
            return this.minExecutionTime.get() == Long.MAX_VALUE ? 0L : this.minExecutionTime.get();
        }
    }
}

