/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.chunkstorage.core;

import com.kneaf.core.chunkstorage.cache.ChunkCache;
import com.kneaf.core.chunkstorage.common.ChunkStorageConfig;
import com.kneaf.core.chunkstorage.common.ChunkStorageExceptionHandler;
import com.kneaf.core.chunkstorage.swap.SwapManager;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChunkStorageConfigManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChunkStorageConfigManager.class);
    private final ChunkStorageConfig config;

    public ChunkStorageConfigManager(ChunkStorageConfig config) {
        if (config == null) {
            throw new IllegalArgumentException("Config cannot be null");
        }
        this.config = config;
    }

    public ChunkCache.EvictionPolicy createEvictionPolicy() {
        if (!this.config.isEnabled()) {
            return new ChunkCache.LRUEvictionPolicy();
        }
        String evictionPolicy = this.config.getEvictionPolicy();
        if (evictionPolicy == null || evictionPolicy.isEmpty()) {
            evictionPolicy = "LRU";
        }
        switch (evictionPolicy.toLowerCase()) {
            case "lru": {
                return new ChunkCache.LRUEvictionPolicy();
            }
            case "distance": {
                return new ChunkCache.DistanceEvictionPolicy(0, 0);
            }
            case "hybrid": {
                return new ChunkCache.HybridEvictionPolicy();
            }
            case "swapaware": {
                return new ChunkCache.SwapAwareEvictionPolicy(ChunkCache.MemoryPressureLevel.NORMAL);
            }
        }
        ChunkStorageExceptionHandler.logWarning("ChunkStorageConfigManager", "Unknown eviction policy '{ }', defaulting to LRU", evictionPolicy);
        return new ChunkCache.LRUEvictionPolicy();
    }

    public void validateConfiguration() {
        if (this.config.getCacheCapacity() <= 0) {
            throw new IllegalArgumentException("Cache capacity must be positive");
        }
        if (this.config.getAsyncThreadpoolSize() <= 0) {
            throw new IllegalArgumentException("Async thread pool size must be positive");
        }
        if (this.config.getMaintenanceIntervalMinutes() <= 0L) {
            throw new IllegalArgumentException("Maintenance interval must be positive");
        }
        if (this.config.getMaxBackupFiles() <= 0) {
            throw new IllegalArgumentException("Max backup files must be positive");
        }
        if (this.config.getBackupRetentionDays() <= 0L) {
            throw new IllegalArgumentException("Backup retention days must be positive");
        }
        if (this.config.getSwapMemoryCheckIntervalMs() <= 0L) {
            throw new IllegalArgumentException("Swap memory check interval must be positive");
        }
        if (this.config.getMaxConcurrentSwaps() <= 0) {
            throw new IllegalArgumentException("Max concurrent swaps must be positive");
        }
        if (this.config.getSwapBatchSize() <= 0) {
            throw new IllegalArgumentException("Swap batch size must be positive");
        }
        if (this.config.getSwapTimeoutMs() <= 0L) {
            throw new IllegalArgumentException("Swap timeout must be positive");
        }
        if (this.config.getMinSwapChunkAgeMs() <= 0) {
            throw new IllegalArgumentException("Min swap chunk age must be positive");
        }
        if (this.config.getCriticalMemoryThreshold() <= 0.0 || this.config.getCriticalMemoryThreshold() >= 1.0) {
            throw new IllegalArgumentException("Critical memory threshold must be between 0 and 1");
        }
        if (this.config.getHighMemoryThreshold() <= 0.0 || this.config.getHighMemoryThreshold() >= 1.0) {
            throw new IllegalArgumentException("High memory threshold must be between 0 and 1");
        }
        if (this.config.getElevatedMemoryThreshold() <= 0.0 || this.config.getElevatedMemoryThreshold() >= 1.0) {
            throw new IllegalArgumentException("Elevated memory threshold must be between 0 and 1");
        }
        if (this.config.getElevatedMemoryThreshold() >= this.config.getHighMemoryThreshold()) {
            throw new IllegalArgumentException("Elevated threshold must be less than high threshold");
        }
        if (this.config.getHighMemoryThreshold() >= this.config.getCriticalMemoryThreshold()) {
            throw new IllegalArgumentException("High threshold must be less than critical threshold");
        }
        if (this.config.getEvictionPolicy() == null || this.config.getEvictionPolicy().isEmpty()) {
            throw new IllegalArgumentException("Eviction policy cannot be null or empty");
        }
        if (this.config.getBackupPath() == null || this.config.getBackupPath().isEmpty()) {
            throw new IllegalArgumentException("Backup path cannot be null or empty");
        }
        if (this.config.getDatabaseType() == null || this.config.getDatabaseType().isEmpty()) {
            throw new IllegalArgumentException("Database type cannot be null or empty");
        }
        LOGGER.info("Configuration validation passed for ChunkStorageConfig");
    }

    public ChunkStorageConfig getConfig() {
        return this.config;
    }

    public boolean shouldEnableSwapManager() {
        return this.config.isEnabled() && this.config.isEnableSwapManager() && this.config.isUseRustDatabase();
    }

    public SwapManager.SwapConfig createSwapConfig() {
        SwapManager.SwapConfig swapConfig = new SwapManager.SwapConfig();
        swapConfig.setEnabled(this.config.isEnableSwapManager());
        swapConfig.setMemoryCheckIntervalMs(this.config.getSwapMemoryCheckIntervalMs());
        swapConfig.setMaxConcurrentSwaps(this.config.getMaxConcurrentSwaps());
        swapConfig.setSwapBatchSize(this.config.getSwapBatchSize());
        swapConfig.setSwapTimeoutMs(this.config.getSwapTimeoutMs());
        swapConfig.setEnableAutomaticSwapping(this.config.isEnableAutomaticSwapping());
        swapConfig.setCriticalMemoryThreshold(this.config.getCriticalMemoryThreshold());
        swapConfig.setHighMemoryThreshold(this.config.getHighMemoryThreshold());
        swapConfig.setElevatedMemoryThreshold(this.config.getElevatedMemoryThreshold());
        swapConfig.setMinSwapChunkAgeMs(this.config.getMinSwapChunkAgeMs());
        swapConfig.setEnableSwapStatistics(this.config.isEnableSwapStatistics());
        swapConfig.setEnablePerformanceMonitoring(true);
        return swapConfig;
    }

    public ThreadFactory createThreadFactory(final String worldName) {
        return new ThreadFactory(){
            private final AtomicInteger threadNumber = new AtomicInteger(1);

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r, "chunk-storage-" + worldName + "-" + this.threadNumber.getAndIncrement());
                thread.setDaemon(true);
                return thread;
            }
        };
    }

    public String getConfigurationSummary() {
        return String.format("ChunkStorageConfig{enabled=%s, cacheCapacity=%d, evictionPolicy='%s', asyncThreadpoolSize=%d, databaseType='%s', useRustDatabase=%s, enableSwapManager=%s, maxConcurrentSwaps=%d, swapBatchSize=%d}", this.config.isEnabled(), this.config.getCacheCapacity(), this.config.getEvictionPolicy(), this.config.getAsyncThreadpoolSize(), this.config.getDatabaseType(), this.config.isUseRustDatabase(), this.config.isEnableSwapManager(), this.config.getMaxConcurrentSwaps(), this.config.getSwapBatchSize());
    }
}

