/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.client;

import com.kneaf.core.network.NetworkHandler;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;

@OnlyIn(value=Dist.CLIENT)
public final class PerformanceOverlayClient {
    private static final int MAX_LINES = 40;
    private static final Deque<String> LINES = new ArrayDeque<String>(40);

    private PerformanceOverlayClient() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void registerClient(FMLClientSetupEvent event) {
        try {
            Class<?> clientPlayNetworking = Class.forName("net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking");
            Class<?> serverPlayPacketConsumer = Class.forName("net.fabricmc.fabric.api.networking.v1.PacketConsumer");
            Method register = clientPlayNetworking.getMethod("register", ResourceLocation.class, serverPlayPacketConsumer);
            Object consumer = Proxy.newProxyInstance(PerformanceOverlayClient.class.getClassLoader(), new Class[]{serverPlayPacketConsumer}, (proxy, method, args) -> {
                if (args != null && args.length > 1 && args[1] != null) {
                    try {
                        Object buf = args[1];
                        Method readUtf = buf.getClass().getMethod("readUtf", Integer.TYPE);
                        String msg = (String)readUtf.invoke(buf, Short.MAX_VALUE);
                        PerformanceOverlayClient.onPerformanceLineReceived(msg);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return null;
            });
            register.invoke(null, NetworkHandler.PERFORMANCE_CHANNEL, consumer);
            return;
        }
        catch (ClassNotFoundException clientPlayNetworking) {
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException clientPlayNetworking) {
            // empty catch block
        }
        try {
            Class<?> hudCallbackClass = Class.forName("net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback");
            Field eventField = hudCallbackClass.getField("EVENT");
            Object eventObj = eventField.get(null);
            Method registerHud = eventObj.getClass().getMethod("register", hudCallbackClass);
            Object hudListener = Proxy.newProxyInstance(PerformanceOverlayClient.class.getClassLoader(), new Class[]{hudCallbackClass}, (proxy, method, args) -> {
                try {
                    float partial = 0.0f;
                    if (args != null && args.length > 1 && args[1] instanceof Float) {
                        partial = ((Float)args[1]).floatValue();
                    }
                    PerformanceOverlayClient.renderLinesUsingFont(args != null && args.length > 0 ? args[0] : null, partial);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return null;
            });
            registerHud.invoke(eventObj, hudListener);
            return;
        }
        catch (ClassNotFoundException hudCallbackClass) {
        }
        catch (Throwable hudCallbackClass) {
            // empty catch block
        }
        try {
            Minecraft mc = Minecraft.getInstance();
            Object conn = null;
            try {
                Method getConnection = mc.getClass().getMethod("getConnection", new Class[0]);
                conn = getConnection.invoke((Object)mc, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (conn == null) return;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onPerformanceLineReceived(String line) {
        if (line == null) {
            return;
        }
        Deque<String> deque = LINES;
        synchronized (deque) {
            if (LINES.size() >= 40) {
                LINES.removeFirst();
            }
            LINES.addLast(line);
        }
        try {
            Minecraft mc = Minecraft.getInstance();
            if (mc != null && mc.gui != null) {
                try {
                    mc.gui.getChat().addMessage((Component)Component.literal((String)line));
                }
                catch (Throwable throwable) {}
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void renderOverlay(GuiGraphics graphics, float partialTicks) {
        Minecraft mc = Minecraft.getInstance();
        if (mc == null || mc.player == null) {
            return;
        }
        int x = 10;
        int y = 10;
        Objects.requireNonNull(mc.font);
        int lineHeight = 9 + 2;
        Deque<String> deque = LINES;
        synchronized (deque) {
            int i = 0;
            for (String s : LINES) {
                int yy = y + i * lineHeight;
                graphics.drawString(mc.font, s, x, yy, 0xFFFFFF, false);
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void renderLinesUsingFont(Object poseStack, float partialTicks) {
        try {
            Minecraft mc = Minecraft.getInstance();
            if (mc == null) {
                return;
            }
            Font font = mc.font;
            if (font == null) {
                return;
            }
            int x = 10;
            int y = 10;
            Objects.requireNonNull(mc.font);
            int lineHeight = 9 + 2;
            Deque<String> deque = LINES;
            synchronized (deque) {
                int i = 0;
                for (String s : LINES) {
                    int yy = y + i * lineHeight;
                    try {
                        try {
                            Method draw = font.getClass().getMethod("draw", GuiGraphics.class, String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE);
                            draw.invoke((Object)font, null, s, x, yy, 0xFFFFFF);
                        }
                        catch (NoSuchMethodException ns) {
                            try {
                                Method draw2 = font.getClass().getMethod("draw", String.class, Float.TYPE, Float.TYPE, Integer.TYPE);
                                draw2.invoke((Object)font, s, Float.valueOf(x), Float.valueOf(yy), 0xFFFFFF);
                            }
                            catch (NoSuchMethodException ns2) {
                                Method draw3 = font.getClass().getMethod("drawString", String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE);
                                draw3.invoke((Object)font, s, x, yy, 0xFFFFFF);
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    ++i;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

