/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.config.core;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigurationUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationUtils.class);

    private ConfigurationUtils() {
    }

    public static Properties loadProperties(String configPath) {
        Properties props = new Properties();
        Path path = Paths.get(configPath, new String[0]);
        if (Files.exists(path, new LinkOption[0])) {
            try (InputStream in = Files.newInputStream(path, new OpenOption[0]);){
                props.load(in);
                LOGGER.info("Loaded configuration from: { }", (Object)configPath);
            }
            catch (IOException e) {
                LOGGER.warn("Failed to read configuration from { }, using defaults: { }", (Object)configPath, (Object)e.getMessage());
            }
        } else {
            LOGGER.info("Configuration file not found at { }, using defaults", (Object)configPath);
        }
        return props;
    }

    public static boolean getBooleanProperty(Properties props, String key, boolean defaultValue) {
        String value = props.getProperty(key);
        return value != null ? Boolean.parseBoolean(value) : defaultValue;
    }

    public static int getIntProperty(Properties props, String key, int defaultValue) {
        String value = props.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value.trim());
        }
        catch (NumberFormatException e) {
            LOGGER.warn("Invalid integer value for key '{ }': { }", (Object)key, (Object)value);
            return defaultValue;
        }
    }

    public static long getLongProperty(Properties props, String key, long defaultValue) {
        String value = props.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(value.trim());
        }
        catch (NumberFormatException e) {
            LOGGER.warn("Invalid long value for key '{ }': { }", (Object)key, (Object)value);
            return defaultValue;
        }
    }

    public static double getDoubleProperty(Properties props, String key, double defaultValue) {
        String value = props.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(value.trim());
        }
        catch (NumberFormatException e) {
            LOGGER.warn("Invalid double value for key '{ }': { }", (Object)key, (Object)value);
            return defaultValue;
        }
    }

    public static String getProperty(Properties props, String key, String defaultValue) {
        return props.getProperty(key, defaultValue);
    }

    public static String[] getStringArrayProperty(Properties props, String key, String[] defaultValue) {
        String value = props.getProperty(key);
        if (value == null || value.trim().isEmpty()) {
            return defaultValue != null ? (String[])defaultValue.clone() : new String[]{};
        }
        return value.split("\\s*,\\s*");
    }

    public static void validatePositive(int value, String name) {
        if (value <= 0) {
            throw new IllegalArgumentException(name + " must be positive");
        }
    }

    public static void validatePositive(long value, String name) {
        if (value <= 0L) {
            throw new IllegalArgumentException(name + " must be positive");
        }
    }

    public static void validatePositive(double value, String name) {
        if (value <= 0.0) {
            throw new IllegalArgumentException(name + " must be positive");
        }
    }

    public static void validateNotEmpty(String value, String name) {
        if (value == null || value.isEmpty()) {
            throw new IllegalArgumentException(name + " cannot be null or empty");
        }
    }

    public static void validateRange(double value, double min, double max, String name) {
        if (value < min || value > max) {
            throw new IllegalArgumentException(name + " must be between " + min + " and " + max + ", got: " + value);
        }
    }

    public static void validateMinMax(int min, int max, String minName, String maxName) {
        if (min > max) {
            throw new IllegalArgumentException(minName + " (" + min + ") cannot be greater than " + maxName + " (" + max + ")");
        }
    }

    public static void validateMinMax(double min, double max, String minName, String maxName) {
        if (min > max) {
            throw new IllegalArgumentException(minName + " (" + min + ") cannot be greater than " + maxName + " (" + max + ")");
        }
    }
}

