/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.data.entity;

import com.kneaf.core.data.core.DataUtils;
import com.kneaf.core.data.core.DataValidationException;
import com.kneaf.core.data.entity.BaseEntityData;

public class VillagerData
extends BaseEntityData {
    private final double distance;
    private final String profession;
    private final int level;
    private final boolean hasWorkstation;
    private final boolean isResting;
    private final boolean isBreeding;
    private final long lastPathfindTick;
    private final int pathfindFrequency;
    private final int aiComplexity;

    public VillagerData(long id, double x, double y, double z, double distance, String profession, int level, boolean hasWorkstation, boolean isResting, boolean isBreeding, long lastPathfindTick, int pathfindFrequency, int aiComplexity) {
        super(id, x, y, z, "villager");
        this.distance = distance;
        this.profession = profession == null ? "none" : profession;
        this.level = level;
        this.hasWorkstation = hasWorkstation;
        this.isResting = isResting;
        this.isBreeding = isBreeding;
        this.lastPathfindTick = lastPathfindTick;
        this.pathfindFrequency = pathfindFrequency;
        this.aiComplexity = aiComplexity;
    }

    public double getDistance() {
        return this.distance;
    }

    public String getProfession() {
        return this.profession;
    }

    public int getLevel() {
        return this.level;
    }

    public boolean hasWorkstation() {
        return this.hasWorkstation;
    }

    public boolean isResting() {
        return this.isResting;
    }

    public boolean isBreeding() {
        return this.isBreeding;
    }

    public long getLastPathfindTick() {
        return this.lastPathfindTick;
    }

    public int getPathfindFrequency() {
        return this.pathfindFrequency;
    }

    public int getAiComplexity() {
        return this.aiComplexity;
    }

    @Override
    public boolean validate() {
        super.validate();
        DataUtils.validateDistance(this.distance, "distance");
        if (this.profession != null) {
            DataUtils.validateNotEmpty(this.profession, "profession");
        }
        DataUtils.validateNonNegative(this.level, "level");
        DataUtils.validateNonNegative(this.lastPathfindTick, "lastPathfindTick");
        DataUtils.validateNonNegative(this.pathfindFrequency, "pathfindFrequency");
        DataUtils.validateNonNegative(this.aiComplexity, "aiComplexity");
        if (this.level > 5) {
            throw new DataValidationException("level", this.level, "Villager level cannot exceed 5");
        }
        return true;
    }

    public boolean canWork() {
        return this.hasWorkstation && !this.isResting;
    }

    public boolean isActive() {
        return !this.isResting && !this.isBreeding;
    }

    public int getAiLoadScore() {
        return this.aiComplexity * this.pathfindFrequency;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private long id;
        private double x;
        private double y;
        private double z;
        private double distance = 0.0;
        private String profession = "none";
        private int level = 1;
        private boolean hasWorkstation = false;
        private boolean isResting = false;
        private boolean isBreeding = false;
        private long lastPathfindTick = 0L;
        private int pathfindFrequency = 20;
        private int aiComplexity = 1;

        public Builder id(long id) {
            this.id = id;
            return this;
        }

        public Builder position(double x, double y, double z) {
            this.x = x;
            this.y = y;
            this.z = z;
            return this;
        }

        public Builder distance(double distance) {
            this.distance = distance;
            return this;
        }

        public Builder profession(String profession) {
            this.profession = profession;
            return this;
        }

        public Builder level(int level) {
            this.level = level;
            return this;
        }

        public Builder hasWorkstation(boolean hasWorkstation) {
            this.hasWorkstation = hasWorkstation;
            return this;
        }

        public Builder isResting(boolean isResting) {
            this.isResting = isResting;
            return this;
        }

        public Builder isBreeding(boolean isBreeding) {
            this.isBreeding = isBreeding;
            return this;
        }

        public Builder lastPathfindTick(long lastPathfindTick) {
            this.lastPathfindTick = lastPathfindTick;
            return this;
        }

        public Builder pathfindFrequency(int pathfindFrequency) {
            this.pathfindFrequency = pathfindFrequency;
            return this;
        }

        public Builder aiComplexity(int aiComplexity) {
            this.aiComplexity = aiComplexity;
            return this;
        }

        public VillagerData build() {
            return new VillagerData(this.id, this.x, this.y, this.z, this.distance, this.profession, this.level, this.hasWorkstation, this.isResting, this.isBreeding, this.lastPathfindTick, this.pathfindFrequency, this.aiComplexity);
        }
    }
}

