/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.exceptions;

import com.kneaf.core.exceptions.processing.AsyncProcessingException;

@Deprecated
public class AsyncProcessingException
extends RuntimeException {
    private final com.kneaf.core.exceptions.processing.AsyncProcessingException delegate;
    private final String taskType;
    private final long timeoutMs;

    public AsyncProcessingException(AsyncErrorType errorType, String message) {
        super(message);
        this.delegate = ((AsyncProcessingException.Builder)com.kneaf.core.exceptions.processing.AsyncProcessingException.builder().errorType(AsyncProcessingException.convertErrorType(errorType)).message(message)).build();
        this.taskType = null;
        this.timeoutMs = -1L;
    }

    public AsyncProcessingException(AsyncErrorType errorType, String message, Throwable cause) {
        super(message, cause);
        this.delegate = ((AsyncProcessingException.Builder)((AsyncProcessingException.Builder)com.kneaf.core.exceptions.processing.AsyncProcessingException.builder().errorType(AsyncProcessingException.convertErrorType(errorType)).message(message)).cause(cause)).build();
        this.taskType = null;
        this.timeoutMs = -1L;
    }

    public AsyncProcessingException(AsyncErrorType errorType, String taskType, String message, Throwable cause) {
        super(message, cause);
        this.delegate = ((AsyncProcessingException.Builder)((AsyncProcessingException.Builder)com.kneaf.core.exceptions.processing.AsyncProcessingException.builder().errorType(AsyncProcessingException.convertErrorType(errorType)).taskType(taskType).message(message)).cause(cause)).build();
        this.taskType = taskType;
        this.timeoutMs = -1L;
    }

    public AsyncProcessingException(AsyncErrorType errorType, String taskType, long timeoutMs, String message, Throwable cause) {
        super(message, cause);
        this.delegate = ((AsyncProcessingException.Builder)((AsyncProcessingException.Builder)com.kneaf.core.exceptions.processing.AsyncProcessingException.builder().errorType(AsyncProcessingException.convertErrorType(errorType)).taskType(taskType).timeoutMs(timeoutMs).message(message)).cause(cause)).build();
        this.taskType = taskType;
        this.timeoutMs = timeoutMs;
    }

    public AsyncErrorType getErrorType() {
        return AsyncProcessingException.convertErrorTypeBack(this.delegate.getErrorType());
    }

    public String getTaskType() {
        return this.taskType != null ? this.taskType : this.delegate.getTaskType();
    }

    public long getTimeoutMs() {
        return this.timeoutMs != -1L ? this.timeoutMs : this.delegate.getTimeoutMs();
    }

    public com.kneaf.core.exceptions.processing.AsyncProcessingException getDelegate() {
        return this.delegate;
    }

    public static AsyncProcessingException batchRequestInterrupted(String taskType, Throwable cause) {
        return new AsyncProcessingException(AsyncErrorType.BATCH_REQUEST_INTERRUPTED, taskType, String.format("Batch request for '%s' was interrupted", taskType), cause);
    }

    public static AsyncProcessingException timeoutExceeded(String taskType, long timeoutMs, Throwable cause) {
        return new AsyncProcessingException(AsyncErrorType.TIMEOUT_EXCEEDED, taskType, timeoutMs, String.format("Async operation exceeded timeout of %dms", timeoutMs), cause);
    }

    public static AsyncProcessingException supplyAsyncFailed(String operation, String key, Throwable cause) {
        return new AsyncProcessingException(AsyncErrorType.SUPPLY_ASYNC_FAILED, operation, String.format("Supply async operation failed for %s: %s", operation, key), cause);
    }

    private static AsyncProcessingException.AsyncErrorType convertErrorType(AsyncErrorType errorType) {
        if (errorType == null) {
            return null;
        }
        switch (errorType.ordinal()) {
            case 0: {
                return AsyncProcessingException.AsyncErrorType.BATCH_REQUEST_INTERRUPTED;
            }
            case 1: {
                return AsyncProcessingException.AsyncErrorType.TIMEOUT_EXCEEDED;
            }
            case 2: {
                return AsyncProcessingException.AsyncErrorType.EXECUTOR_SHUTDOWN;
            }
            case 3: {
                return AsyncProcessingException.AsyncErrorType.TASK_REJECTED;
            }
            case 4: {
                return AsyncProcessingException.AsyncErrorType.COMPLETION_EXCEPTION;
            }
            case 5: {
                return AsyncProcessingException.AsyncErrorType.SUPPLY_ASYNC_FAILED;
            }
        }
        return AsyncProcessingException.AsyncErrorType.SUPPLY_ASYNC_FAILED;
    }

    private static AsyncErrorType convertErrorTypeBack(AsyncProcessingException.AsyncErrorType errorType) {
        if (errorType == null) {
            return null;
        }
        switch (errorType) {
            case BATCH_REQUEST_INTERRUPTED: {
                return AsyncErrorType.BATCH_REQUEST_INTERRUPTED;
            }
            case TIMEOUT_EXCEEDED: {
                return AsyncErrorType.TIMEOUT_EXCEEDED;
            }
            case EXECUTOR_SHUTDOWN: {
                return AsyncErrorType.EXECUTOR_SHUTDOWN;
            }
            case TASK_REJECTED: {
                return AsyncErrorType.TASK_REJECTED;
            }
            case COMPLETION_EXCEPTION: {
                return AsyncErrorType.COMPLETION_EXCEPTION;
            }
            case SUPPLY_ASYNC_FAILED: {
                return AsyncErrorType.SUPPLY_ASYNC_FAILED;
            }
        }
        return AsyncErrorType.SUPPLY_ASYNC_FAILED;
    }

    public static enum AsyncErrorType {
        BATCH_REQUEST_INTERRUPTED("Batch request interrupted"),
        TIMEOUT_EXCEEDED("Async operation timeout exceeded"),
        EXECUTOR_SHUTDOWN("Async executor shutdown"),
        TASK_REJECTED("Async task rejected"),
        COMPLETION_EXCEPTION("Async completion exception"),
        SUPPLY_ASYNC_FAILED("Supply async operation failed");

        private final String description;

        private AsyncErrorType(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

