/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.exceptions.core;

import com.kneaf.core.exceptions.core.BaseKneafException;
import com.kneaf.core.exceptions.utils.ExceptionContext;

public class KneafCoreException
extends BaseKneafException {
    private final ErrorCategory category;
    private final String operation;

    private KneafCoreException(Builder builder) {
        super(builder);
        this.category = builder.category;
        this.operation = builder.operation;
    }

    public ErrorCategory getCategory() {
        return this.category;
    }

    public String getOperation() {
        return this.operation;
    }

    @Override
    public KneafCoreException withContext(ExceptionContext context) {
        return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)new Builder().message(this.getMessage())).cause(this.getCause())).errorCode(this.getErrorCode())).severity(this.getSeverity())).context(context)).suggestion(this.getSuggestion())).logged(this.isLogged())).category(this.category).operation(this.operation).build();
    }

    @Override
    public KneafCoreException withSuggestion(String suggestion) {
        return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)new Builder().message(this.getMessage())).cause(this.getCause())).errorCode(this.getErrorCode())).severity(this.getSeverity())).context(this.getContext())).suggestion(suggestion)).logged(this.isLogged())).category(this.category).operation(this.operation).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static KneafCoreException of(ErrorCategory category, String message) {
        return ((Builder)((Builder)KneafCoreException.builder().category(category).message(message)).errorCode(category.getCodePrefix() + "000")).build();
    }

    public static KneafCoreException of(ErrorCategory category, String operation, String message) {
        return ((Builder)((Builder)KneafCoreException.builder().category(category).operation(operation).message(message)).errorCode(category.getCodePrefix() + "000")).build();
    }

    public static KneafCoreException of(ErrorCategory category, String operation, String message, Throwable cause) {
        return ((Builder)((Builder)((Builder)KneafCoreException.builder().category(category).operation(operation).message(message)).cause(cause)).errorCode(category.getCodePrefix() + "000")).build();
    }

    public static class Builder
    extends BaseKneafException.Builder<Builder> {
        private ErrorCategory category;
        private String operation;

        @Override
        protected Builder self() {
            return this;
        }

        public Builder category(ErrorCategory category) {
            this.category = category;
            return this;
        }

        public Builder operation(String operation) {
            this.operation = operation;
            return this;
        }

        @Override
        protected void validate() {
            super.validate();
            if (this.category == null) {
                throw new IllegalArgumentException("Error category cannot be null");
            }
        }

        public KneafCoreException build() {
            this.validate();
            if (this.errorCode == null) {
                this.errorCode = this.category.getCodePrefix() + "000";
            }
            return new KneafCoreException(this);
        }
    }

    public static enum ErrorCategory {
        DATABASE_OPERATION("DB", "Database operation failed"),
        NATIVE_LIBRARY("NAT", "Native library error"),
        ASYNC_PROCESSING("ASYNC", "Async processing error"),
        CONFIGURATION("CFG", "Configuration error"),
        RESOURCE_MANAGEMENT("SYS", "Resource management error"),
        PROTOCOL_ERROR("SYS", "Protocol error"),
        VALIDATION_ERROR("VAL", "Validation error"),
        SYSTEM_ERROR("SYS", "System error");

        private final String codePrefix;
        private final String description;

        private ErrorCategory(String codePrefix, String description) {
            this.codePrefix = codePrefix;
            this.description = description;
        }

        public String getCodePrefix() {
            return this.codePrefix;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

