/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.exceptions.processing;

import com.kneaf.core.exceptions.core.BaseKneafException;
import com.kneaf.core.exceptions.utils.ExceptionContext;
import com.kneaf.core.exceptions.utils.ExceptionSeverity;

public class AsyncProcessingException
extends BaseKneafException {
    private final AsyncErrorType errorType;
    private final String taskType;
    private final long timeoutMs;

    private AsyncProcessingException(Builder builder) {
        super(builder);
        this.errorType = builder.errorType;
        this.taskType = builder.taskType;
        this.timeoutMs = builder.timeoutMs;
    }

    public AsyncErrorType getErrorType() {
        return this.errorType;
    }

    public String getTaskType() {
        return this.taskType;
    }

    public long getTimeoutMs() {
        return this.timeoutMs;
    }

    @Override
    public AsyncProcessingException withContext(ExceptionContext context) {
        return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)new Builder().message(this.getMessage())).cause(this.getCause())).errorCode(this.getErrorCode())).severity(this.getSeverity())).context(context)).suggestion(this.getSuggestion())).logged(this.isLogged())).errorType(this.errorType).taskType(this.taskType).timeoutMs(this.timeoutMs).build();
    }

    @Override
    public AsyncProcessingException withSuggestion(String suggestion) {
        return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)new Builder().message(this.getMessage())).cause(this.getCause())).errorCode(this.getErrorCode())).severity(this.getSeverity())).context(this.getContext())).suggestion(suggestion)).logged(this.isLogged())).errorType(this.errorType).taskType(this.taskType).timeoutMs(this.timeoutMs).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static AsyncProcessingException batchRequestInterrupted(String taskType, Throwable cause) {
        return ((Builder)((Builder)((Builder)((Builder)AsyncProcessingException.builder().errorType(AsyncErrorType.BATCH_REQUEST_INTERRUPTED).taskType(taskType).message(String.format("Batch request for '%s' was interrupted", taskType))).cause(cause)).severity(ExceptionSeverity.WARNING)).suggestion("Check application logs for detailed error information")).build();
    }

    public static AsyncProcessingException timeoutExceeded(String taskType, long timeoutMs, Throwable cause) {
        return ((Builder)((Builder)((Builder)((Builder)AsyncProcessingException.builder().errorType(AsyncErrorType.TIMEOUT_EXCEEDED).taskType(taskType).timeoutMs(timeoutMs).message(String.format("Async operation exceeded timeout of %dms", timeoutMs))).cause(cause)).severity(ExceptionSeverity.ERROR)).suggestion("Check system resources (memory, disk space, network)")).build();
    }

    public static AsyncProcessingException supplyAsyncFailed(String operation, String key, Throwable cause) {
        return ((Builder)((Builder)((Builder)((Builder)AsyncProcessingException.builder().errorType(AsyncErrorType.SUPPLY_ASYNC_FAILED).taskType(operation).message(String.format("Supply async operation failed for %s: %s", operation, key))).cause(cause)).severity(ExceptionSeverity.ERROR)).suggestion("Check external dependencies and services")).build();
    }

    public static class Builder
    extends BaseKneafException.Builder<Builder> {
        private AsyncErrorType errorType;
        private String taskType;
        private long timeoutMs = -1L;

        @Override
        protected Builder self() {
            return this;
        }

        public Builder errorType(AsyncErrorType errorType) {
            this.errorType = errorType;
            return this;
        }

        public Builder taskType(String taskType) {
            this.taskType = taskType;
            return this;
        }

        public Builder timeoutMs(long timeoutMs) {
            this.timeoutMs = timeoutMs;
            return this;
        }

        @Override
        protected void validate() {
            super.validate();
            if (this.errorType == null) {
                throw new IllegalArgumentException("Error type cannot be null");
            }
        }

        public AsyncProcessingException build() {
            this.validate();
            if (this.errorCode == null && this.errorType != null) {
                this.errorCode = this.errorType.getErrorCode();
            }
            if (this.severity == null) {
                this.severity = ExceptionSeverity.ERROR;
            }
            return new AsyncProcessingException(this);
        }
    }

    public static enum AsyncErrorType {
        BATCH_REQUEST_INTERRUPTED("ASYNC002", "Batch request interrupted"),
        TIMEOUT_EXCEEDED("ASYNC001", "Async operation timeout exceeded"),
        EXECUTOR_SHUTDOWN("ASYNC004", "Async executor shutdown"),
        TASK_REJECTED("ASYNC005", "Async task rejected"),
        COMPLETION_EXCEPTION("ASYNC006", "Async completion exception"),
        SUPPLY_ASYNC_FAILED("ASYNC007", "Supply async operation failed");

        private final String errorCode;
        private final String description;

        private AsyncErrorType(String errorCode, String description) {
            this.errorCode = errorCode;
            this.description = description;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

