/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.performance.bridge;

import com.kneaf.core.performance.core.PerformanceConstants;
import com.kneaf.core.performance.monitoring.PerformanceManager;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public final class NativeBridge {
    private static final ConcurrentLinkedQueue<byte[]> ENTITY_BATCH_BUFFER;
    private static final AtomicInteger ENTITY_BATCH_SIZE;
    private static final AtomicInteger FLUSH_IN_PROGRESS;
    private static final AtomicLong TOTAL_BATCHES_PROCESSED;
    private static final AtomicLong TOTAL_TASKS_PROCESSED;
    private static final AtomicLong TOTAL_MEMORY_SAVED;
    private static final AtomicInteger CURRENT_WORKER_COUNT;
    private static final ConcurrentLinkedQueue<ByteBuffer> BUFFER_POOL;
    private static final AtomicInteger POOLED_BUFFER_COUNT;
    private static final AtomicLong NEXT_HANDLE;
    private static final ConcurrentHashMap<Long, Worker> WORKERS;

    private static int maxBatchSize() {
        return Math.max(50, PerformanceConstants.getAdaptiveBatchSize(PerformanceManager.getAverageTPS(), PerformanceManager.getLastTickDurationMs()) * 2);
    }

    private static int minBatchSize() {
        return Math.max(5, PerformanceConstants.getAdaptiveBatchSize(PerformanceManager.getAverageTPS(), PerformanceManager.getLastTickDurationMs()) / 4);
    }

    private static int bufferPoolSize() {
        return Math.max(8, PerformanceConstants.getAdaptiveQueueCapacity(PerformanceManager.getAverageTPS()) / 20);
    }

    private static int maxBufferSize() {
        return PerformanceConstants.getAdaptiveMaxBufferSize(PerformanceManager.getAverageTPS());
    }

    private NativeBridge() {
    }

    public static void initRustAllocator() {
    }

    public static long nativeCreateWorker(int concurrency) {
        long h = NEXT_HANDLE.getAndIncrement();
        Worker w = new Worker(concurrency);
        WORKERS.put(h, w);
        return h;
    }

    public static void nativePushTask(long workerHandle, byte[] payload) {
        Worker w = WORKERS.get(workerHandle);
        if (w == null) {
            throw new IllegalArgumentException("invalid worker handle");
        }
        if (payload == null) {
            return;
        }
        w.tasks.offer(payload);
    }

    public static void nativePushTaskBuffer(long workerHandle, ByteBuffer payload) {
        if (payload == null) {
            return;
        }
        byte[] b = new byte[payload.remaining()];
        payload.get(b);
        NativeBridge.nativePushTask(workerHandle, b);
    }

    public static byte[] nativePollResult(long workerHandle) {
        Worker w = WORKERS.get(workerHandle);
        if (w == null) {
            throw new IllegalArgumentException("invalid worker handle");
        }
        return (byte[])w.results.poll();
    }

    public static ByteBuffer nativePollResultBuffer(long workerHandle) {
        byte[] r = NativeBridge.nativePollResult(workerHandle);
        if (r == null) {
            return null;
        }
        return ByteBuffer.wrap(r);
    }

    public static void nativeDestroyWorker(long workerHandle) {
        Worker w = WORKERS.remove(workerHandle);
        if (w != null) {
            w.stop();
        }
    }

    public static void nativePushBatch(long workerHandle, byte[][] payloads, int batchSize) {
        if (payloads == null) {
            return;
        }
        int limit = Math.min(batchSize, payloads.length);
        for (int i = 0; i < limit; ++i) {
            NativeBridge.nativePushTask(workerHandle, payloads[i]);
        }
    }

    public static void nativePushBatchBuffer(long workerHandle, ByteBuffer[] payloads, int batchSize) {
        if (payloads == null) {
            return;
        }
        int limit = Math.min(batchSize, payloads.length);
        for (int i = 0; i < limit; ++i) {
            NativeBridge.nativePushTaskBuffer(workerHandle, payloads[i]);
        }
    }

    public static byte[][] nativePollBatchResults(long workerHandle, int maxResults) {
        byte[] r;
        Worker w = WORKERS.get(workerHandle);
        if (w == null) {
            throw new IllegalArgumentException("invalid worker handle");
        }
        ArrayList<byte[]> out = new ArrayList<byte[]>();
        for (int i = 0; i < maxResults && (r = (byte[])w.results.poll()) != null; ++i) {
            out.add(r);
        }
        return (byte[][])out.toArray((T[])new byte[out.size()][]);
    }

    public static ByteBuffer[] nativePollBatchResultsBuffer(long workerHandle, int maxResults) {
        byte[][] arr = NativeBridge.nativePollBatchResults(workerHandle, maxResults);
        if (arr == null) {
            return null;
        }
        ByteBuffer[] out = new ByteBuffer[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            out[i] = ByteBuffer.wrap(arr[i]);
        }
        return out;
    }

    public static ByteBuffer nativeAllocateBuffer(int size) {
        try {
            return ByteBuffer.allocateDirect(size);
        }
        catch (Throwable t) {
            return ByteBuffer.allocate(size);
        }
    }

    public static void nativeFreeBuffer(ByteBuffer buffer) {
    }

    public static long nativeGetBufferAddress(ByteBuffer buffer) {
        return 0L;
    }

    public static long nativeGetWorkerQueueDepth(long workerHandle) {
        Worker w = WORKERS.get(workerHandle);
        if (w == null) {
            return 0L;
        }
        return w.tasks.size();
    }

    public static double nativeGetWorkerAvgProcessingMs(long workerHandle) {
        Worker w = WORKERS.get(workerHandle);
        if (w == null) {
            return 0.0;
        }
        long processed = w.tasksProcessed.get();
        if (processed == 0L) {
            return 0.0;
        }
        double avgNs = (double)w.totalProcessingNs.get() / (double)processed;
        return avgNs / 1000000.0;
    }

    public static long nativeGetWorkerMemoryUsage(long workerHandle) {
        return 0L;
    }

    public static long createOptimizedWorker(int concurrency) {
        long workerHandle = NativeBridge.nativeCreateWorker(concurrency);
        if (workerHandle != 0L) {
            CURRENT_WORKER_COUNT.incrementAndGet();
        }
        return workerHandle;
    }

    public static void destroyOptimizedWorker(long workerHandle) {
        if (workerHandle != 0L) {
            NativeBridge.nativeDestroyWorker(workerHandle);
            CURRENT_WORKER_COUNT.decrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pushTaskOptimized(long workerHandle, byte[] payload) {
        if (payload == null || payload.length == 0) {
            return;
        }
        double tps = PerformanceManager.getAverageTPS();
        int bufferThreshold = PerformanceConstants.getAdaptiveBufferUseThreshold(tps);
        if (payload.length > bufferThreshold) {
            ByteBuffer buffer = NativeBridge.getPooledBuffer(payload.length);
            try {
                buffer.clear();
                buffer.put(payload);
                buffer.flip();
                NativeBridge.nativePushTaskBuffer(workerHandle, buffer);
            }
            finally {
                NativeBridge.returnPooledBuffer(buffer);
            }
        } else {
            NativeBridge.nativePushTask(workerHandle, payload);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pushBatchOptimized(long workerHandle, byte[][] payloads) {
        if (payloads == null || payloads.length == 0) {
            return;
        }
        int batchSize = Math.min(payloads.length, NativeBridge.maxBatchSize());
        TOTAL_BATCHES_PROCESSED.incrementAndGet();
        TOTAL_TASKS_PROCESSED.addAndGet(batchSize);
        boolean useBuffers = false;
        int totalSize = 0;
        for (int i = 0; i < batchSize; ++i) {
            if (payloads[i] == null || payloads[i].length <= 4096) continue;
            useBuffers = true;
            totalSize += payloads[i].length;
        }
        if (useBuffers && totalSize > 16384) {
            ByteBuffer[] buffers = new ByteBuffer[batchSize];
            try {
                for (int i = 0; i < batchSize; ++i) {
                    if (payloads[i] == null) continue;
                    buffers[i] = NativeBridge.getPooledBuffer(payloads[i].length);
                    buffers[i].clear();
                    buffers[i].put(payloads[i]);
                    buffers[i].flip();
                }
                NativeBridge.nativePushBatchBuffer(workerHandle, buffers, batchSize);
            }
            finally {
                for (ByteBuffer buffer : buffers) {
                    if (buffer == null) continue;
                    NativeBridge.returnPooledBuffer(buffer);
                }
            }
        } else {
            NativeBridge.nativePushBatch(workerHandle, payloads, batchSize);
        }
    }

    public static byte[] pollResultOptimized(long workerHandle) {
        ByteBuffer bufferResult = NativeBridge.nativePollResultBuffer(workerHandle);
        if (bufferResult != null) {
            byte[] result = new byte[bufferResult.remaining()];
            bufferResult.get(result);
            NativeBridge.returnPooledBuffer(bufferResult);
            return result;
        }
        return NativeBridge.nativePollResult(workerHandle);
    }

    private static ByteBuffer getPooledBuffer(int size) {
        if (size > NativeBridge.maxBufferSize()) {
            return NativeBridge.nativeAllocateBuffer(size);
        }
        ByteBuffer buffer = BUFFER_POOL.poll();
        if (buffer != null && buffer.capacity() >= size) {
            POOLED_BUFFER_COUNT.decrementAndGet();
            TOTAL_MEMORY_SAVED.addAndGet(size);
            return buffer;
        }
        return NativeBridge.nativeAllocateBuffer(size);
    }

    private static void returnPooledBuffer(ByteBuffer buffer) {
        if (buffer == null || buffer.capacity() > NativeBridge.maxBufferSize()) {
            if (buffer != null) {
                NativeBridge.nativeFreeBuffer(buffer);
            }
            return;
        }
        if (POOLED_BUFFER_COUNT.get() < NativeBridge.bufferPoolSize()) {
            buffer.clear();
            BUFFER_POOL.offer(buffer);
            POOLED_BUFFER_COUNT.incrementAndGet();
        } else {
            NativeBridge.nativeFreeBuffer(buffer);
        }
    }

    public static Map<String, Object> getBatchStats() {
        HashMap<String, Object> Stats = new HashMap<String, Object>();
        Stats.put("TOTAL_BATCHES_PROCESSED", TOTAL_BATCHES_PROCESSED.get());
        Stats.put("totalTasksProcessed", TOTAL_TASKS_PROCESSED.get());
        Stats.put("totalMemorySaved", TOTAL_MEMORY_SAVED.get());
        Stats.put("currentWorkerCount", CURRENT_WORKER_COUNT.get());
        Stats.put("pooledBufferCount", POOLED_BUFFER_COUNT.get());
        if (TOTAL_BATCHES_PROCESSED.get() > 0L) {
            double avgBatchSize = (double)TOTAL_TASKS_PROCESSED.get() / (double)TOTAL_BATCHES_PROCESSED.get();
            Stats.put("AVERAGE_BATCH_SIZE", String.format("%.2f", avgBatchSize));
        }
        return Stats;
    }

    public static void cleanupBufferPool() {
        ByteBuffer buffer;
        while ((buffer = BUFFER_POOL.poll()) != null) {
            NativeBridge.nativeFreeBuffer(buffer);
            POOLED_BUFFER_COUNT.decrementAndGet();
        }
    }

    public static int getOptimalBatchSize(int requestedSize) {
        if (requestedSize <= NativeBridge.minBatchSize()) {
            return NativeBridge.minBatchSize();
        }
        if (requestedSize >= NativeBridge.maxBatchSize()) {
            return NativeBridge.maxBatchSize();
        }
        int batchSize = Math.round((float)requestedSize / 25.0f) * 25;
        return Math.max(NativeBridge.minBatchSize(), Math.min(NativeBridge.maxBatchSize(), batchSize));
    }

    public static void bufferEntityOperation(byte[] payload) {
        if (payload == null || payload.length == 0) {
            return;
        }
        ENTITY_BATCH_BUFFER.offer(payload);
        int currentSize = ENTITY_BATCH_SIZE.incrementAndGet();
        if (currentSize >= NativeBridge.maxBatchSize()) {
            NativeBridge.flushEntityBatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void flushEntityBatch() {
        if (FLUSH_IN_PROGRESS.getAndSet(1) != 0) {
            return;
        }
        try {
            byte[] payload;
            int batchSize = ENTITY_BATCH_SIZE.get();
            if (batchSize == 0) {
                return;
            }
            int actualCollected = 0;
            byte[][] batchPayloads = new byte[batchSize][];
            while ((payload = ENTITY_BATCH_BUFFER.poll()) != null && actualCollected < batchSize) {
                batchPayloads[actualCollected++] = payload;
            }
            if (actualCollected > 0) {
                ENTITY_BATCH_SIZE.addAndGet(-actualCollected);
                if (actualCollected > 0) {
                    long workerHandle = 0L;
                    workerHandle = WORKERS.isEmpty() ? NativeBridge.createOptimizedWorker(4) : (Long)((ConcurrentHashMap.KeySetView)WORKERS.keySet()).iterator().next();
                    if (workerHandle != 0L) {
                        NativeBridge.pushBatchOptimized(workerHandle, batchPayloads);
                        TOTAL_BATCHES_PROCESSED.incrementAndGet();
                        TOTAL_TASKS_PROCESSED.addAndGet(actualCollected);
                    }
                }
            }
        }
        finally {
            FLUSH_IN_PROGRESS.set(0);
        }
    }

    public static int getEntityBatchBufferSize() {
        return ENTITY_BATCH_SIZE.get();
    }

    public static void forceFlushEntityBatch() {
        NativeBridge.flushEntityBatch();
    }

    static {
        try {
            System.loadLibrary("rustperf");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
        ENTITY_BATCH_BUFFER = new ConcurrentLinkedQueue();
        ENTITY_BATCH_SIZE = new AtomicInteger(0);
        FLUSH_IN_PROGRESS = new AtomicInteger(0);
        TOTAL_BATCHES_PROCESSED = new AtomicLong(0L);
        TOTAL_TASKS_PROCESSED = new AtomicLong(0L);
        TOTAL_MEMORY_SAVED = new AtomicLong(0L);
        CURRENT_WORKER_COUNT = new AtomicInteger(0);
        BUFFER_POOL = new ConcurrentLinkedQueue();
        POOLED_BUFFER_COUNT = new AtomicInteger(0);
        NEXT_HANDLE = new AtomicLong(1L);
        WORKERS = new ConcurrentHashMap();
    }

    private static final class Worker {
        final BlockingQueue<byte[]> tasks = new LinkedBlockingQueue<byte[]>();
        final BlockingQueue<byte[]> results = new LinkedBlockingQueue<byte[]>();
        final AtomicLong totalProcessingNs = new AtomicLong(0L);
        final AtomicLong tasksProcessed = new AtomicLong(0L);
        final Thread thread = new Thread(this::runLoop, "native-worker-fallback-" + NEXT_HANDLE.get());
        volatile boolean running = true;

        Worker(int concurrency) {
            this.thread.setDaemon(true);
            this.thread.start();
        }

        void runLoop() {
            while (this.running) {
                try {
                    byte[] t = this.tasks.poll(100L, TimeUnit.MILLISECONDS);
                    if (t == null) continue;
                    long start = System.nanoTime();
                    try {
                        Thread.sleep(ThreadLocalRandom.current().nextInt(1, 3));
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                    }
                    try {
                        ByteBuffer in = ByteBuffer.wrap(t).order(ByteOrder.LITTLE_ENDIAN);
                        long taskId = 0L;
                        byte taskType = 0;
                        byte[] payload = new byte[]{};
                        if (t.length < 13) {
                            taskId = 0L;
                            taskType = 0;
                            payload = new byte[]{};
                            String msg = "Malformed envelope: too short";
                            byte[] msgBytes = msg.getBytes(StandardCharsets.UTF_8);
                            ByteBuffer outErr = ByteBuffer.allocate(13 + msgBytes.length).order(ByteOrder.LITTLE_ENDIAN);
                            outErr.putLong(0L);
                            outErr.put((byte)1);
                            outErr.putInt(msgBytes.length);
                            outErr.put(msgBytes);
                            this.results.offer(outErr.array());
                        } else {
                            taskId = in.getLong();
                            taskType = in.get();
                            int len = in.getInt();
                            if (len < 0 || in.remaining() < len) {
                                msg = "Task envelope payload length mismatch";
                                byte[] msgBytes = ((String)msg).getBytes(StandardCharsets.UTF_8);
                                outErr = ByteBuffer.allocate(13 + msgBytes.length).order(ByteOrder.LITTLE_ENDIAN);
                                outErr.putLong(0L);
                                outErr.put((byte)1);
                                outErr.putInt(msgBytes.length);
                                outErr.put(msgBytes);
                                this.results.offer(outErr.array());
                            } else {
                                if (len > 0) {
                                    payload = new byte[len];
                                    in.get(payload);
                                }
                                if (taskType == 1) {
                                    ByteBuffer out = ByteBuffer.allocate(13 + payload.length).order(ByteOrder.LITTLE_ENDIAN);
                                    out.putLong(taskId);
                                    out.put((byte)0);
                                    out.putInt(payload.length);
                                    if (payload.length > 0) {
                                        out.put(payload);
                                    }
                                    this.results.offer(out.array());
                                } else if (taskType == 2) {
                                    try {
                                        String s = new String(payload, StandardCharsets.UTF_8);
                                        long n = Long.parseLong(s.trim());
                                        long sum = 0L;
                                        for (long i = 1L; i <= n; ++i) {
                                            sum += i * i;
                                        }
                                        String json = String.format("{\"task\":\"heavy\",\"n\":%d,\"sum\":%d}", n, sum);
                                        byte[] jb = json.getBytes(StandardCharsets.UTF_8);
                                        ByteBuffer out = ByteBuffer.allocate(13 + jb.length).order(ByteOrder.LITTLE_ENDIAN);
                                        out.putLong(taskId);
                                        out.put((byte)0);
                                        out.putInt(jb.length);
                                        out.put(jb);
                                        this.results.offer(out.array());
                                    }
                                    catch (NumberFormatException nfe) {
                                        String msg = "Invalid number in payload";
                                        byte[] msgBytes = msg.getBytes(StandardCharsets.UTF_8);
                                        ByteBuffer outErr = ByteBuffer.allocate(13 + msgBytes.length).order(ByteOrder.LITTLE_ENDIAN);
                                        outErr.putLong(taskId);
                                        outErr.put((byte)1);
                                        outErr.putInt(msgBytes.length);
                                        outErr.put(msgBytes);
                                        this.results.offer(outErr.array());
                                    }
                                } else if ((taskType & 0xFF) == 255) {
                                    msg = "panic: Intentional panic for testing";
                                    byte[] msgBytes = ((String)msg).getBytes(StandardCharsets.UTF_8);
                                    outErr = ByteBuffer.allocate(13 + msgBytes.length).order(ByteOrder.LITTLE_ENDIAN);
                                    outErr.putLong(taskId);
                                    outErr.put((byte)1);
                                    outErr.putInt(msgBytes.length);
                                    outErr.put(msgBytes);
                                    this.results.offer(outErr.array());
                                } else {
                                    msg = "Unknown task type: " + taskType;
                                    byte[] msgBytes = ((String)msg).getBytes(StandardCharsets.UTF_8);
                                    outErr = ByteBuffer.allocate(13 + msgBytes.length).order(ByteOrder.LITTLE_ENDIAN);
                                    outErr.putLong(taskId);
                                    outErr.put((byte)1);
                                    outErr.putInt(msgBytes.length);
                                    outErr.put(msgBytes);
                                    this.results.offer(outErr.array());
                                }
                            }
                        }
                    }
                    catch (Exception ex) {
                        try {
                            String base = ex.getMessage();
                            Object msg = base == null ? "internal error" : "internal error: " + base;
                            byte[] msgBytes = ((String)msg).getBytes(StandardCharsets.UTF_8);
                            ByteBuffer out = ByteBuffer.allocate(13 + msgBytes.length).order(ByteOrder.LITTLE_ENDIAN);
                            out.putLong(0L);
                            out.put((byte)1);
                            out.putInt(msgBytes.length);
                            out.put(msgBytes);
                            this.results.offer(out.array());
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    long dur = System.nanoTime() - start;
                    this.totalProcessingNs.addAndGet(dur);
                    this.tasksProcessed.incrementAndGet();
                }
                catch (Throwable throwable) {}
            }
        }

        void stop() {
            this.running = false;
            this.thread.interrupt();
        }
    }
}

