/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.performance.bridge;

import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public final class NativeBridgeUtils {
    private NativeBridgeUtils() {
    }

    public static int calculateOptimalBatchSize(int requestedSize, int minBatchSize, int maxBatchSize) {
        if (requestedSize <= minBatchSize) {
            return minBatchSize;
        }
        if (requestedSize >= maxBatchSize) {
            return maxBatchSize;
        }
        int batchSize = Math.round((float)requestedSize / 25.0f) * 25;
        return Math.max(minBatchSize, Math.min(maxBatchSize, batchSize));
    }

    public static boolean shouldUseBufferProcessing(byte[] payload, int threshold) {
        return payload != null && payload.length > threshold;
    }

    public static boolean shouldUseBatchBufferProcessing(byte[][] payloads, int batchSize, int totalSizeThreshold) {
        if (payloads == null || payloads.length == 0) {
            return false;
        }
        int totalSize = 0;
        int effectiveBatchSize = Math.min(payloads.length, batchSize);
        for (int i = 0; i < effectiveBatchSize; ++i) {
            if (payloads[i] != null && payloads[i].length > 4096) {
                return true;
            }
            if (payloads[i] == null) continue;
            totalSize += payloads[i].length;
        }
        return totalSize > totalSizeThreshold;
    }

    public static String getPlatformLibraryName() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.contains("windows")) {
            return "rustperf.dll";
        }
        if (osName.contains("mac")) {
            return "librustperf.dylib";
        }
        return "librustperf.so";
    }

    public static String[] getPlatformLibraryNames() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.contains("windows")) {
            return new String[]{"rustperf.dll", "librustperf.dll"};
        }
        if (osName.contains("mac")) {
            return new String[]{"librustperf.dylib", "librustperf.jnilib"};
        }
        return new String[]{"librustperf.so", "rustperf.so"};
    }

    public static boolean isValidNativeResult(byte[] result) {
        return result != null && result.length > 0;
    }

    public static boolean isValidJsonResult(String result) {
        return result != null && !result.isEmpty() && result.trim().startsWith("{") && result.trim().endsWith("}");
    }

    public static int calculateAlignedBufferSize(int requiredSize, int alignment) {
        return (requiredSize + alignment - 1) / alignment * alignment;
    }

    public static ByteBuffer safeAllocateBuffer(int size, int maxSize) {
        if (size <= 0 || size > maxSize) {
            throw new IllegalArgumentException("Invalid buffer size: " + size);
        }
        return ByteBuffer.allocateDirect(size);
    }

    public static class NativeCallMetrics {
        private final AtomicLong totalCalls = new AtomicLong(0L);
        private final AtomicLong successfulCalls = new AtomicLong(0L);
        private final AtomicLong failedCalls = new AtomicLong(0L);
        private final AtomicLong totalDuration = new AtomicLong(0L);

        public void recordCall(boolean success, long duration) {
            this.totalCalls.incrementAndGet();
            this.totalDuration.addAndGet(duration);
            if (success) {
                this.successfulCalls.incrementAndGet();
            } else {
                this.failedCalls.incrementAndGet();
            }
        }

        public long getTotalCalls() {
            return this.totalCalls.get();
        }

        public long getSuccessfulCalls() {
            return this.successfulCalls.get();
        }

        public long getFailedCalls() {
            return this.failedCalls.get();
        }

        public long getTotalDuration() {
            return this.totalDuration.get();
        }

        public double getAverageDuration() {
            long calls = this.totalCalls.get();
            return calls > 0L ? (double)this.totalDuration.get() / (double)calls : 0.0;
        }

        public double getSuccessRate() {
            long calls = this.totalCalls.get();
            return calls > 0L ? (double)this.successfulCalls.get() / (double)calls : 0.0;
        }
    }

    public static class BufferPoolStats {
        private final AtomicLong TOTAL_BATCHES_PROCESSED = new AtomicLong(0L);
        private final AtomicLong totalTasksProcessed = new AtomicLong(0L);
        private final AtomicLong totalMemorySaved = new AtomicLong(0L);
        private final AtomicInteger currentWorkerCount = new AtomicInteger(0);
        private final AtomicInteger pooledBufferCount = new AtomicInteger(0);

        public void recordBatchProcessed(int batchSize) {
            this.TOTAL_BATCHES_PROCESSED.incrementAndGet();
            this.totalTasksProcessed.addAndGet(batchSize);
        }

        public void recordMemorySaved(int size) {
            this.totalMemorySaved.addAndGet(size);
        }

        public void incrementWorkerCount() {
            this.currentWorkerCount.incrementAndGet();
        }

        public void decrementWorkerCount() {
            this.currentWorkerCount.decrementAndGet();
        }

        public void incrementPooledBufferCount() {
            this.pooledBufferCount.incrementAndGet();
        }

        public void decrementPooledBufferCount() {
            this.pooledBufferCount.decrementAndGet();
        }

        public long getTotalBatchesProcessed() {
            return this.TOTAL_BATCHES_PROCESSED.get();
        }

        public long getTotalTasksProcessed() {
            return this.totalTasksProcessed.get();
        }

        public long getTotalMemorySaved() {
            return this.totalMemorySaved.get();
        }

        public int getCurrentWorkerCount() {
            return this.currentWorkerCount.get();
        }

        public int getPooledBufferCount() {
            return this.pooledBufferCount.get();
        }

        public double getAverageBatchSize() {
            long batches = this.TOTAL_BATCHES_PROCESSED.get();
            return batches > 0L ? (double)this.totalTasksProcessed.get() / (double)batches : 0.0;
        }
    }
}

