/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.performance.bridge;

import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;

public class NativeLibraryLoader {
    private static final String LIBRARY_NAME = "rustperf";
    private static volatile boolean libraryLoaded = false;
    private static volatile boolean initializationAttempted = false;

    public static synchronized boolean loadNativeLibrary() {
        if (initializationAttempted) {
            return libraryLoaded;
        }
        initializationAttempted = true;
        ArrayList<CallSite> errors = new ArrayList<CallSite>();
        try {
            System.loadLibrary(LIBRARY_NAME);
            libraryLoaded = true;
            return true;
        }
        catch (UnsatisfiedLinkError e) {
            errors.add((CallSite)((Object)("System.loadLibrary failed: " + e.getMessage())));
        }
        catch (Exception e) {
            errors.add((CallSite)((Object)("System.loadLibrary exception: " + e.getMessage())));
        }
        try {
            if (NativeLibraryLoader.loadFromResources()) {
                libraryLoaded = true;
                return true;
            }
        }
        catch (Exception e) {
            errors.add((CallSite)((Object)("Resource loading failed: " + e.getMessage())));
        }
        try {
            if (NativeLibraryLoader.loadFromBuildDirectory()) {
                libraryLoaded = true;
                return true;
            }
        }
        catch (Exception e) {
            errors.add((CallSite)((Object)("Build directory loading failed: " + e.getMessage())));
        }
        try {
            if (NativeLibraryLoader.loadWithPlatformNames()) {
                libraryLoaded = true;
                return true;
            }
        }
        catch (Exception e) {
            errors.add((CallSite)((Object)("Platform-specific loading failed: " + e.getMessage())));
        }
        System.err.println("Failed to load native library 'rustperf'. Attempted strategies:");
        for (String string : errors) {
            System.err.println("  - " + string);
        }
        return false;
    }

    private static boolean loadFromResources() throws IOException {
        String libName = NativeLibraryLoader.getPlatformLibraryName();
        String resourcePath = "natives/" + libName;
        try (InputStream in = NativeLibraryLoader.class.getClassLoader().getResourceAsStream(resourcePath);){
            if (in == null) {
                throw new IOException("Native library not found in resources: " + resourcePath);
            }
            Path tempDir = Files.createTempDirectory("kneafcore-natives", new FileAttribute[0]);
            Path tempFile = tempDir.resolve(libName);
            Files.copy(in, tempFile, StandardCopyOption.REPLACE_EXISTING);
            System.load(tempFile.toAbsolutePath().toString());
            tempFile.toFile().deleteOnExit();
            tempDir.toFile().deleteOnExit();
            boolean bl = true;
            return bl;
        }
    }

    private static boolean loadFromBuildDirectory() throws IOException {
        Path[] alternativePaths;
        String libName = NativeLibraryLoader.getPlatformLibraryName();
        Path buildPath = Paths.get("build", "generated", "resources", "natives", libName);
        if (Files.exists(buildPath, new LinkOption[0])) {
            System.load(buildPath.toAbsolutePath().toString());
            return true;
        }
        for (Path path : alternativePaths = new Path[]{Paths.get("build", "generated", "resources", "natives", "rustperf.dll"), Paths.get("build", "generated", "resources", "natives", "librustperf.so"), Paths.get("build", "generated", "resources", "natives", "librustperf.dylib")}) {
            if (!Files.exists(path, new LinkOption[0])) continue;
            System.load(path.toAbsolutePath().toString());
            return true;
        }
        throw new IOException("Native library not found in build directory: " + String.valueOf(buildPath));
    }

    private static boolean loadWithPlatformNames() {
        String osName = System.getProperty("os.name").toLowerCase();
        String[] possibleNames = osName.contains("windows") ? new String[]{"rustperf.dll", "librustperf.dll"} : (osName.contains("mac") ? new String[]{"librustperf.dylib", "librustperf.jnilib"} : new String[]{"librustperf.so", "rustperf.so"});
        for (String name : possibleNames) {
            try {
                System.loadLibrary(name.replace(".dll", "").replace(".so", "").replace(".dylib", ""));
                return true;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            }
        }
        return false;
    }

    private static String getPlatformLibraryName() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.contains("windows")) {
            return "rustperf.dll";
        }
        if (osName.contains("mac")) {
            return "librustperf.dylib";
        }
        return "librustperf.so";
    }

    public static boolean isLibraryLoaded() {
        return libraryLoaded;
    }

    public static String getLoadingStatus() {
        if (libraryLoaded) {
            return "Native library 'rustperf' successfully loaded";
        }
        if (initializationAttempted) {
            return "Native library 'rustperf' failed to load (initialization attempted)";
        }
        return "Native library 'rustperf' not loaded (initialization not attempted)";
    }
}

