/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.performance.monitoring;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class PerformanceConfig {
    private static final String DEFAULT_CONFIG_PATH = "config/kneaf-performance.properties";
    private final boolean enabled;
    private final int threadpoolSize;
    private final int logIntervalTicks;
    private final int scanIntervalTicks;
    private final double tpsThresholdForAsync;
    private final int maxEntitiesToCollect;
    private final double entityDistanceCutoff;
    private final long maxLogBytes;
    private final boolean adaptiveThreadPool;
    private final int maxThreadpoolSize;
    private final String[] excludedEntityTypes;
    private final int networkExecutorpoolSize;
    private final boolean profilingEnabled;
    private final long slowTickThresholdMs;
    private final int profilingSampleRate;
    private final boolean broadcastToClient;
    private final int minThreadpoolSize;
    private final boolean dynamicThreadScaling;
    private final double threadScaleUpThreshold;
    private final double threadScaleDownThreshold;
    private final int threadScaleUpDelayTicks;
    private final int threadScaleDownDelayTicks;
    private final boolean workStealingEnabled;
    private final int workStealingQueueSize;
    private final boolean cpuAwareThreadSizing;
    private final double cpuLoadThreshold;
    private final int threadPoolKeepAliveSeconds;
    private final int distanceCalculationInterval;
    private final boolean distanceApproximationEnabled;
    private final int distanceCacheSize;
    private final int itemProcessingIntervalMultiplier;
    private final int spatialGridUpdateInterval;
    private final boolean incrementalSpatialUpdates;
    private final boolean entityCollectionOptimizationsEnabled;
    private final double entitySamplingRate;
    private final int entityChunkSize;
    private final int entityPoolSize;
    private final boolean chunkBasedParallelProcessing;
    private final int jniMinimumBatchSize;
    private final int jniMaximumBatchSize;
    private final boolean combineMultipleOperations;

    public static Logger getLogger() {
        return LazyLoggerHolder.LOGGER;
    }

    private PerformanceConfig(Builder b) {
        this.enabled = b.enabled;
        this.threadpoolSize = b.threadpoolSize;
        this.logIntervalTicks = b.logIntervalTicks;
        this.scanIntervalTicks = b.scanIntervalTicks;
        this.tpsThresholdForAsync = b.tpsThresholdForAsync;
        this.maxEntitiesToCollect = b.maxEntitiesToCollect;
        this.entityDistanceCutoff = b.entityDistanceCutoff;
        this.maxLogBytes = b.maxLogBytes;
        this.adaptiveThreadPool = b.adaptiveThreadPool;
        this.maxThreadpoolSize = b.maxThreadpoolSize;
        this.excludedEntityTypes = b.excludedEntityTypes == null ? new String[]{} : (String[])b.excludedEntityTypes.clone();
        this.networkExecutorpoolSize = b.networkExecutorpoolSize;
        this.profilingEnabled = b.profilingEnabled;
        this.slowTickThresholdMs = b.slowTickThresholdMs;
        this.profilingSampleRate = b.profilingSampleRate;
        this.broadcastToClient = b.broadcastToClient;
        this.minThreadpoolSize = b.minThreadpoolSize;
        this.dynamicThreadScaling = b.dynamicThreadScaling;
        this.threadScaleUpThreshold = b.threadScaleUpThreshold;
        this.threadScaleDownThreshold = b.threadScaleDownThreshold;
        this.threadScaleUpDelayTicks = b.threadScaleUpDelayTicks;
        this.threadScaleDownDelayTicks = b.threadScaleDownDelayTicks;
        this.workStealingEnabled = b.workStealingEnabled;
        this.workStealingQueueSize = b.workStealingQueueSize;
        this.cpuAwareThreadSizing = b.cpuAwareThreadSizing;
        this.cpuLoadThreshold = b.cpuLoadThreshold;
        this.threadPoolKeepAliveSeconds = b.threadPoolKeepAliveSeconds;
        this.distanceCalculationInterval = b.distanceCalculationInterval;
        this.distanceApproximationEnabled = b.distanceApproximationEnabled;
        this.distanceCacheSize = b.distanceCacheSize;
        this.itemProcessingIntervalMultiplier = b.itemProcessingIntervalMultiplier;
        this.spatialGridUpdateInterval = b.spatialGridUpdateInterval;
        this.incrementalSpatialUpdates = b.incrementalSpatialUpdates;
        this.entityCollectionOptimizationsEnabled = b.entityCollectionOptimizationsEnabled;
        this.entitySamplingRate = b.entitySamplingRate;
        this.entityChunkSize = b.entityChunkSize;
        this.entityPoolSize = b.entityPoolSize;
        this.chunkBasedParallelProcessing = b.chunkBasedParallelProcessing;
        this.jniMinimumBatchSize = b.jniMinimumBatchSize;
        this.jniMaximumBatchSize = b.jniMaximumBatchSize;
        this.combineMultipleOperations = b.combineMultipleOperations;
        this.validateConfiguration();
    }

    private void validateConfiguration() {
        if (this.minThreadpoolSize > this.maxThreadpoolSize) {
            throw new IllegalArgumentException("minThreadpoolSize (" + this.minThreadpoolSize + ") cannot be greater than maxThreadpoolSize (" + this.maxThreadpoolSize + ")");
        }
        if (this.threadScaleUpThreshold <= this.threadScaleDownThreshold) {
            throw new IllegalArgumentException("threadScaleUpThreshold (" + this.threadScaleUpThreshold + ") must be greater than threadScaleDownThreshold (" + this.threadScaleDownThreshold + ")");
        }
        if (this.scanIntervalTicks < 1 || this.scanIntervalTicks > 100) {
            throw new IllegalArgumentException("scanIntervalTicks must be between 1 and 100, got: " + this.scanIntervalTicks);
        }
        if (this.tpsThresholdForAsync < 10.0 || this.tpsThresholdForAsync > 20.0) {
            throw new IllegalArgumentException("tpsThresholdForAsync must be between 10.0 and 20.0, got: " + this.tpsThresholdForAsync);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getThreadpoolSize() {
        return this.threadpoolSize;
    }

    public int getLogIntervalTicks() {
        return this.logIntervalTicks;
    }

    public int getScanIntervalTicks() {
        return this.scanIntervalTicks;
    }

    public double getTpsThresholdForAsync() {
        return this.tpsThresholdForAsync;
    }

    public int getMaxEntitiesToCollect() {
        return this.maxEntitiesToCollect;
    }

    public double getEntityDistanceCutoff() {
        return this.entityDistanceCutoff;
    }

    public long getMaxLogBytes() {
        return this.maxLogBytes;
    }

    public boolean isAdaptiveThreadPool() {
        return this.adaptiveThreadPool;
    }

    public int getMaxThreadpoolSize() {
        return this.maxThreadpoolSize;
    }

    public String[] getExcludedEntityTypes() {
        return (String[])this.excludedEntityTypes.clone();
    }

    public int getNetworkExecutorpoolSize() {
        return this.networkExecutorpoolSize;
    }

    public boolean isProfilingEnabled() {
        return this.profilingEnabled;
    }

    public long getSlowTickThresholdMs() {
        return this.slowTickThresholdMs;
    }

    public int getProfilingSampleRate() {
        return this.profilingSampleRate;
    }

    public boolean isBroadcastToClient() {
        return this.broadcastToClient;
    }

    public int getMinThreadpoolSize() {
        return this.minThreadpoolSize;
    }

    public boolean isDynamicThreadScaling() {
        return this.dynamicThreadScaling;
    }

    public double getThreadScaleUpThreshold() {
        return this.threadScaleUpThreshold;
    }

    public double getThreadScaleDownThreshold() {
        return this.threadScaleDownThreshold;
    }

    public int getThreadScaleUpDelayTicks() {
        return this.threadScaleUpDelayTicks;
    }

    public int getThreadScaleDownDelayTicks() {
        return this.threadScaleDownDelayTicks;
    }

    public boolean isWorkStealingEnabled() {
        return this.workStealingEnabled;
    }

    public int getWorkStealingQueueSize() {
        return this.workStealingQueueSize;
    }

    public boolean isCpuAwareThreadSizing() {
        return this.cpuAwareThreadSizing;
    }

    public double getCpuLoadThreshold() {
        return this.cpuLoadThreshold;
    }

    public int getThreadPoolKeepAliveSeconds() {
        return this.threadPoolKeepAliveSeconds;
    }

    public int getDistanceCalculationInterval() {
        return this.distanceCalculationInterval;
    }

    public boolean isDistanceApproximationEnabled() {
        return this.distanceApproximationEnabled;
    }

    public int getDistanceCacheSize() {
        return this.distanceCacheSize;
    }

    public int getItemProcessingIntervalMultiplier() {
        return this.itemProcessingIntervalMultiplier;
    }

    public int getSpatialGridUpdateInterval() {
        return this.spatialGridUpdateInterval;
    }

    public boolean isIncrementalSpatialUpdates() {
        return this.incrementalSpatialUpdates;
    }

    public boolean isEntityCollectionOptimizationsEnabled() {
        return this.entityCollectionOptimizationsEnabled;
    }

    public double getEntitySamplingRate() {
        return this.entitySamplingRate;
    }

    public int getEntityChunkSize() {
        return this.entityChunkSize;
    }

    public int getEntityPoolSize() {
        return this.entityPoolSize;
    }

    public boolean isChunkBasedParallelProcessing() {
        return this.chunkBasedParallelProcessing;
    }

    public int getJniMinimumBatchSize() {
        return this.jniMinimumBatchSize;
    }

    public int getJniMaximumBatchSize() {
        return this.jniMaximumBatchSize;
    }

    public boolean isCombineMultipleOperations() {
        return this.combineMultipleOperations;
    }

    public static PerformanceConfig load() {
        Properties props;
        block9: {
            props = new Properties();
            Path path = Paths.get(DEFAULT_CONFIG_PATH, new String[0]);
            if (Files.exists(path, new LinkOption[0])) {
                try (InputStream in = Files.newInputStream(path, new OpenOption[0]);){
                    props.load(in);
                }
                catch (IOException e) {
                    if (!PerformanceConfig.getLogger().isLoggable(Level.WARNING)) break block9;
                    PerformanceConfig.getLogger().log(Level.WARNING, "Failed to read performance config at {0}, using defaults", path);
                    PerformanceConfig.getLogger().log(Level.FINE, "Exception reading performance config", e);
                }
            }
        }
        boolean enabled = Boolean.parseBoolean(props.getProperty("enabled", "true"));
        int threadpoolSize = PerformanceConfig.parseIntOrDefault(props.getProperty("threadpoolSize"), 4);
        int logIntervalTicks = PerformanceConfig.parseIntOrDefault(props.getProperty("logIntervalTicks"), 100);
        int scanIntervalTicks = PerformanceConfig.parseIntOrDefault(props.getProperty("scanIntervalTicks"), 1);
        double tpsThresholdForAsync = PerformanceConfig.parseDoubleOrDefault(props.getProperty("tpsThresholdForAsync"), 19.0);
        int maxEntitiesToCollect = PerformanceConfig.parseIntOrDefault(props.getProperty("maxEntitiesToCollect"), 20000);
        double entityDistanceCutoff = PerformanceConfig.parseDoubleOrDefault(props.getProperty("entityDistanceCutoff"), 256.0);
        boolean adaptiveThreadPool = Boolean.parseBoolean(props.getProperty("adaptiveThreadPool", "false"));
        int maxThreadpoolSize = PerformanceConfig.parseIntOrDefault(props.getProperty("maxThreadpoolSize"), Math.max(1, Runtime.getRuntime().availableProcessors() - 1));
        String excluded = props.getProperty("excludedEntityTypes", "");
        String[] excludedEntityTypes = excluded.isBlank() ? new String[]{} : excluded.split("\\s*,\\s*");
        int networkExecutorpoolSize = PerformanceConfig.parseIntOrDefault(props.getProperty("networkExecutorpoolSize"), Math.max(1, Runtime.getRuntime().availableProcessors() / 2));
        boolean profilingEnabled = Boolean.parseBoolean(props.getProperty("profilingEnabled", "true"));
        long slowTickThresholdMs = PerformanceConfig.parseLongOrDefault(props.getProperty("slowTickThresholdMs"), 50L);
        int profilingSampleRate = PerformanceConfig.parseIntOrDefault(props.getProperty("profilingSampleRate"), 1);
        boolean broadcastToClient = Boolean.parseBoolean(props.getProperty("broadcastToClient", "false"));
        long maxLogBytes = PerformanceConfig.parseLongOrDefault(props.getProperty("maxLogBytes"), 0xA00000L);
        Builder b = new Builder().enabled(enabled).threadpoolSize(threadpoolSize).logIntervalTicks(logIntervalTicks).scanIntervalTicks(scanIntervalTicks).tpsThresholdForAsync(tpsThresholdForAsync).maxEntitiesToCollect(maxEntitiesToCollect).entityDistanceCutoff(entityDistanceCutoff).maxLogBytes(maxLogBytes).adaptiveThreadPool(adaptiveThreadPool).maxThreadpoolSize(maxThreadpoolSize).excludedEntityTypes(excludedEntityTypes).networkExecutorpoolSize(networkExecutorpoolSize).profilingEnabled(profilingEnabled).slowTickThresholdMs(slowTickThresholdMs).profilingSampleRate(profilingSampleRate);
        b.broadcastToClient(broadcastToClient);
        boolean entityCollectionOptimizationsEnabled = Boolean.parseBoolean(props.getProperty("entityCollectionOptimizationsEnabled", "false"));
        double entitySamplingRate = PerformanceConfig.parseDoubleOrDefault(props.getProperty("entitySamplingRate"), 1.0);
        int entityChunkSize = PerformanceConfig.parseIntOrDefault(props.getProperty("entityChunkSize"), 1000);
        int entityPoolSize = PerformanceConfig.parseIntOrDefault(props.getProperty("entityPoolSize"), 10000);
        boolean chunkBasedParallelProcessing = Boolean.parseBoolean(props.getProperty("chunkBasedParallelProcessing", "false"));
        int jniMinimumBatchSize = PerformanceConfig.parseIntOrDefault(props.getProperty("jniMinimumBatchSize"), 100);
        int jniMaximumBatchSize = PerformanceConfig.parseIntOrDefault(props.getProperty("jniMaximumBatchSize"), 500);
        boolean combineMultipleOperations = Boolean.parseBoolean(props.getProperty("combineMultipleOperations", "true"));
        b.entityCollectionOptimizationsEnabled(entityCollectionOptimizationsEnabled).entitySamplingRate(entitySamplingRate).entityChunkSize(entityChunkSize).entityPoolSize(entityPoolSize).chunkBasedParallelProcessing(chunkBasedParallelProcessing).jniMinimumBatchSize(jniMinimumBatchSize).jniMaximumBatchSize(jniMaximumBatchSize).combineMultipleOperations(combineMultipleOperations);
        return b.build();
    }

    private static long parseLongOrDefault(String v, long def) {
        if (v == null) {
            return def;
        }
        try {
            return Long.parseLong(v.trim());
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    private static int parseIntOrDefault(String v, int def) {
        if (v == null) {
            return def;
        }
        try {
            return Integer.parseInt(v.trim());
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    private static double parseDoubleOrDefault(String v, double def) {
        if (v == null) {
            return def;
        }
        try {
            return Double.parseDouble(v.trim());
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    public String toString() {
        return "PerformanceConfig{enabled=" + this.enabled + ", threadpoolSize=" + this.threadpoolSize + ", logIntervalTicks=" + this.logIntervalTicks + ", scanIntervalTicks=" + this.scanIntervalTicks + ", tpsThresholdForAsync=" + this.tpsThresholdForAsync + ", maxEntitiesToCollect=" + this.maxEntitiesToCollect + ", entityDistanceCutoff=" + this.entityDistanceCutoff + ", maxLogBytes=" + this.maxLogBytes + ", adaptiveThreadPool=" + this.adaptiveThreadPool + ", maxThreadpoolSize=" + this.maxThreadpoolSize + ", excludedEntityTypes=" + Arrays.toString(this.excludedEntityTypes) + ", profilingEnabled=" + this.profilingEnabled + ", slowTickThresholdMs=" + this.slowTickThresholdMs + ", profilingSampleRate=" + this.profilingSampleRate + ", entityCollectionOptimizationsEnabled=" + this.entityCollectionOptimizationsEnabled + ", entitySamplingRate=" + this.entitySamplingRate + ", entityChunkSize=" + this.entityChunkSize + ", entityPoolSize=" + this.entityPoolSize + ", chunkBasedParallelProcessing=" + this.chunkBasedParallelProcessing + ", jniMinimumBatchSize=" + this.jniMinimumBatchSize + ", jniMaximumBatchSize=" + this.jniMaximumBatchSize + ", combineMultipleOperations=" + this.combineMultipleOperations + "}";
    }

    private static class LazyLoggerHolder {
        static final Logger LOGGER = Logger.getLogger(PerformanceConfig.class.getName());

        private LazyLoggerHolder() {
        }
    }

    public static final class Builder {
        private boolean enabled = true;
        private int threadpoolSize = 4;
        private int logIntervalTicks = 100;
        private int scanIntervalTicks = 1;
        private double tpsThresholdForAsync = 19.0;
        private int maxEntitiesToCollect = 20000;
        private double entityDistanceCutoff = 256.0;
        private long maxLogBytes = 0xA00000L;
        private boolean adaptiveThreadPool = false;
        private int maxThreadpoolSize = Math.max(1, Runtime.getRuntime().availableProcessors() - 1);
        private String[] excludedEntityTypes = new String[0];
        private int networkExecutorpoolSize = Math.max(1, Runtime.getRuntime().availableProcessors() / 2);
        private boolean profilingEnabled = true;
        private long slowTickThresholdMs = 50L;
        private int profilingSampleRate = 100;
        private boolean broadcastToClient = false;
        private int minThreadpoolSize = 2;
        private boolean dynamicThreadScaling = true;
        private double threadScaleUpThreshold = 0.8;
        private double threadScaleDownThreshold = 0.3;
        private int threadScaleUpDelayTicks = 100;
        private int threadScaleDownDelayTicks = 200;
        private boolean workStealingEnabled = true;
        private int workStealingQueueSize = 100;
        private boolean cpuAwareThreadSizing;
        private double cpuLoadThreshold;
        private int threadPoolKeepAliveSeconds;
        private int distanceCalculationInterval = 1;
        private boolean distanceApproximationEnabled = true;
        private int distanceCacheSize = 100;
        private int itemProcessingIntervalMultiplier = 1;
        private int spatialGridUpdateInterval = 1;
        private boolean incrementalSpatialUpdates = true;
        private boolean entityCollectionOptimizationsEnabled = false;
        private double entitySamplingRate = 1.0;
        private int entityChunkSize = 1000;
        private int entityPoolSize = 10000;
        private boolean chunkBasedParallelProcessing = false;
        private int jniMinimumBatchSize = 100;
        private int jniMaximumBatchSize = 500;
        private boolean combineMultipleOperations = true;

        public Builder enabled(boolean v) {
            this.enabled = v;
            return this;
        }

        public Builder threadpoolSize(int v) {
            this.threadpoolSize = v;
            return this;
        }

        public Builder logIntervalTicks(int v) {
            this.logIntervalTicks = v;
            return this;
        }

        public Builder scanIntervalTicks(int v) {
            this.scanIntervalTicks = v;
            return this;
        }

        public Builder tpsThresholdForAsync(double v) {
            this.tpsThresholdForAsync = v;
            return this;
        }

        public Builder maxEntitiesToCollect(int v) {
            this.maxEntitiesToCollect = v;
            return this;
        }

        public Builder entityDistanceCutoff(double v) {
            this.entityDistanceCutoff = v;
            return this;
        }

        public Builder maxLogBytes(long v) {
            this.maxLogBytes = v;
            return this;
        }

        public Builder adaptiveThreadPool(boolean v) {
            this.adaptiveThreadPool = v;
            return this;
        }

        public Builder maxThreadpoolSize(int v) {
            this.maxThreadpoolSize = v;
            return this;
        }

        public Builder excludedEntityTypes(String[] v) {
            this.excludedEntityTypes = v == null ? new String[]{} : (String[])v.clone();
            return this;
        }

        public Builder networkExecutorpoolSize(int v) {
            this.networkExecutorpoolSize = v;
            return this;
        }

        public Builder profilingEnabled(boolean v) {
            this.profilingEnabled = v;
            return this;
        }

        public Builder slowTickThresholdMs(long v) {
            this.slowTickThresholdMs = v;
            return this;
        }

        public Builder profilingSampleRate(int v) {
            this.profilingSampleRate = v;
            return this;
        }

        public Builder broadcastToClient(boolean v) {
            this.broadcastToClient = v;
            return this;
        }

        public Builder minThreadpoolSize(int v) {
            this.minThreadpoolSize = v;
            return this;
        }

        public Builder dynamicThreadScaling(boolean v) {
            this.dynamicThreadScaling = v;
            return this;
        }

        public Builder threadScaleUpThreshold(double v) {
            this.threadScaleUpThreshold = v;
            return this;
        }

        public Builder threadScaleDownThreshold(double v) {
            this.threadScaleDownThreshold = v;
            return this;
        }

        public Builder threadScaleUpDelayTicks(int v) {
            this.threadScaleUpDelayTicks = v;
            return this;
        }

        public Builder threadScaleDownDelayTicks(int v) {
            this.threadScaleDownDelayTicks = v;
            return this;
        }

        public Builder workStealingEnabled(boolean v) {
            this.workStealingEnabled = v;
            return this;
        }

        public Builder workStealingQueueSize(int v) {
            this.workStealingQueueSize = v;
            return this;
        }

        public Builder cpuAwareThreadSizing(boolean v) {
            this.cpuAwareThreadSizing = v;
            return this;
        }

        public Builder cpuLoadThreshold(double v) {
            this.cpuLoadThreshold = v;
            return this;
        }

        public Builder threadPoolKeepAliveSeconds(int v) {
            this.threadPoolKeepAliveSeconds = v;
            return this;
        }

        public Builder distanceCalculationInterval(int v) {
            this.distanceCalculationInterval = v;
            return this;
        }

        public Builder distanceApproximationEnabled(boolean v) {
            this.distanceApproximationEnabled = v;
            return this;
        }

        public Builder distanceCacheSize(int v) {
            this.distanceCacheSize = v;
            return this;
        }

        public Builder itemProcessingIntervalMultiplier(int v) {
            this.itemProcessingIntervalMultiplier = v;
            return this;
        }

        public Builder spatialGridUpdateInterval(int v) {
            this.spatialGridUpdateInterval = v;
            return this;
        }

        public Builder incrementalSpatialUpdates(boolean v) {
            this.incrementalSpatialUpdates = v;
            return this;
        }

        public Builder entityCollectionOptimizationsEnabled(boolean v) {
            this.entityCollectionOptimizationsEnabled = v;
            return this;
        }

        public Builder entitySamplingRate(double v) {
            this.entitySamplingRate = v;
            return this;
        }

        public Builder entityChunkSize(int v) {
            this.entityChunkSize = v;
            return this;
        }

        public Builder entityPoolSize(int v) {
            this.entityPoolSize = v;
            return this;
        }

        public Builder chunkBasedParallelProcessing(boolean v) {
            this.chunkBasedParallelProcessing = v;
            return this;
        }

        public Builder jniMinimumBatchSize(int v) {
            this.jniMinimumBatchSize = v;
            return this;
        }

        public Builder jniMaximumBatchSize(int v) {
            this.jniMaximumBatchSize = v;
            return this;
        }

        public Builder combineMultipleOperations(boolean v) {
            this.combineMultipleOperations = v;
            return this;
        }

        public PerformanceConfig build() {
            boolean vEnabled = this.enabled;
            int vThreadpoolSize = Math.max(1, this.threadpoolSize);
            int vLogIntervalTicks = Math.max(1, this.logIntervalTicks);
            int vScanIntervalTicks = Math.max(1, this.scanIntervalTicks);
            double vTpsThresholdForAsync = this.tpsThresholdForAsync;
            int vMaxEntitiesToCollect = Math.max(1, this.maxEntitiesToCollect);
            double vEntityDistanceCutoff = Math.max(0.0, this.entityDistanceCutoff);
            long vMaxLogBytes = Math.max(0L, this.maxLogBytes);
            boolean vAdaptiveThreadPool = this.adaptiveThreadPool;
            int vMaxThreadpoolSize = Math.max(1, this.maxThreadpoolSize);
            String[] vExcludedEntityTypes = this.excludedEntityTypes == null ? new String[]{} : this.excludedEntityTypes;
            int vnetworkExecutorpoolSize = Math.max(1, this.networkExecutorpoolSize);
            boolean vProfilingEnabled = this.profilingEnabled;
            long vSlowTickThresholdMs = Math.max(1L, this.slowTickThresholdMs);
            int vProfilingSampleRate = Math.max(1, this.profilingSampleRate);
            int vDistanceCalculationInterval = Math.max(1, this.distanceCalculationInterval);
            boolean vDistanceApproximationEnabled = this.distanceApproximationEnabled;
            int vDistanceCacheSize = Math.max(100, this.distanceCacheSize);
            int vItemProcessingIntervalMultiplier = Math.max(1, this.itemProcessingIntervalMultiplier);
            int vSpatialGridUpdateInterval = Math.max(1, this.spatialGridUpdateInterval);
            boolean vIncrementalSpatialUpdates = this.incrementalSpatialUpdates;
            boolean vEntityCollectionOptimizationsEnabled = this.entityCollectionOptimizationsEnabled;
            double vEntitySamplingRate = Math.max(0.1, Math.min(1.0, this.entitySamplingRate));
            int vEntityChunkSize = Math.max(100, this.entityChunkSize);
            int vEntityPoolSize = Math.max(1000, this.entityPoolSize);
            boolean vChunkBasedParallelProcessing = this.chunkBasedParallelProcessing;
            int vJniMinimumBatchSize = Math.max(100, this.jniMinimumBatchSize);
            int vJniMaximumBatchSize = Math.max(vJniMinimumBatchSize, this.jniMaximumBatchSize);
            boolean vCombineMultipleOperations = this.combineMultipleOperations;
            Builder validated = new Builder();
            validated.enabled(vEnabled).threadpoolSize(vThreadpoolSize).logIntervalTicks(vLogIntervalTicks).scanIntervalTicks(vScanIntervalTicks).tpsThresholdForAsync(vTpsThresholdForAsync).maxEntitiesToCollect(vMaxEntitiesToCollect).entityDistanceCutoff(vEntityDistanceCutoff).maxLogBytes(vMaxLogBytes).adaptiveThreadPool(vAdaptiveThreadPool).maxThreadpoolSize(vMaxThreadpoolSize).excludedEntityTypes(vExcludedEntityTypes).networkExecutorpoolSize(vnetworkExecutorpoolSize).profilingEnabled(vProfilingEnabled).slowTickThresholdMs(vSlowTickThresholdMs).profilingSampleRate(vProfilingSampleRate);
            validated.distanceCalculationInterval(vDistanceCalculationInterval).distanceApproximationEnabled(vDistanceApproximationEnabled).distanceCacheSize(vDistanceCacheSize).itemProcessingIntervalMultiplier(vItemProcessingIntervalMultiplier).spatialGridUpdateInterval(vSpatialGridUpdateInterval).incrementalSpatialUpdates(vIncrementalSpatialUpdates);
            validated.entityCollectionOptimizationsEnabled(vEntityCollectionOptimizationsEnabled).entitySamplingRate(vEntitySamplingRate).entityChunkSize(vEntityChunkSize).entityPoolSize(vEntityPoolSize).chunkBasedParallelProcessing(vChunkBasedParallelProcessing);
            validated.jniMinimumBatchSize(vJniMinimumBatchSize).jniMaximumBatchSize(vJniMaximumBatchSize).combineMultipleOperations(vCombineMultipleOperations);
            int vMinThreadpoolSize = Math.max(1, this.minThreadpoolSize);
            boolean vDynamicThreadScaling = this.dynamicThreadScaling;
            double vThreadScaleUpThreshold = Math.clamp(0.1, this.threadScaleUpThreshold, 1.0);
            double vThreadScaleDownThreshold = Math.clamp(0.1, this.threadScaleDownThreshold, 1.0);
            int vThreadScaleUpDelayTicks = Math.max(1, this.threadScaleUpDelayTicks);
            int vThreadScaleDownDelayTicks = Math.max(1, this.threadScaleDownDelayTicks);
            boolean vWorkStealingEnabled = this.workStealingEnabled;
            int vWorkStealingQueueSize = Math.max(1, this.workStealingQueueSize);
            boolean vCpuAwareThreadSizing = this.cpuAwareThreadSizing;
            double vCpuLoadThreshold = Math.clamp(0.1, this.cpuLoadThreshold, 1.0);
            int vThreadPoolKeepAliveSeconds = Math.max(1, this.threadPoolKeepAliveSeconds);
            validated.minThreadpoolSize(vMinThreadpoolSize).dynamicThreadScaling(vDynamicThreadScaling).threadScaleUpThreshold(vThreadScaleUpThreshold).threadScaleDownThreshold(vThreadScaleDownThreshold).threadScaleUpDelayTicks(vThreadScaleUpDelayTicks).threadScaleDownDelayTicks(vThreadScaleDownDelayTicks).workStealingEnabled(vWorkStealingEnabled).workStealingQueueSize(vWorkStealingQueueSize).cpuAwareThreadSizing(vCpuAwareThreadSizing).cpuLoadThreshold(vCpuLoadThreshold).threadPoolKeepAliveSeconds(vThreadPoolKeepAliveSeconds);
            return new PerformanceConfig(validated);
        }
    }
}

