/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.protocol.commands;

import com.kneaf.core.chunkstorage.ChunkStorageManager;
import com.kneaf.core.protocol.commands.BaseCommand;
import com.kneaf.core.protocol.core.ProtocolUtils;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;

public class ChunkCacheCommand
extends BaseCommand {
    private static final String COMMAND_NAME = "chunkcache";
    private static final String DESCRIPTION = "Chunk storage cache management commands";
    private static final String USAGE = "/chunkcache <subcommand>";
    private static final int PERMISSION_LEVEL = 4;
    private static final Map<String, ChunkStorageManager> STORAGE_MANAGERS = new ConcurrentHashMap<String, ChunkStorageManager>();
    private static final String ARG_POLICY = "policy";
    private static final String ARG_SIZE = "size";

    public ChunkCacheCommand() {
        super(COMMAND_NAME, DESCRIPTION, 4, USAGE);
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        ChunkCacheCommand mainCommand = new ChunkCacheCommand();
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)COMMAND_NAME).requires(source -> source.hasPermission(4))).then(Commands.literal((String)"Stats").executes(context -> mainCommand.executeStats((CommandContext<CommandSourceStack>)context)))).then(Commands.literal((String)"clear").executes(context -> mainCommand.executeClear((CommandContext<CommandSourceStack>)context)))).then(Commands.literal((String)"maintenance").executes(context -> mainCommand.executeMaintenance((CommandContext<CommandSourceStack>)context)))).then(Commands.literal((String)"backup").executes(context -> mainCommand.executeBackup((CommandContext<CommandSourceStack>)context)))).then(((LiteralArgumentBuilder)Commands.literal((String)"config").then(Commands.literal((String)"capacity").then(Commands.argument((String)ARG_SIZE, (ArgumentType)IntegerArgumentType.integer((int)1, (int)10000)).executes(context -> mainCommand.executeSetCapacity((CommandContext<CommandSourceStack>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)ARG_SIZE)))))).then(Commands.literal((String)ARG_POLICY).then(Commands.argument((String)ARG_POLICY, (ArgumentType)StringArgumentType.string()).executes(context -> mainCommand.executeSetEvictionPolicy((CommandContext<CommandSourceStack>)context, StringArgumentType.getString((CommandContext)context, (String)ARG_POLICY))))))).then(Commands.literal((String)"help").executes(context -> mainCommand.executeHelp((CommandContext<CommandSourceStack>)context)));
        dispatcher.register(builder);
    }

    @Override
    protected int executeCommand(CommandContext<CommandSourceStack> context) throws Exception {
        throw new UnsupportedOperationException("Use specific execute methods for subcommands");
    }

    public static void registerStorageManager(String worldName, ChunkStorageManager manager) {
        if (worldName != null && manager != null) {
            STORAGE_MANAGERS.put(worldName, manager);
            System.out.println("Registered ChunkStorageManager for world '" + worldName + "' in command system");
        }
    }

    public static void unregisterStorageManager(String worldName) {
        ChunkStorageManager removed;
        if (worldName != null && (removed = STORAGE_MANAGERS.remove(worldName)) != null) {
            System.out.println("Unregistered ChunkStorageManager for world '" + worldName + "' from command system");
        }
    }

    private int executeStats(CommandContext<CommandSourceStack> context) {
        if (STORAGE_MANAGERS.isEmpty()) {
            this.sendFailure(context, "\u00a7cNo chunk storage managers registered");
            return 0;
        }
        this.sendSuccess(context, "\u00a76=== Chunk Storage Statistics ===");
        for (Map.Entry<String, ChunkStorageManager> entry : STORAGE_MANAGERS.entrySet()) {
            String worldName = entry.getKey();
            ChunkStorageManager manager = entry.getValue();
            ChunkStorageManager.StorageStats Stats = manager.getStats();
            if (Stats.isEnabled()) {
                String pattern = "\u00a7bWorld: \u00a7f%s\n\u00a7bStatus: \u00a7a%s\n\u00a7bDatabase Chunks: \u00a7f%d\n\u00a7bCached Chunks: \u00a7f%d\n\u00a7bRead Latency: \u00a7f%d ms\n\u00a7bWrite Latency: \u00a7f%d ms\n\u00a7bCache Hit Rate: \u00a7f%.2f%%\n\u00a7bOverall Hit Rate: \u00a7f%.2f%%\n";
                this.sendSuccessFormatted(context, "\u00a7bWorld: \u00a7f%s\n\u00a7bStatus: \u00a7a%s\n\u00a7bDatabase Chunks: \u00a7f%d\n\u00a7bCached Chunks: \u00a7f%d\n\u00a7bRead Latency: \u00a7f%d ms\n\u00a7bWrite Latency: \u00a7f%d ms\n\u00a7bCache Hit Rate: \u00a7f%.2f%%\n\u00a7bOverall Hit Rate: \u00a7f%.2f%%\n", worldName, Stats.getStatus(), Stats.getTotalChunksInDb(), Stats.getCachedChunks(), Stats.getAvgReadLatencyMs(), Stats.getAvgWriteLatencyMs(), Stats.getCacheHitRate() * 100.0, Stats.getOverallHitRate() * 100.0);
                continue;
            }
            this.sendSuccessFormatted(context, "\u00a7bWorld: \u00a7f%s \u00a77[DISABLED]", worldName);
        }
        this.getLogger().logMetrics("chunk_Stats", Map.of("worlds_count", STORAGE_MANAGERS.size()), ProtocolUtils.generateTraceId());
        return 1;
    }

    private int executeClear(CommandContext<CommandSourceStack> context) {
        int clearedCount = 0;
        for (Map.Entry<String, ChunkStorageManager> entry : STORAGE_MANAGERS.entrySet()) {
            try {
                entry.getValue().clearCache();
                ++clearedCount;
            }
            catch (Exception e) {
                this.getLogger().logError("clear_cache_error", e, ProtocolUtils.generateTraceId(), Map.of("world", entry.getKey()));
            }
        }
        this.sendSuccessFormatted(context, "\u00a7aCleared caches for \u00a7f%d \u00a7aworlds", clearedCount);
        this.getLogger().logMetrics("clear_cache", Map.of("worlds_cleared", clearedCount), ProtocolUtils.generateTraceId());
        return 1;
    }

    private int executeMaintenance(CommandContext<CommandSourceStack> context) {
        this.sendSuccess(context, "\u00a76Performing storage maintenance...");
        int maintainedCount = 0;
        for (Map.Entry<String, ChunkStorageManager> entry : STORAGE_MANAGERS.entrySet()) {
            String worldName = entry.getKey();
            ChunkStorageManager manager = entry.getValue();
            try {
                manager.performMaintenance();
                ++maintainedCount;
                this.sendSuccessFormatted(context, "\u00a7aMaintenance completed for world '%s'", worldName);
            }
            catch (Exception e) {
                this.sendSuccessFormatted(context, "\u00a7cMaintenance failed for world '%s': %s", worldName, e.getMessage());
                this.getLogger().logError("maintenance", e, ProtocolUtils.generateTraceId(), Map.of("world", worldName));
            }
        }
        this.sendSuccessFormatted(context, "\u00a7aMaintenance completed for \u00a7f%d \u00a7aworlds", maintainedCount);
        this.getLogger().logMetrics("maintenance", Map.of("worlds_maintained", maintainedCount), ProtocolUtils.generateTraceId());
        return 1;
    }

    private int executeBackup(CommandContext<CommandSourceStack> context) {
        this.sendSuccess(context, "\u00a76Creating backups...");
        int backupCount = 0;
        for (Map.Entry<String, ChunkStorageManager> entry : STORAGE_MANAGERS.entrySet()) {
            String worldName = entry.getKey();
            ChunkStorageManager manager = entry.getValue();
            try {
                String backupPath = String.format("backups/chunkstorage/%s_%d", worldName, System.currentTimeMillis());
                manager.createBackup(backupPath);
                ++backupCount;
                this.sendSuccessFormatted(context, "\u00a7aBackup created for world '%s' at '%s'", worldName, backupPath);
            }
            catch (Exception e) {
                this.sendSuccessFormatted(context, "\u00a7cBackup failed for world '%s': %s", worldName, e.getMessage());
                this.getLogger().logError("backup", e, ProtocolUtils.generateTraceId(), Map.of("world", worldName));
            }
        }
        this.sendSuccessFormatted(context, "\u00a7aBackups created for \u00a7f%d \u00a7aworlds", backupCount);
        this.getLogger().logMetrics("backup", Map.of("backups_created", backupCount), ProtocolUtils.generateTraceId());
        return 1;
    }

    private int executeSetCapacity(CommandContext<CommandSourceStack> context, int capacity) {
        int applied = 0;
        for (Map.Entry<String, ChunkStorageManager> entry : STORAGE_MANAGERS.entrySet()) {
            try {
                entry.getValue().setCacheCapacity(capacity);
                ++applied;
            }
            catch (Exception e) {
                this.getLogger().logError("set_capacity_error", e, ProtocolUtils.generateTraceId(), Map.of("world", entry.getKey()));
            }
        }
        this.sendSuccessFormatted(context, "\u00a7aCache capacity set to \u00a7f%d \u00a7afor %d worlds", capacity, applied);
        this.getLogger().logMetrics("set_capacity", Map.of("new_capacity", capacity, "applied", applied), ProtocolUtils.generateTraceId());
        return 1;
    }

    private int executeSetEvictionPolicy(CommandContext<CommandSourceStack> context, String policy) {
        if (!(policy.equalsIgnoreCase("LRU") || policy.equalsIgnoreCase("Distance") || policy.equalsIgnoreCase("Hybrid"))) {
            this.sendSuccessFormatted(context, "\u00a7cInvalid eviction policy '%s'. Valid policies: LRU, Distance, Hybrid", policy);
            return 0;
        }
        int applied = 0;
        for (Map.Entry<String, ChunkStorageManager> entry : STORAGE_MANAGERS.entrySet()) {
            try {
                entry.getValue().setEvictionPolicy(policy);
                ++applied;
            }
            catch (Exception e) {
                this.getLogger().logError("set_eviction_policy_error", e, ProtocolUtils.generateTraceId(), Map.of("world", entry.getKey()));
            }
        }
        this.sendSuccessFormatted(context, "\u00a7aEviction policy set to \u00a7f%s \u00a7afor %d worlds", policy, applied);
        this.getLogger().logMetrics("set_eviction_policy", Map.of("new_policy", policy.equalsIgnoreCase("LRU") ? 1 : (policy.equalsIgnoreCase("Distance") ? 2 : 3), "applied", applied), ProtocolUtils.generateTraceId());
        return 1;
    }

    private int executeHelp(CommandContext<CommandSourceStack> context) {
        String helpMessage = this.createHelpMessage() + "\n\u00a7bSubcommands:\n\u00a7b  Stats \u00a77- Show storage statistics\n\u00a7b  clear \u00a77- Clear all caches\n\u00a7b  maintenance \u00a77- Perform storage maintenance\n\u00a7b  backup \u00a77- Create backups\n\u00a7b  config capacity <size> \u00a77- Set cache capacity\n\u00a7b  config policy <LRU|Distance|Hybrid> \u00a77- Set eviction policy\n\u00a7b  help \u00a77- Show this help message";
        this.sendSuccess(context, helpMessage);
        return 1;
    }

    @Override
    public boolean validateArguments(CommandContext<CommandSourceStack> context) {
        return true;
    }
}

