/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.protocol.commands;

import com.kneaf.core.protocol.core.CommandExecutor;
import com.kneaf.core.protocol.core.ProtocolLogger;
import com.kneaf.core.protocol.core.ProtocolUtils;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;

public class CommandRegistry {
    private final Map<String, RegisteredCommand> commands = new ConcurrentHashMap<String, RegisteredCommand>();
    private final ProtocolLogger logger;
    private final String registryName;

    public CommandRegistry(String registryName, ProtocolLogger logger) {
        this.registryName = registryName;
        this.logger = logger;
    }

    public void registerCommand(CommandExecutor command) {
        String commandName = command.getCommandName();
        if (this.commands.containsKey(commandName)) {
            throw new IllegalArgumentException("Command '" + commandName + "' is already registered");
        }
        RegisteredCommand registeredCommand = new RegisteredCommand(command);
        this.commands.put(commandName, registeredCommand);
        String traceId = ProtocolUtils.generateTraceId();
        this.logger.logOperationStart("register_command", "registry", traceId, Map.of("command", commandName, "registry", this.registryName));
    }

    public void registerWithDispatcher(CommandDispatcher<CommandSourceStack> dispatcher) {
        String traceId = ProtocolUtils.generateTraceId();
        this.logger.logOperationStart("register_dispatcher", "registry", traceId, Map.of("registry", this.registryName, "command_count", this.commands.size()));
        try {
            for (RegisteredCommand registeredCommand : this.commands.values()) {
                CommandExecutor command = registeredCommand.getCommand();
                String commandName = command.getCommandName();
                LiteralArgumentBuilder builder = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)commandName).requires(source -> source.hasPermission(command.getRequiredPermissionLevel()))).executes(context -> this.executeCommand(command, (CommandContext<CommandSourceStack>)context));
                dispatcher.register(builder);
                this.logger.logOperationComplete("register_command", "registry", traceId, 0L, true, Map.of("command", commandName));
            }
            this.logger.logOperationComplete("register_dispatcher", "registry", traceId, 0L, true, Map.of("registered_commands", this.commands.size()));
        }
        catch (Exception e) {
            this.logger.logError("register_dispatcher", e, traceId, Map.of("registry", this.registryName));
            throw new RuntimeException("Failed to register commands with dispatcher", e);
        }
    }

    private int executeCommand(CommandExecutor command, CommandContext<CommandSourceStack> context) {
        String traceId = ProtocolUtils.generateTraceId();
        String commandName = command.getCommandName();
        long startTime = System.currentTimeMillis();
        try {
            this.logger.logOperationStart("execute_command", "command", traceId, Map.of("command", commandName, "executor", this.registryName));
            if (!command.validateArguments(context)) {
                String errorMsg = "Invalid arguments for command: " + commandName;
                this.logger.logWarning("execute_command", errorMsg, traceId, Map.of("command", commandName));
                return command.handleError(context, new IllegalArgumentException(errorMsg));
            }
            int result = command.execute(context);
            long duration = System.currentTimeMillis() - startTime;
            this.logger.logOperationComplete("execute_command", "command", traceId, duration, result > 0, Map.of("command", commandName, "result", result));
            return result;
        }
        catch (Exception e) {
            long duration = System.currentTimeMillis() - startTime;
            this.logger.logError("execute_command", e, traceId, Map.of("command", commandName, "duration", duration));
            return command.handleError(context, e);
        }
    }

    public CommandExecutor getCommand(String commandName) {
        RegisteredCommand registered = this.commands.get(commandName);
        return registered != null ? registered.getCommand() : null;
    }

    public boolean isCommandRegistered(String commandName) {
        return this.commands.containsKey(commandName);
    }

    public String[] getRegisteredCommandNames() {
        return this.commands.keySet().toArray(new String[0]);
    }

    public Map<String, Object> getStatistics() {
        HashMap<String, Object> Stats = new HashMap<String, Object>();
        Stats.put("registry_name", this.registryName);
        Stats.put("total_commands", this.commands.size());
        HashMap<String, Map<String, Object>> commandStats = new HashMap<String, Map<String, Object>>();
        for (Map.Entry<String, RegisteredCommand> entry : this.commands.entrySet()) {
            commandStats.put(entry.getKey(), entry.getValue().getStatistics());
        }
        Stats.put("commands", commandStats);
        return Stats;
    }

    public void clear() {
        String traceId = ProtocolUtils.generateTraceId();
        this.logger.logOperationStart("clear_registry", "registry", traceId, Map.of("registry", this.registryName, "commands_cleared", this.commands.size()));
        this.commands.clear();
        this.logger.logOperationComplete("clear_registry", "registry", traceId, 0L, true, Map.of("registry", this.registryName));
    }

    private static class RegisteredCommand {
        private final CommandExecutor command;
        private long executionCount = 0L;
        private long totalExecutionTime = 0L;
        private long lastExecutionTime = 0L;
        private long successCount = 0L;
        private long errorCount = 0L;

        public RegisteredCommand(CommandExecutor command) {
            this.command = command;
        }

        public CommandExecutor getCommand() {
            return this.command;
        }

        public synchronized Map<String, Object> getStatistics() {
            return Map.of("execution_count", this.executionCount, "success_count", this.successCount, "error_count", this.errorCount, "total_execution_time", this.totalExecutionTime, "average_execution_time", this.executionCount > 0L ? this.totalExecutionTime / this.executionCount : 0L, "last_execution_time", this.lastExecutionTime, "success_rate", this.executionCount > 0L ? (double)this.successCount / (double)this.executionCount : 0.0);
        }
    }
}

