/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.protocol.core;

import com.google.gson.Gson;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Map;
import java.util.UUID;

public final class ProtocolUtils {
    private static final Gson GSON = new Gson();

    private ProtocolUtils() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static String generateTraceId() {
        return UUID.randomUUID().toString();
    }

    public static Map<String, Object> parseJson(String json) throws JsonSyntaxException {
        return (Map)GSON.fromJson(json, Map.class);
    }

    public static String toJson(Object obj) {
        return GSON.toJson(obj);
    }

    public static boolean isValidJson(String json) {
        try {
            JsonParser.parseString((String)json);
            return true;
        }
        catch (JsonSyntaxException e) {
            return false;
        }
    }

    public static String calculateHash(byte[] data) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        byte[] hash = digest.digest(data);
        return Base64.getEncoder().encodeToString(hash);
    }

    public static String calculateHash(String data) throws NoSuchAlgorithmException {
        return ProtocolUtils.calculateHash(data.getBytes(StandardCharsets.UTF_8));
    }

    public static byte[] toByteArray(ByteBuffer buffer) {
        byte[] bytes = new byte[buffer.remaining()];
        buffer.get(bytes);
        return bytes;
    }

    public static ByteBuffer toByteBuffer(byte[] bytes) {
        return ByteBuffer.wrap(bytes);
    }

    public static int getSizeInBytes(Object data) {
        if (data instanceof String) {
            return ((String)data).getBytes(StandardCharsets.UTF_8).length;
        }
        if (data instanceof byte[]) {
            return ((byte[])data).length;
        }
        if (data instanceof ByteBuffer) {
            return ((ByteBuffer)data).remaining();
        }
        return ProtocolUtils.toJson(data).getBytes(StandardCharsets.UTF_8).length;
    }

    public static boolean exceedsSizeLimit(Object data, int maxSize) {
        return ProtocolUtils.getSizeInBytes(data) > maxSize;
    }

    public static String sanitizeString(String input) {
        if (input == null) {
            return null;
        }
        return input.replaceAll("[\\p{Cntrl}&&[^\r\n\t]]", "").trim();
    }

    public static String truncateString(String input, int maxLength) {
        if (input == null || input.length() <= maxLength) {
            return input;
        }
        return input.substring(0, maxLength);
    }

    public static Map<String, Object> createErrorResponse(int errorCode, String errorMessage, String traceId) {
        return Map.of("success", false, "errorCode", errorCode, "errorMessage", errorMessage, "traceId", traceId, "timestamp", System.currentTimeMillis());
    }

    public static Map<String, Object> createSuccessResponse(Object data, String traceId) {
        return Map.of("success", true, "data", data, "traceId", traceId, "timestamp", System.currentTimeMillis());
    }

    public static String detectFormat(String contentType, Object data) {
        if (contentType != null) {
            if (contentType.contains("json")) {
                return "json";
            }
            if (contentType.contains("xml")) {
                return "xml";
            }
            if (contentType.contains("protobuf")) {
                return "protobuf";
            }
            if (contentType.contains("octet-stream")) {
                return "binary";
            }
        }
        if (data instanceof String) {
            String str = (String)data;
            if (ProtocolUtils.isValidJson(str)) {
                return "json";
            }
        } else if (data instanceof byte[] || data instanceof ByteBuffer) {
            return "binary";
        }
        return "json";
    }
}

