/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.binary.entity;

import com.kneaf.core.binary.core.BaseBinarySerializer;
import com.kneaf.core.binary.core.SerializationUtils;
import com.kneaf.core.binary.entity.EntityInput;
import com.kneaf.core.binary.utils.BufferPool;
import com.kneaf.core.binary.utils.SchemaValidator;
import com.kneaf.core.binary.utils.SerializationException;
import com.kneaf.core.data.entity.EntityData;
import com.kneaf.core.data.entity.PlayerData;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class EntitySerializer
extends BaseBinarySerializer<EntityInput, List<Long>> {
    public EntitySerializer() {
        super("entity", "1.0.0");
    }

    public EntitySerializer(BufferPool bufferPool) {
        super("entity", "1.0.0", bufferPool);
    }

    public EntitySerializer(BufferPool bufferPool, SchemaValidator<EntityInput> validator) {
        super("entity", "1.0.0", bufferPool, validator);
    }

    @Override
    protected void serializeToBufferInternal(EntityInput input, ByteBuffer buffer) throws SerializationException {
        if (input == null) {
            throw new SerializationException("Entity input cannot be null", this.getSerializerType(), "serializeToBufferInternal");
        }
        try {
            buffer.putLong(input.tickCount);
            List<EntityData> entities = input.entities;
            buffer.putInt(entities.size());
            for (EntityData entity : entities) {
                this.writeEntityData(buffer, entity);
            }
            List<PlayerData> players = input.players;
            buffer.putInt(players.size());
            for (PlayerData player : players) {
                this.writePlayerData(buffer, player);
            }
            this.writeEntityConfig(buffer);
        }
        catch (Exception e) {
            throw new SerializationException("Failed to serialize entity input", e, this.getSerializerType(), "serializeToBufferInternal", buffer.array());
        }
    }

    @Override
    protected List<Long> deserializeFromBufferInternal(ByteBuffer buffer) throws SerializationException {
        try {
            buffer.getLong();
            int entityCount = buffer.getInt();
            if (entityCount < 0 || entityCount > 100000) {
                throw new SerializationException("Invalid entity count: " + entityCount, this.getSerializerType(), "deserializeFromBufferInternal");
            }
            ArrayList<Long> entitiesToTick = new ArrayList<Long>(Math.min(entityCount, 256));
            float CLOSE_RADIUS = 16.0f;
            float MEDIUM_RADIUS = 32.0f;
            for (int i = 0; i < entityCount; ++i) {
                String t;
                long id = buffer.getLong();
                buffer.getFloat();
                buffer.getFloat();
                buffer.getFloat();
                float distance = buffer.getFloat();
                boolean isBlockEntity = SerializationUtils.readBoolean(buffer);
                String type = SerializationUtils.readString(buffer);
                if (distance < 0.0f || distance > 10000.0f || type == null || type.isEmpty() || "player".equalsIgnoreCase(type) || isBlockEntity) continue;
                boolean shouldTick = false;
                if (distance <= 16.0f) {
                    shouldTick = true;
                } else if (distance <= 32.0f && ((t = type.toLowerCase()).contains("mob") || t.contains("villager") || t.contains("monster"))) {
                    shouldTick = true;
                }
                if (!shouldTick) continue;
                entitiesToTick.add(id);
            }
            int playerCount = buffer.getInt();
            if (playerCount < 0 || playerCount > 100000) {
                throw new SerializationException("Invalid player count: " + playerCount, this.getSerializerType(), "deserializeFromBufferInternal");
            }
            for (int i = 0; i < playerCount; ++i) {
                this.skipPlayerData(buffer);
            }
            this.skipEntityConfig(buffer);
            return entitiesToTick;
        }
        catch (SerializationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SerializationException("Failed to deserialize entity result", e, this.getSerializerType(), "deserializeFromBufferInternal", null);
        }
    }

    private void writeEntityData(ByteBuffer buffer, EntityData entity) {
        buffer.putLong(entity.getId());
        buffer.putFloat((float)entity.getX());
        buffer.putFloat((float)entity.getY());
        buffer.putFloat((float)entity.getZ());
        buffer.putFloat((float)entity.getDistance());
        SerializationUtils.writeBoolean(buffer, entity.isBlockEntity());
        SerializationUtils.writeString(buffer, entity.getType());
    }

    private void writePlayerData(ByteBuffer buffer, PlayerData player) {
        buffer.putLong(player.getId());
        buffer.putFloat((float)player.getX());
        buffer.putFloat((float)player.getY());
        buffer.putFloat((float)player.getZ());
    }

    private void writeEntityConfig(ByteBuffer buffer) {
        buffer.putFloat(16.0f);
        buffer.putFloat(32.0f);
        buffer.putFloat(1.0f);
        buffer.putFloat(0.5f);
        buffer.putFloat(0.1f);
    }

    private void skipPlayerData(ByteBuffer buffer) {
        buffer.position(buffer.position() + 8 + 4 + 4 + 4);
    }

    private void skipEntityConfig(ByteBuffer buffer) {
        buffer.position(buffer.position() + 20);
    }
}

