/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.exceptions.processing;

import com.kneaf.core.exceptions.core.BaseKneafException;
import com.kneaf.core.exceptions.utils.ExceptionContext;
import com.kneaf.core.exceptions.utils.ExceptionSeverity;

public class OptimizedProcessingException
extends BaseKneafException {
    private final ProcessingErrorType processingErrorType;
    private final String operation;
    private final Object processingContext;

    private OptimizedProcessingException(Builder builder) {
        super(builder);
        this.processingErrorType = builder.processingErrorType;
        this.operation = builder.operation;
        this.processingContext = builder.processingContext;
    }

    public ProcessingErrorType getProcessingErrorType() {
        return this.processingErrorType;
    }

    public String getOperation() {
        return this.operation;
    }

    public Object getProcessingContext() {
        return this.processingContext;
    }

    @Override
    public OptimizedProcessingException withContext(ExceptionContext context) {
        return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)new Builder().message(this.getMessage())).cause(this.getCause())).errorCode(this.getErrorCode())).severity(this.getSeverity())).context(context)).suggestion(this.getSuggestion())).logged(this.isLogged())).processingErrorType(this.processingErrorType).operation(this.operation).processingContext(this.processingContext).build();
    }

    @Override
    public OptimizedProcessingException withSuggestion(String suggestion) {
        return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)new Builder().message(this.getMessage())).cause(this.getCause())).errorCode(this.getErrorCode())).severity(this.getSeverity())).context(this.getContext())).suggestion(suggestion)).logged(this.isLogged())).processingErrorType(this.processingErrorType).operation(this.operation).processingContext(this.processingContext).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static OptimizedProcessingException batchProcessingError(String operation, String message) {
        return ((Builder)((Builder)((Builder)OptimizedProcessingException.builder().processingErrorType(ProcessingErrorType.BATCH_PROCESSING_ERROR).operation(operation).message(message)).severity(ExceptionSeverity.ERROR)).suggestion("Check application logs for detailed error information")).build();
    }

    public static OptimizedProcessingException batchProcessingError(String operation, String message, Throwable cause) {
        return ((Builder)((Builder)((Builder)((Builder)OptimizedProcessingException.builder().processingErrorType(ProcessingErrorType.BATCH_PROCESSING_ERROR).operation(operation).message(message)).cause(cause)).severity(ExceptionSeverity.ERROR)).suggestion("Check application logs for detailed error information")).build();
    }

    public static OptimizedProcessingException memoryAllocationError(String operation, String message, Object context) {
        return ((Builder)((Builder)((Builder)OptimizedProcessingException.builder().processingErrorType(ProcessingErrorType.MEMORY_ALLOCATION_ERROR).operation(operation).message(message)).processingContext(context).severity(ExceptionSeverity.CRITICAL)).suggestion("Check system resources (memory, disk space, network)")).build();
    }

    public static OptimizedProcessingException nativeLibraryError(String operation, String message, Throwable cause) {
        return ((Builder)((Builder)((Builder)((Builder)OptimizedProcessingException.builder().processingErrorType(ProcessingErrorType.NATIVE_LIBRARY_ERROR).operation(operation).message(message)).cause(cause)).severity(ExceptionSeverity.ERROR)).suggestion("Check external dependencies and services")).build();
    }

    public static OptimizedProcessingException predictiveLoadingError(String operation, String message, Object context) {
        return ((Builder)((Builder)((Builder)OptimizedProcessingException.builder().processingErrorType(ProcessingErrorType.PREDICTIVE_LOADING_ERROR).operation(operation).message(message)).processingContext(context).severity(ExceptionSeverity.WARNING)).suggestion("Check application logs for detailed error information")).build();
    }

    public static OptimizedProcessingException bufferPoolError(String operation, String message) {
        return ((Builder)((Builder)((Builder)OptimizedProcessingException.builder().processingErrorType(ProcessingErrorType.BUFFER_POOL_ERROR).operation(operation).message(message)).severity(ExceptionSeverity.ERROR)).suggestion("Check system resources (memory, disk space, network)")).build();
    }

    public static OptimizedProcessingException workerExecutionError(String operation, String message, Throwable cause) {
        return ((Builder)((Builder)((Builder)((Builder)OptimizedProcessingException.builder().processingErrorType(ProcessingErrorType.WORKER_EXECUTION_ERROR).operation(operation).message(message)).cause(cause)).severity(ExceptionSeverity.ERROR)).suggestion("Check application logs for detailed error information")).build();
    }

    public static OptimizedProcessingException timeoutError(String operation, String message, long timeoutMs) {
        return ((Builder)((Builder)((Builder)OptimizedProcessingException.builder().processingErrorType(ProcessingErrorType.TIMEOUT_ERROR).operation(operation).message(String.format("%s (timeout: %d ms)", message, timeoutMs))).severity(ExceptionSeverity.ERROR)).suggestion("Check system resources (memory, disk space, network)")).build();
    }

    public static OptimizedProcessingException resourceExhaustionError(String operation, String resourceType, Object context) {
        return ((Builder)((Builder)((Builder)OptimizedProcessingException.builder().processingErrorType(ProcessingErrorType.RESOURCE_EXHAUSTION_ERROR).operation(operation).message(String.format("Resource exhaustion: %s", resourceType))).processingContext(context).severity(ExceptionSeverity.CRITICAL)).suggestion("Check system resources (memory, disk space, network)")).build();
    }

    public static class Builder
    extends BaseKneafException.Builder<Builder> {
        private ProcessingErrorType processingErrorType;
        private String operation;
        private Object processingContext;

        @Override
        protected Builder self() {
            return this;
        }

        public Builder processingErrorType(ProcessingErrorType processingErrorType) {
            this.processingErrorType = processingErrorType;
            return this;
        }

        public Builder operation(String operation) {
            this.operation = operation;
            return this;
        }

        public Builder processingContext(Object processingContext) {
            this.processingContext = processingContext;
            return this;
        }

        @Override
        protected void validate() {
            super.validate();
            if (this.processingErrorType == null) {
                throw new IllegalArgumentException("Processing error type cannot be null");
            }
        }

        public OptimizedProcessingException build() {
            this.validate();
            if (this.errorCode == null && this.processingErrorType != null) {
                this.errorCode = this.processingErrorType.getErrorCode();
            }
            if (this.severity == null) {
                this.severity = ExceptionSeverity.ERROR;
            }
            return new OptimizedProcessingException(this);
        }
    }

    public static enum ProcessingErrorType {
        BATCH_PROCESSING_ERROR("PROC001", "Batch processing failed"),
        MEMORY_ALLOCATION_ERROR("PROC002", "Memory allocation failed"),
        NATIVE_LIBRARY_ERROR("NAT005", "Native library operation failed"),
        PREDICTIVE_LOADING_ERROR("PROC005", "Predictive loading failed"),
        BUFFER_POOL_ERROR("PROC006", "Buffer pool operation failed"),
        WORKER_EXECUTION_ERROR("PROC007", "Worker execution failed"),
        TIMEOUT_ERROR("PROC003", "Operation timed out"),
        RESOURCE_EXHAUSTION_ERROR("PROC004", "Resource exhaustion detected");

        private final String errorCode;
        private final String description;

        private ProcessingErrorType(String errorCode, String description) {
            this.errorCode = errorCode;
            this.description = description;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

