/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.exceptions.utils;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class ExceptionContext {
    private final Map<String, Object> contextData;
    private final String operation;
    private final String component;
    private final String method;
    private final int lineNumber;
    private final long timestamp;

    private ExceptionContext(Builder builder) {
        this.contextData = Collections.unmodifiableMap(new HashMap<String, Object>(builder.contextData));
        this.operation = builder.operation;
        this.component = builder.component;
        this.method = builder.method;
        this.lineNumber = builder.lineNumber;
        this.timestamp = builder.timestamp;
    }

    public Map<String, Object> getContextData() {
        return this.contextData;
    }

    public Object getValue(String key) {
        return this.contextData.get(key);
    }

    public String getOperation() {
        return this.operation;
    }

    public String getComponent() {
        return this.component;
    }

    public String getMethod() {
        return this.method;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ExceptionContext basic(String operation, String component) {
        return ExceptionContext.builder().operation(operation).component(component).build();
    }

    public static ExceptionContext forMethod(String operation, String component, String method, int lineNumber) {
        return ExceptionContext.builder().operation(operation).component(component).method(method).lineNumber(lineNumber).build();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ExceptionContext{");
        if (this.operation != null) {
            sb.append("operation='").append(this.operation).append('\'');
        }
        if (this.component != null) {
            sb.append(", component='").append(this.component).append('\'');
        }
        if (this.method != null) {
            sb.append(", method='").append(this.method).append('\'');
        }
        if (this.lineNumber > 0) {
            sb.append(", lineNumber=").append(this.lineNumber);
        }
        if (!this.contextData.isEmpty()) {
            sb.append(", contextData=").append(this.contextData);
        }
        sb.append(", timestamp=").append(this.timestamp);
        sb.append('}');
        return sb.toString();
    }

    public static class Builder {
        private Map<String, Object> contextData = new HashMap<String, Object>();
        private String operation;
        private String component;
        private String method;
        private int lineNumber = -1;
        private long timestamp = System.currentTimeMillis();

        public Builder operation(String operation) {
            this.operation = operation;
            return this;
        }

        public Builder component(String component) {
            this.component = component;
            return this;
        }

        public Builder method(String method) {
            this.method = method;
            return this;
        }

        public Builder lineNumber(int lineNumber) {
            this.lineNumber = lineNumber;
            return this;
        }

        public Builder timestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder addContext(String key, Object value) {
            this.contextData.put(key, value);
            return this;
        }

        public Builder addAllContext(Map<String, Object> context) {
            this.contextData.putAll(context);
            return this;
        }

        public ExceptionContext build() {
            return new ExceptionContext(this);
        }
    }
}

