/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.performance.logging;

import com.kneaf.core.performance.monitoring.PerformanceConfig;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class PerformanceLoggerUtils {
    private static final Logger LOGGER = PerformanceConfig.getLogger();

    private PerformanceLoggerUtils() {
    }

    public static void logSlowTickWarning(String component, long tickMs, long thresholdMs) {
        if (LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.log(Level.WARNING, "[PERF_WARNING] Slow {0} tick detected: {1}ms (threshold: {2}ms)", new Object[]{component, tickMs, thresholdMs});
        }
    }

    public static void logOptimizationSummary(String component, String operation, int itemsProcessed, long durationMs, Double improvement) {
        if (LOGGER.isLoggable(Level.INFO)) {
            StringBuilder message = new StringBuilder().append("[PERF_SUMMARY] ").append(component).append(" optimization summary - ").append(operation).append(": processed ").append(itemsProcessed).append(" items in ").append(durationMs).append("ms");
            if (improvement != null) {
                message.append(" (").append(improvement).append("% improvement)");
            }
            LOGGER.log(Level.INFO, message.toString());
        }
    }

    public static void logThresholdAlert(String component, String metricName, double value, double threshold) {
        if (LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.log(Level.WARNING, "[PERF_ALERT] {0} threshold crossed: {1} = {2} (exceeded {3})", new Object[]{component, metricName, value, threshold});
        }
    }

    public static void logMemoryPressureWarning(String component, int pressureLevel, int warningThreshold) {
        if (LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.log(Level.WARNING, "[MEM_WARNING] {0} memory pressure: {1}% (warning threshold: {2}%)", new Object[]{component, pressureLevel, warningThreshold});
        }
    }

    public static boolean isLoggingEnabled(Level level) {
        return LOGGER.isLoggable(level);
    }
}

