/*
 * Decompiled with CFR 0.152.
 */
package com.kneaf.core.binary;

import com.kneaf.core.data.BlockEntityData;
import com.kneaf.core.data.EntityData;
import com.kneaf.core.data.ItemEntityData;
import com.kneaf.core.data.MobData;
import com.kneaf.core.data.PlayerData;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public final class ManualSerializers {
    private ManualSerializers() {
    }

    public static ByteBuffer serializeEntityInput(long tickCount, List<EntityData> entities, List<PlayerData> players) {
        float[] cfg;
        int baseSize = 36;
        int entitySize = 0;
        for (EntityData e : entities) {
            entitySize += 29;
            String entityType = e.entityType();
            if (entityType == null) continue;
            entitySize += entityType.getBytes(StandardCharsets.UTF_8).length;
        }
        int playerSize = players.size() * 20;
        int totalSize = baseSize + entitySize + playerSize;
        ByteBuffer buf = ByteBuffer.allocateDirect(totalSize).order(ByteOrder.LITTLE_ENDIAN);
        buf.putLong(tickCount);
        buf.putInt(entities.size());
        for (EntityData e : entities) {
            buf.putLong(e.id());
            buf.putFloat((float)e.x());
            buf.putFloat((float)e.y());
            buf.putFloat((float)e.z());
            buf.putFloat((float)e.distance());
            buf.put((byte)(e.isBlockEntity() ? 1 : 0));
            byte[] etype = e.entityType() != null ? e.entityType().getBytes(StandardCharsets.UTF_8) : new byte[]{};
            buf.putInt(etype.length);
            if (etype.length <= 0) continue;
            buf.put(etype);
        }
        buf.putInt(players.size());
        for (PlayerData p : players) {
            buf.putLong(p.id());
            buf.putFloat((float)p.x());
            buf.putFloat((float)p.y());
            buf.putFloat((float)p.z());
        }
        for (float f : cfg = new float[]{16.0f, 32.0f, 1.0f, 0.5f, 0.1f}) {
            buf.putFloat(f);
        }
        buf.flip();
        return buf;
    }

    public static List<Long> deserializeEntityProcessResult(ByteBuffer buffer) {
        int numItems;
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.rewind();
        int rem = buffer.remaining();
        if (rem < 4) {
            return List.of();
        }
        ByteBuffer dup = buffer.duplicate().order(ByteOrder.LITTLE_ENDIAN);
        int candidateNum = dup.getInt(0);
        if (candidateNum >= 0 && 4L + (long)candidateNum * 8L <= (long)rem) {
            ArrayList<Long> ids = new ArrayList<Long>(Math.max(0, candidateNum));
            for (int i = 0; i < candidateNum; ++i) {
                ids.add(dup.getLong(4 + i * 8));
            }
            return ids;
        }
        if (rem >= 12 && (numItems = dup.getInt(8)) >= 0 && 12L + (long)numItems * 8L <= (long)rem) {
            ArrayList<Long> ids = new ArrayList<Long>(Math.max(0, numItems));
            for (int i = 0; i < numItems; ++i) {
                ids.add(dup.getLong(12 + i * 8));
            }
            return ids;
        }
        return List.of();
    }

    public static ByteBuffer serializeItemInput(long tickCount, List<ItemEntityData> items) {
        int baseSize = 28;
        int payload = 0;
        for (ItemEntityData it : items) {
            payload += 28;
            String t = it.itemType();
            if (t == null) continue;
            payload += t.getBytes(StandardCharsets.UTF_8).length;
        }
        ByteBuffer buf = ByteBuffer.allocateDirect(baseSize + payload).order(ByteOrder.LITTLE_ENDIAN);
        buf.putLong(tickCount);
        buf.putInt(items.size());
        for (ItemEntityData it : items) {
            buf.putLong(it.id());
            buf.putInt(it.chunkX());
            buf.putInt(it.chunkZ());
            byte[] name = it.itemType() != null ? it.itemType().getBytes(StandardCharsets.UTF_8) : new byte[]{};
            buf.putInt(name.length);
            if (name.length > 0) {
                buf.put(name);
            }
            buf.putInt(it.count());
            buf.putInt(it.ageSeconds());
        }
        buf.putFloat(0.98f);
        buf.putFloat(0.98f);
        buf.putInt(6000);
        buf.putInt(20);
        buf.flip();
        return buf;
    }

    public static List<ItemEntityData> deserializeItemProcessResult(ByteBuffer buffer) {
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.rewind();
        if (buffer.remaining() < 12) {
            return List.of();
        }
        buffer.getLong();
        int num = buffer.getInt();
        if (num < 0 || num > 1000000) {
            return List.of();
        }
        ArrayList<ItemEntityData> out = new ArrayList<ItemEntityData>(Math.max(0, num));
        for (int i = 0; i < num && buffer.remaining() >= 24; ++i) {
            long id = buffer.getLong();
            int chunkX = buffer.getInt();
            int chunkZ = buffer.getInt();
            int nameLen = buffer.getInt();
            String name = "";
            if (nameLen > 0 && buffer.remaining() >= nameLen) {
                byte[] nb = new byte[nameLen];
                buffer.get(nb);
                name = new String(nb, StandardCharsets.UTF_8);
            } else if (nameLen > 0) {
                buffer.position(buffer.limit());
            }
            int count = buffer.remaining() >= 4 ? buffer.getInt() : 0;
            int ageSeconds = buffer.remaining() >= 4 ? buffer.getInt() : 0;
            out.add(new ItemEntityData(id, chunkX, chunkZ, name, count, ageSeconds));
        }
        return out;
    }

    public static ByteBuffer serializeMobInput(long tickCount, List<MobData> mobs) {
        int base = 28;
        int payload = 0;
        for (MobData m : mobs) {
            payload += 17;
            String t = m.entityType();
            if (t == null) continue;
            payload += t.getBytes(StandardCharsets.UTF_8).length;
        }
        ByteBuffer buf = ByteBuffer.allocateDirect(base + payload).order(ByteOrder.LITTLE_ENDIAN);
        buf.putLong(tickCount);
        buf.putInt(mobs.size());
        for (MobData m : mobs) {
            buf.putLong(m.id());
            buf.putFloat((float)m.distance());
            buf.put((byte)(m.isPassive() ? 1 : 0));
            byte[] nm = m.entityType() != null ? m.entityType().getBytes(StandardCharsets.UTF_8) : new byte[]{};
            buf.putInt(nm.length);
            if (nm.length <= 0) continue;
            buf.put(nm);
        }
        buf.putFloat(16.0f);
        buf.putFloat(32.0f);
        buf.putFloat(1.0f);
        buf.putFloat(0.5f);
        buf.flip();
        return buf;
    }

    public static List<MobData> deserializeMobProcessResult(ByteBuffer buffer) {
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.rewind();
        if (buffer.remaining() < 12) {
            return List.of();
        }
        buffer.getLong();
        int num = buffer.getInt();
        if (num < 0 || num > 1000000) {
            return List.of();
        }
        ArrayList<MobData> out = new ArrayList<MobData>(Math.max(0, num));
        for (int i = 0; i < num && buffer.remaining() >= 17; ++i) {
            long id = buffer.getLong();
            float distance = buffer.getFloat();
            byte passiveB = buffer.get();
            boolean isPassive = passiveB != 0;
            int typeLen = buffer.getInt();
            String type = "";
            if (typeLen > 0 && buffer.remaining() >= typeLen) {
                byte[] tb = new byte[typeLen];
                buffer.get(tb);
                type = new String(tb, StandardCharsets.UTF_8);
            } else if (typeLen > 0) {
                buffer.position(buffer.limit());
            }
            out.add(new MobData(id, distance, isPassive, type));
        }
        return out;
    }

    public static ByteBuffer serializeBlockInput(long tickCount, List<BlockEntityData> blocks) {
        int base = 36;
        int payload = 0;
        for (BlockEntityData b : blocks) {
            payload += 28;
            String t = b.blockType();
            if (t == null) continue;
            payload += t.getBytes(StandardCharsets.UTF_8).length;
        }
        ByteBuffer buf = ByteBuffer.allocateDirect(base + payload).order(ByteOrder.LITTLE_ENDIAN);
        buf.putLong(tickCount);
        buf.putInt(blocks.size());
        for (BlockEntityData b : blocks) {
            buf.putLong(b.id());
            buf.putFloat((float)b.distance());
            byte[] nm = b.blockType() != null ? b.blockType().getBytes(StandardCharsets.UTF_8) : new byte[]{};
            buf.putInt(nm.length);
            if (nm.length > 0) {
                buf.put(nm);
            }
            buf.putInt(b.x());
            buf.putInt(b.y());
            buf.putInt(b.z());
        }
        buf.putFloat(0.1f);
        buf.putFloat(0.05f);
        buf.putInt(8);
        buf.putInt(16);
        buf.flip();
        return buf;
    }
}

